/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.builder.Aggregate;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDoubleMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.AbstractCoefficientQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class GetMaxCoefficientQuery
extends AbstractCoefficientQuery<Double, OraclePreparedStatement> {
    public GetMaxCoefficientQuery(Version version, ModelDescriptor modelDescriptor, Class<? extends ModelType> clazz) {
        super(version, new SqlDoubleMapper(), modelDescriptor, clazz);
    }

    @Override
    protected String getSQLCommand() {
        String string = this.getCoefficientColumn();
        String string2 = this.getCoefficientsSource();
        SqlBuilder sqlBuilder = new SqlBuilder().select(Aggregate.MAX.toString(string)).from(string2).where(Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", this.getSchema());
        hashMap.put("MODEL_NAME", this.getModelName());
        String string3 = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
        return string3;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
    }
}

