/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.tuple.SqlTuple2Mapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.queries.Tuple2;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetCoefficientStatisticsQuery
extends SqlBaseModelQuery<Tuple2<Integer, Double>, OraclePreparedStatement> {
    private static final String MATRIX_V = "V";
    private boolean isStringTarget;
    private List<? extends Object> targets;
    private ISqlQuery<OraclePreparedStatement> query;

    public GetCoefficientStatisticsQuery(Version version, ModelDescriptor modelDescriptor, List<? extends Object> list) {
        super(version, new SqlTuple2Mapper<Integer, Double>(Integer.class, Double.class), modelDescriptor);
        assert (list != null && !list.isEmpty()) : "Send at leat one target";
        this.targets = list;
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new Db122Query() : new OriginalQuery();
        this.isStringTarget = list.get(0) instanceof String;
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*)", "MAX(VALUE)").from(GetCoefficientStatisticsQuery.this.getViewName("DM$VV")).where(Conditional.equals("PARTITION_NAME", GetCoefficientStatisticsQuery.this.getPartitionId()), Conditional.in("FEATURE_NAME", GetCoefficientStatisticsQuery.this.targets));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetCoefficientStatisticsQuery.this.getPartitionId());
            if (GetCoefficientStatisticsQuery.this.isStringTarget) {
                SqlUtils.setStringParameterList(oraclePreparedStatement, "FEATURE_NAME", GetCoefficientStatisticsQuery.this.targets);
            } else {
                SqlUtils.setBigDecimalParameterList(oraclePreparedStatement, "FEATURE_NAME", GetCoefficientStatisticsQuery.this.targets);
            }
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*)", "MAX(VALUE)").from("TABLE(dbms_data_mining.get_model_details_svd(:model))").where(Conditional.equals("MATRIX_TYPE", GetCoefficientStatisticsQuery.MATRIX_V), Conditional.in("MAPPED_FEATURE_ID", GetCoefficientStatisticsQuery.this.targets));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "model", GetCoefficientStatisticsQuery.this.getQualifiedName());
            SqlUtils.setStringAtName(oraclePreparedStatement, "MATRIX_TYPE", GetCoefficientStatisticsQuery.MATRIX_V);
            if (GetCoefficientStatisticsQuery.this.isStringTarget) {
                SqlUtils.setStringParameterList(oraclePreparedStatement, "MAPPED_FEATURE_ID", GetCoefficientStatisticsQuery.this.targets);
            } else {
                SqlUtils.setBigDecimalParameterList(oraclePreparedStatement, "MAPPED_FEATURE_ID", GetCoefficientStatisticsQuery.this.targets);
            }
        }
    }
}

