/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.extensible.r;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class GetRFunctionsQuery
extends SqlQuery<RFunction, OraclePreparedStatement> {
    private static final String ALL_RQ_SCRIPTS = "ALL_RQ_SCRIPTS";
    private static final String SYS_RQ_SCRIPTS = "SYS.RQ_SCRIPTS";
    private static final String[] R_UTILITY_SCRIPTS = new String[]{"RQG$plot1d", "RQG$plot2d", "RQG$hist", "RQG$boxplot", "RQG$smoothScatter", "RQG$cdplot", "RQG$pairs", "RQG$matplot", "RQ$R.Version", "RQ$getRversion", "RQ$packageVersion", "RQ$installed.packages"};
    private String schema;

    public GetRFunctionsQuery(Version version) {
        super(version, new SqlDefaultMapper<RFunction>(RFunction.class));
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.select(new String[0]).from(ALL_RQ_SCRIPTS);
        String string = sqlBuilder.toString();
        sqlBuilder.clear();
        sqlBuilder.select(new String[0]).from(SYS_RQ_SCRIPTS).where(String.format("NAME IN (%s)", Arrays.stream(R_UTILITY_SCRIPTS).map(StringUtils::addSingleQuotes).collect(Collectors.joining(","))));
        String string2 = sqlBuilder.toString();
        String string3 = String.format("%s UNION ALL %s", string, string2);
        sqlBuilder.clear();
        sqlBuilder.select(new String[0]).from(StringUtils.addParentheses(string3)).where(Conditional.equals("OWNER", this.schema));
        String string4 = sqlBuilder.toString();
        return string4;
    }

    public GetRFunctionsQuery setSchema(String string) {
        this.schema = string;
        return this;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "OWNER", this.schema);
    }
}

