/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.build.GetTextFeaturesMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.TextFeature;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetTextFeaturesQuery
extends SqlBaseModelQuery<TextFeature, OraclePreparedStatement> {
    private String attribute;

    public GetTextFeaturesQuery(Version version, ModelDescriptor modelDescriptor, String string) {
        super(version, new GetTextFeaturesMapper(), modelDescriptor);
        this.attribute = string;
    }

    @Override
    protected String getSQLCommand() {
        String string = "select ATTRIBUTE_NAME, FEATURE_NAME, FREQUENCY, TYPE from\n(\n  select t.ATTRIBUTE_NAME, t.FEATURE_NAME, t.FREQUENCY,          SUBSTR(s.ATTRIBUTE_SPEC, INSTR(s.ATTRIBUTE_SPEC,'TOKEN_TYPE:',-1,1)+LENGTH('TOKEN_TYPE:'), 10) \"TYPE\" from\n  table(ODM_UTIL.SYS_DM_TEXT_DF('{$OWNER}.{$MODEL}', '{$COLUMN}')) t, ALL_MINING_MODEL_ATTRIBUTES s\n  where s.OWNER='{$OWNER}' and s.MODEL_NAME='{$MODEL}' and s.ATTRIBUTE_NAME='{$COLUMN}'\n) order by frequency desc, feature_name\n";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.getSchema());
        hashMap.put("MODEL", this.getModelName());
        hashMap.put("COLUMN", this.attribute);
        String string2 = StringUtils.getReplacedString(string, hashMap);
        return string2;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setFetchSize(300);
    }
}

