/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelSettingsQuery
extends SqlQuery<MiningModelSettings, OraclePreparedStatement> {
    private static final String OWNER = "OWNER";
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String SETTING_NAME = "SETTING_NAME";
    private boolean qualifiedModels = false;
    private String owner;
    private List<String> models = Collections.emptyList();
    private List<String> settingNames = Collections.emptyList();

    public GetModelSettingsQuery(Version version) {
        super(version, new SqlDefaultMapper<MiningModelSettings>(MiningModelSettings.class));
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select(new String[0]).from("ALL_MINING_MODEL_SETTINGS").where(Conditional.equals(OWNER, this.owner), Conditional.in(this.qualifiedModels ? "'\"' || OWNER || '\".\"' || MODEL_NAME || '\"'" : MODEL_NAME, MODEL_NAME, this.models), Conditional.in(SETTING_NAME, this.settingNames));
        return sqlBuilder.toString();
    }

    public GetModelSettingsQuery setOwner(String string) {
        this.owner = string;
        return this;
    }

    public GetModelSettingsQuery setModels(List<String> list) {
        assert (list != null) : "Model name list cannot be null";
        this.models = list;
        return this;
    }

    public GetModelSettingsQuery setModel(String string) {
        assert (string != null) : "Model name cannot be null";
        this.models = new ArrayList<String>(1);
        this.models.add(string);
        return this;
    }

    public GetModelSettingsQuery setSettingsFilter(List<String> list) {
        assert (list != null) : "Filter list cannot be null";
        this.settingNames = list;
        return this;
    }

    public GetModelSettingsQuery setSettingsFilter(String string, String ... stringArray) {
        this.settingNames = new ArrayList<String>(stringArray.length + 1);
        this.settingNames.add(string);
        for (String string2 : stringArray) {
            this.settingNames.add(string2);
        }
        return this;
    }

    public GetModelSettingsQuery setQualifiedModels(boolean bl) {
        this.qualifiedModels = bl;
        return this;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName(oraclePreparedStatement, OWNER, this.owner);
        SqlUtils.setStringParameterList(oraclePreparedStatement, MODEL_NAME, this.models);
        SqlUtils.setStringParameterList(oraclePreparedStatement, SETTING_NAME, this.settingNames);
    }
}

