/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.build.GetModelPartitionsMapper;
import oracle.dmt.dataminer.core.model.common.build.partition.ModelPartitions;
import oracle.dmt.dataminer.core.model.common.build.partition.Rule;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelPartitionsQuery
extends SqlQuery<ModelPartitions, OraclePreparedStatement> {
    private static final String RULE_SQL = "SELECT DISTINCT partition_name\n    FROM PartitionsTable\n    WHERE model_name IN ({$MODEL})\n    {$FILTER}";
    private static final String QUERY_BASE = "WITH \nPartitionsTable AS \n  (SELECT mp.owner, mp.model_name, mp.partition_name, mp.position, ma.attribute_name, \n          ma.data_type, mp.column_value\n   FROM all_mining_model_partitions mp\n   INNER JOIN all_mining_model_attributes ma \n    ON  mp.owner       = ma.owner\n    AND mp.model_name  = ma.model_name\n    AND mp.column_name = ma.attribute_name\n   {$OWNER_CONDITIONAL}), \nPartNameTable AS\n (SELECT * FROM\n   ({$QUERY})\n {$FETCH_CONDITIONAL})\nSELECT DISTINCT owner, p.partition_name, position, attribute_name, data_type, \n       NVL(column_value, '(null)') AS column_value \nFROM PartitionsTable p INNER JOIN PartNameTable t ON p.partition_name = t.partition_name  \nWHERE model_name IN ({$MODEL})\nORDER BY partition_name, position";
    private String owner;
    private String modelsQuery;
    private RulesPartitionFilterData filterData;

    public GetModelPartitionsQuery(Version version, String ... stringArray) {
        super(version, new GetModelPartitionsMapper(stringArray.length > 1));
        this.modelsQuery = StringUtils.toSqlList(stringArray);
    }

    public GetModelPartitionsQuery setFilterData(RulesPartitionFilterData rulesPartitionFilterData) {
        this.filterData = rulesPartitionFilterData;
        return this;
    }

    public GetModelPartitionsQuery setOwner(String string) {
        this.owner = string;
        return this;
    }

    @Override
    protected String getSQLCommand() {
        Object object;
        String string;
        if (this.filterData == null) {
            string = StringUtils.getReplacedString(RULE_SQL, "{$FILTER}", "ORDER BY partition_name");
        } else {
            object = this.filterData.getRules();
            boolean bl = this.filterData.isMatchAll();
            StringBuilder stringBuilder = new StringBuilder();
            if (object.isEmpty()) {
                string = StringUtils.getReplacedString(RULE_SQL, "{$FILTER}", "");
            } else {
                for (int i = 0; i < object.size(); ++i) {
                    Rule rule = (Rule)object.get(i);
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("AND attribute_name = ? ");
                    if (rule.getOperator().isStringOperator()) {
                        stringBuilder2.append("AND UPPER(column_value) ");
                    } else {
                        stringBuilder2.append("AND TO_NUMBER(column_value) ");
                    }
                    stringBuilder2.append(rule.getOperator().getSqlQueryOperator());
                    if (this.isLastRule(i)) {
                        stringBuilder2.append("\n   ORDER BY partition_name");
                    } else if (bl) {
                        stringBuilder2.append("\n     INTERSECT\n    ");
                    } else {
                        stringBuilder2.append("\n     UNION\n    ");
                    }
                    String string2 = StringUtils.getReplacedString(RULE_SQL, "{$FILTER}", stringBuilder2.toString());
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
            }
        }
        String string3 = StringUtils.getReplacedString(QUERY_BASE, "{$QUERY}", string);
        object = new HashMap();
        object.put("MODEL", this.modelsQuery);
        object.put("OWNER_CONDITIONAL", StringUtils.isNotEmpty(this.owner) ? "WHERE mp.owner = ?" : "");
        object.put("FETCH_CONDITIONAL", this.filterData != null ? "WHERE ROWNUM <= ?" : "");
        string3 = StringUtils.getReplacedString(string3, (Map<String, String>)object);
        return string3;
    }

    private boolean isLastRule(int n) {
        return n == this.filterData.getRules().size() - 1;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        int n = 1;
        if (this.filterData != null) {
            for (Rule rule : this.filterData.getRules()) {
                oraclePreparedStatement.setString(n++, rule.getPartitionKey().getColumnName());
                if (rule.getOperator().isStringOperator()) {
                    var5_5 = rule.getOperator().toStringQueryParam(rule.getValue());
                    oraclePreparedStatement.setString(n, (String)var5_5);
                } else {
                    var5_5 = Double.valueOf(rule.getValue());
                    oraclePreparedStatement.setDouble(n, ((Double)var5_5).doubleValue());
                }
                ++n;
            }
            oraclePreparedStatement.setInt(n++, this.filterData.getFetchSize());
        }
        if (StringUtils.isNotEmpty(this.owner)) {
            oraclePreparedStatement.setString(n, this.owner);
        }
    }
}

