/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.build.GetModelDetailsGlobalMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelDetailsGlobalQuery
extends SqlBaseModelQuery<NameValuePair, OraclePreparedStatement> {
    private List<String> filters = Collections.emptyList();

    public GetModelDetailsGlobalQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new GetModelDetailsGlobalMapper(version), modelDescriptor);
    }

    public GetModelDetailsGlobalQuery setFilters(String ... stringArray) {
        assert (stringArray != null && stringArray.length > 0) : "Sent at least one filter or remove the method call";
        this.filters = Arrays.asList(stringArray);
        return this;
    }

    @Override
    protected String getSQLCommand() {
        String string = DbVersionHelper.isDB122Up(this.dbVersion) ? this.getSqlCommand122Up() : this.getSqlCommandOriginal();
        return string;
    }

    private String getSqlCommandOriginal() {
        String string = new SqlBuilder().select("GLOBAL_DETAIL_NAME", "GLOBAL_DETAIL_VALUE").from("TABLE(dbms_data_mining.get_model_details_global(:model))").where(Conditional.in("GLOBAL_DETAIL_NAME", this.filters)).toString();
        return string;
    }

    private String getSqlCommand122Up() {
        String string = new SqlBuilder().select("NAME", "NUMERIC_VALUE", "STRING_VALUE").from(this.getViewName("DM$VG")).where(Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId()), Conditional.in("NAME", this.filters)).toString();
        String string2 = string.toString();
        return string2;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
            SqlUtils.setStringParameterList(oraclePreparedStatement, "NAME", this.filters);
        } else {
            SqlUtils.setStringParameterList(oraclePreparedStatement, "GLOBAL_DETAIL_NAME", this.filters);
            SqlUtils.setStringAtName(oraclePreparedStatement, "model", this.getQualifiedName());
        }
    }
}

