/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetWeightsMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetWeightsQuery
extends SqlQuery<PerformanceInfo, OraclePreparedStatement> {
    private static final String[] COLUMNS = new String[]{"TARGET_VALUE", "CLASS_WEIGHT"};
    private String qualifiedName;
    private String partitionId;

    public GetWeightsQuery(Version version, String string, String string2, String string3, String string4) {
        super(version, new GetWeightsMapper(version, string4));
        assert (string2 != null) : "Source table cannot be null";
        assert (string4 != null) : "Target Column Data Type cannot be null";
        this.qualifiedName = StringUtils.getQualifiedName(string, string2, false);
        this.partitionId = string3;
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            sqlBuilder.select("TARGET_VALUE", "TARGET_WEIGHT").from(this.qualifiedName).where(Conditional.equals("PARTITION_NAME", this.partitionId));
        } else {
            sqlBuilder.select(COLUMNS).from(this.qualifiedName);
        }
        return sqlBuilder.toString();
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", this.partitionId);
    }
}

