/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetTargetValuesQuery<T>
extends SqlBaseModelQuery<T, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetTargetValuesQuery(Version version, SqlMapper<T> sqlMapper, ModelDescriptor modelDescriptor) {
        super(version, sqlMapper, modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private static final String QUERY = "select distinct(TARGET_VALUE) from {$VIEW}";

        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = StringUtils.getReplacedString(QUERY, GetTargetValuesQuery.this.getViewName("DM$VT"));
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetTargetValuesQuery.this.getQualifiedName();
            return "select PREDICTION from table(prediction_set(" + string + " using))";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        }
    }
}

