/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapMapperEntry;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapSingleRowMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetItemGlobalMetricsQuery
extends SqlBaseModelQuery<Map<String, Object>, OraclePreparedStatement> {
    private static final SqlMapMapperEntry[] entries = new SqlMapMapperEntry[]{new SqlMapMapperEntry("MIN_ATTRIBUTE_NAME", String.class), new SqlMapMapperEntry("MAX_ATTRIBUTE_NAME", String.class), new SqlMapMapperEntry("MIN_ATTRIBUTE_SUBNAME", String.class), new SqlMapMapperEntry("MAX_ATTRIBUTE_SUBNAME", String.class), new SqlMapMapperEntry("SINGLE_ITEMSET_COUNT", Integer.class), new SqlMapMapperEntry("ATTRIBUTE_SUBNAME_COUNT", Integer.class), new SqlMapMapperEntry("MIN_ATTRIBUTE_VALUE", Object.class), new SqlMapMapperEntry("MAX_ATTRIBUTE_VALUE", Object.class)};

    public GetItemGlobalMetricsQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlMapSingleRowMapper(entries), modelDescriptor);
    }

    @Override
    public String getSQLCommand() {
        String string = DbVersionHelper.isDB122Up(this.dbVersion) ? this.getSqlCommand122Up() : this.getSqlCommandOriginal();
        return string;
    }

    private String getSqlCommandOriginal() {
        String string = "SELECT count(itemset_id) SINGLE_ITEMSET_COUNT,\n  MIN(item.attribute_name) MIN_ATTRIBUTE_NAME,\n  MAX(item.attribute_name) MAX_ATTRIBUTE_NAME,\n  COUNT(item.attribute_subname) ATTRIBUTE_SUBNAME_COUNT,\n  MIN(item.attribute_subname) MIN_ATTRIBUTE_SUBNAME,\n  MAX(item.attribute_subname) MAX_ATTRIBUTE_SUBNAME,\n  MIN(nvl(TO_CHAR(item.attribute_num_value), item.attribute_str_value)) MIN_ATTRIBUTE_VALUE,\n  MAX(nvl(TO_CHAR(item.attribute_num_value), item.attribute_str_value)) MAX_ATTRIBUTE_VALUE\nFROM TABLE(dbms_data_mining.get_frequent_itemsets(:model, NULL, 1{$PARTITION})) t, TABLE(t.items) item";
        String string2 = this.isPartitioned() ? ", :partition" : "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PARTITION", string2);
        String string3 = StringUtils.getReplacedString(string, hashMap);
        return string3;
    }

    private String getSqlCommand122Up() {
        String string = "Select \n  count(itemset_id)  SINGLE_ITEMSET_COUNT,\n  nvl(min(item.iname),' ') MIN_ATTRIBUTE_NAME,\n  nvl(max(item.iname),' ') MAX_ATTRIBUTE_NAME,\n  count(item.isubname) ATTRIBUTE_SUBNAME_COUNT,\n  nvl(min(item.isubname),' ') MIN_ATTRIBUTE_SUBNAME,\n  nvl(max(item.isubname),' ') MAX_ATTRIBUTE_SUBNAME,\n  min(item.ivalue) MIN_ATTRIBUTE_VALUE,\n  max(item.ivalue) MAX_ATTRIBUTE_VALUE\nfrom {$OWNER}.DM$VI{$MODEL_NAME},  \n  XMLTable('/itemset/item' passing ITEMSET \n           columns \n              \"INAME\"    varchar(128) PATH 'item_name',\n              \"ISUBNAME\" varchar(128) PATH 'item_subname',\n              \"IVALUE\"   varchar(128) PATH 'item_value' ) AS item\nwhere PARTITION_NAME {$PARTITION} \nand NUMBER_OF_ITEMS = 1";
        String string2 = this.isPartitioned() ? " = :partition " : "is null";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PARTITION", string2);
        hashMap.put("OWNER", this.getSchema());
        hashMap.put("MODEL_NAME", this.getModelName());
        String string3 = StringUtils.getReplacedString(string, hashMap);
        return string3;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (!DbVersionHelper.isDB122Up(this.dbVersion)) {
            oraclePreparedStatement.setStringAtName("model", this.getQualifiedName());
        }
        SqlUtils.setStringAtName(oraclePreparedStatement, "partition", this.getPartitionId());
    }
}

