/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileScope;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.FileTable;
import oracle.ide.file.FileTableVisitor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.util.IntHashMap;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.types.JavaTypeParser;
import oracle.jdevimpl.java.types.JotParser;
import oracle.jdevimpl.java.types.Modifier;

public class JavaTypeTable {
    private static final boolean PARSE_ALL_CLASS_FILES = true;
    private static final Maps.CacheMap<FileSetTable, JavaTypeTable> INSTANCES = new Maps.CacheMap((Maps.CacheStrategy)new Maps.UnboundedCacheStrategy(100, 0.75f, Maps.CacheMap.Canonicity.CANONICAL, Maps.CacheMap.Strength.SOFT));
    private static final String NAMESPACE_KEY = "$java.types$";
    private static final int FORMAT = 1;
    private static final int NAME_MATCHES_FILE = 0x1000000;
    private static final int PACKAGE_MATCHES_FILE = 0x2000000;
    private static final boolean ENABLED = Boolean.getBoolean("jdev.parse.java.types");
    private final AssemblyFactory FACTORY = new JavaTypeTableAssemblyFactory();
    private static NameSpace PINNED;
    private static int pinCount;
    private final FileSetTable fileTable;
    private final Lock lock = new ReentrantLock();
    private Map<Integer, Collection<TypeInfo>> data;
    private IntHashMap<Collection<Integer>> reverse;
    private int version = 0;
    private long cookie = -1L;
    private IntHashMap<Pair<String, String>> fileTableCache;
    private int fileTableCacheCounter;

    public static boolean isEnabled() {
        return ENABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaTypeTable getInstance(FileSetTable fileTable) {
        if (fileTable == null) {
            throw new NullArgumentException("null file table");
        }
        if (!ENABLED) {
            return null;
        }
        Maps.CacheMap<FileSetTable, JavaTypeTable> cacheMap = INSTANCES;
        synchronized (cacheMap) {
            JavaTypeTable table = (JavaTypeTable)INSTANCES.get((Object)fileTable);
            if (table == null) {
                table = new JavaTypeTable(fileTable);
                INSTANCES.put((Object)fileTable, (Object)table);
            }
            return table;
        }
    }

    public static synchronized void pinNameSpace(Storage storage) {
        if (ENABLED && pinCount++ == 0) {
            storage.open();
            PINNED = storage.getNameSpace(NAMESPACE_KEY);
        }
    }

    public static synchronized void unpinNameSpace(Storage storage) {
        if (ENABLED && --pinCount == 0) {
            PINNED.close();
            PINNED = null;
            storage.close();
        }
    }

    private JavaTypeTable(FileSetTable fileTable) {
        this.fileTable = fileTable;
    }

    public FileTable getFileTable() {
        return this.fileTable;
    }

    private void acquireFileTableCache() throws IOException, InterruptedException {
        if (this.fileTableCacheCounter++ == 0) {
            this.fileTableCache = new IntHashMap();
            this.fileTable.visitFiles(new FileTableVisitor(){

                public FileTableVisitor.Result visitFile(int id, String parentPath, String fileName, FileChange.Type type) {
                    if (type != FileChange.Type.REMOVED) {
                        JavaTypeTable.this.fileTableCache.put(id, (Object)new Pair((Object)parentPath, (Object)fileName));
                    }
                    return FileTableVisitor.Result.CONTINUE;
                }
            });
        }
    }

    private void releaseFileTableCache() {
        if (--this.fileTableCacheCounter == 0) {
            this.fileTableCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitTypes(JavaTypeVisitor visitor) throws IOException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.update();
            this.acquireFileTableCache();
            try {
                block6: for (Collection<TypeInfo> c : this.data.values()) {
                    JavaTypeTable.checkInterrupt();
                    for (TypeInfo info : c) {
                        if (!this.fileTableCache.containsKey(info.id) || visitor.visit(info) == Result.CONTINUE) continue;
                        continue block6;
                    }
                }
            }
            finally {
                this.releaseFileTableCache();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(String fqTypeName) throws IOException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Iterator iterator;
            this.update();
            IntHashMap<Collection<Integer>> m = this.getReverseMap();
            Collection ids = (Collection)m.get(fqTypeName.hashCode());
            if (ids != null) {
                iterator = ids.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    Collection<TypeInfo> infos = this.data.get(id);
                    if (infos == null) continue;
                    for (TypeInfo info : infos) {
                        if (!fqTypeName.equals(info.getQualifiedNameUncached())) continue;
                        URL uRL = info.getURL();
                        return uRL;
                    }
                }
            }
            iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntHashMap<Collection<Integer>> getReverseMap() throws InterruptedException, IOException {
        this.lock.lock();
        try {
            if (this.reverse == null) {
                this.acquireFileTableCache();
                try {
                    this.reverse = new IntHashMap();
                    for (Collection collection : this.data.values()) {
                        for (TypeInfo info : collection) {
                            int hash = info.getQualifiedName().hashCode();
                            ArrayList<Integer> ids = (ArrayList<Integer>)this.reverse.get(hash);
                            if (ids == null) {
                                ids = new ArrayList<Integer>();
                                this.reverse.put(hash, ids);
                            }
                            ids.add(info.id);
                        }
                    }
                }
                finally {
                    this.releaseFileTableCache();
                }
            }
            IntHashMap<Collection<Integer>> intHashMap = this.reverse;
            return intHashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSession beginUpdate() throws IOException, InterruptedException {
        UpdateSession session = null;
        this.lock.lockInterruptibly();
        try {
            if (this.version == 0) {
                this.load();
            }
            final Pair versionInfo = new Pair((Object)this.version, (Object)this.cookie);
            final IntHashMap toUpdate = new IntHashMap();
            FileChangeListener listener = new FileChangeListener(){

                public void filesChanged(FileScope scope, FileChanges changes) {
                    for (FileChange change : changes) {
                        URL url = change.getURL();
                        if (!JavaTypeTable.this.isJavaFile(url)) continue;
                        FileChange.Type type = change.getChangeType();
                        if (type == FileChange.Type.ADDED || type == FileChange.Type.MODIFIED || type == FileChange.Type.BUFFER_MODIFIED) {
                            toUpdate.put(change.getId(), (Object)url);
                            continue;
                        }
                        if (type != FileChange.Type.REMOVED) continue;
                        JavaTypeTable.this.remove(change.getId());
                    }
                    versionInfo.setFirst((Object)changes.getVersion());
                    versionInfo.setSecond((Object)changes.getCookie());
                }
            };
            while (true) {
                try {
                    this.fileTable.getChangesSince(this.version, this.cookie, listener);
                }
                catch (FileChangesExpiredException e) {
                    this.data.clear();
                    this.reverse = null;
                    this.version = 0;
                    this.cookie = -1L;
                    continue;
                }
                break;
            }
            session = new UpdateSession((Integer)versionInfo.getFirst(), (Long)versionInfo.getSecond(), (IntHashMap<URL>)toUpdate, this.getParser());
        }
        finally {
            if (session == null) {
                this.lock.unlock();
            }
        }
        return session;
    }

    public void update() throws InterruptedException, IOException {
        PerformanceLogger.get().startTiming("JavaTypeTable.update");
        try {
            Node.beginThreadNodeUsageCycle();
            try {
                this.beginUpdate().finish();
            }
            finally {
                Node.endThreadNodeUsageCycle();
            }
        }
        finally {
            PerformanceLogger.get().stopTiming("JavaTypeTable.update", "Updated Java types in " + this.fileTable.getFileSet().toString());
        }
    }

    private void load() {
        try {
            this.loadFrom(this.runIO(new LoadTask()));
        }
        catch (IOException e) {
            JavaTypeTable.getLogger().log(Level.SEVERE, "Unable to load " + this, e);
            this.loadFrom(new Record());
        }
    }

    private void loadFrom(Record record) {
        this.data = record.data;
        this.version = record.version;
        this.cookie = record.cookie;
    }

    private void save() {
        try {
            Record record = new Record(this.version, this.cookie, this.data);
            this.runIO(new SaveTask(record));
        }
        catch (IOException e) {
            JavaTypeTable.getLogger().log(Level.SEVERE, "Unable to save " + this, e);
        }
    }

    private <T> T runIO(Callable<T> callable) throws IOException {
        try {
            return (T)this.fileTable.getStorage().runWhileOpen(callable);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            JavaTypeTable.getLogger().log(Level.SEVERE, "Unexpected exception", e);
            return null;
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(JavaTypeTable.class.getName());
    }

    private static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private void updateFile(URL url, int id, JavaTypeParser parser) {
        if (JavaTypeTable.isJavaSourceFile(url)) {
            this.updateFile(url, id, parser.getTypes(url));
        } else {
            this.updateFile(url, id, parser.getTypes(url));
        }
    }

    private void updateFile(URL url, int id, Collection<JavaTypeParser.JavaType> types) {
        String fileName = URLFileSystem.getName((URL)url);
        fileName = fileName.replace('$', '.');
        String fileNameWithDot = fileName + ".";
        String filePathPkg = this.getPackageName(url);
        HashSet<TypeInfo> infos = new HashSet<TypeInfo>();
        for (JavaTypeParser.JavaType type : types) {
            String name = type.getName();
            if (name.equals(fileName)) {
                name = null;
            } else if (name.startsWith(fileNameWithDot)) {
                name = name.substring(fileName.length());
            }
            String pkg = type.getPackage();
            if (pkg.equals(filePathPkg)) {
                pkg = null;
            }
            infos.add(new TypeInfo(id, name, pkg, type.getModifiers()));
        }
        if (!infos.isEmpty()) {
            this.store(id, infos);
        }
    }

    private String getPackageName(URL url) {
        URL parent = URLFileSystem.getParent((URL)url);
        if (parent != null) {
            String pkg = this.fileTable.getRelativePath(parent).replace('/', '.');
            if (pkg.endsWith(".")) {
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            return pkg;
        }
        return null;
    }

    private void remove(int id) {
        if (this.data.remove(id) != null) {
            this.reverse = null;
        }
    }

    private void store(int id, Collection<TypeInfo> types) {
        this.data.put(id, types);
        this.reverse = null;
    }

    private JavaTypeParser getParser() {
        return new JotParser(this.fileTable.getFileSet().getRoot());
    }

    private JavaManager getJavaManager() {
        return JavaManager.getInstance(new URLPath(), new URLPath());
    }

    private boolean isJavaFile(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        return ".java".equals(suffix) || ".class".equals(suffix);
    }

    static boolean isJavaSourceFile(URL url) {
        return ".java".equals(URLFileSystem.getSuffix((URL)url));
    }

    public String toString() {
        return this.fileTable.getFileSet().toString();
    }

    private final class JavaTypeTableAssemblyFactory
    extends ObjectFactory {
        private JavaTypeTableAssemblyFactory() {
        }

        public byte getObjectCode() {
            return -52;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int format = input.readInt();
            if (format != 1) {
                throw new AssemblyException("Format mistmatch, expected=1, actual=" + format, (AssemblyFactory)this);
            }
            int version = input.readInt();
            long cookie = input.readLong();
            int size = input.readInt();
            ConcurrentHashMap<Integer, Collection<TypeInfo>> data = new ConcurrentHashMap<Integer, Collection<TypeInfo>>();
            for (int i = 0; i < size; ++i) {
                int id = VariableLengthIntArrayFactory.readVariableLengthInt((DataInput)input);
                ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
                int numEntries = VariableLengthIntArrayFactory.readVariableLengthInt((DataInput)input);
                for (int j = 0; j < numEntries; ++j) {
                    int modifiers = input.readInt();
                    String name = null;
                    if ((modifiers & 0x1000000) == 0) {
                        name = input.readUTF();
                    }
                    String pkg = null;
                    if ((modifiers & 0x2000000) == 0) {
                        pkg = input.readUTF();
                    }
                    types.add(new TypeInfo(id, name, pkg, modifiers));
                }
                data.put(id, types);
            }
            return new Record(version, cookie, data);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Record record = (Record)object;
            output.writeInt(1);
            output.writeInt(record.version);
            output.writeLong(record.cookie);
            output.writeInt(record.data.size());
            for (Map.Entry<Integer, Collection<TypeInfo>> entry : record.data.entrySet()) {
                int id = entry.getKey();
                VariableLengthIntArrayFactory.writeVariableLengthInt((DataOutput)output, (int)id);
                VariableLengthIntArrayFactory.writeVariableLengthInt((DataOutput)output, (int)entry.getValue().size());
                for (TypeInfo info : entry.getValue()) {
                    int modifiers = info.modifiers;
                    if (info.name == null) {
                        modifiers |= 0x1000000;
                    }
                    if (info.pkg == null) {
                        modifiers |= 0x2000000;
                    }
                    output.writeInt(modifiers);
                    if (info.name != null) {
                        output.writeUTF(info.name);
                    }
                    if (info.pkg == null) continue;
                    output.writeUTF(info.pkg);
                }
            }
        }
    }

    public class TypeInfo {
        private final int id;
        private final String name;
        private final String pkg;
        private final int modifiers;

        TypeInfo(int id, String name, String pkg, int modifiers) {
            this.id = id;
            this.name = name;
            this.pkg = pkg;
            this.modifiers = modifiers;
        }

        public String getName() {
            if (this.name == null || this.name.startsWith(".")) {
                String fileName = null;
                if (JavaTypeTable.this.fileTableCache != null) {
                    int lastDot;
                    Pair cached = (Pair)JavaTypeTable.this.fileTableCache.get(this.id);
                    if (cached != null) {
                        fileName = (String)cached.getSecond();
                    }
                    if ((lastDot = fileName.lastIndexOf(46)) != -1) {
                        fileName = fileName.substring(0, lastDot);
                    }
                }
                if (fileName != null) {
                    fileName = fileName.replace('$', '.');
                    return this.name == null ? fileName : fileName + this.name;
                }
            }
            return this.name;
        }

        private String getNameUncached() throws IOException, InterruptedException {
            URL url;
            if ((this.name == null || this.name.startsWith(".")) && (url = this.getURL()) != null) {
                String fileName = URLFileSystem.getName((URL)url);
                fileName = fileName.replace('$', '.');
                if (this.name == null) {
                    return fileName;
                }
                return fileName + this.name;
            }
            return this.name;
        }

        public String getQualifiedName() {
            String pkg = this.getPackage();
            String name = this.getName();
            return pkg != null && name != null ? pkg + "." + name : null;
        }

        private String getQualifiedNameUncached() throws IOException, InterruptedException {
            String n = null;
            String packagePath = null;
            if (this.name == null || this.name.startsWith(".")) {
                String relativePath = JavaTypeTable.this.fileTable.getRelativePath(this.id);
                if (relativePath != null) {
                    String fileName;
                    int lastSlash = relativePath.lastIndexOf(47);
                    if (lastSlash != -1) {
                        fileName = relativePath.substring(lastSlash + 1);
                        packagePath = relativePath.substring(0, lastSlash);
                    } else {
                        fileName = relativePath;
                        packagePath = "";
                    }
                    int lastDot = fileName.lastIndexOf(46);
                    if (lastDot != -1) {
                        fileName = fileName.substring(0, lastDot);
                    }
                    fileName = fileName.replace('$', '.');
                    n = this.name == null ? fileName : fileName + this.name;
                }
            } else {
                n = this.name;
            }
            String p = null;
            if (this.pkg == null) {
                if (packagePath == null) {
                    packagePath = JavaTypeTable.this.fileTable.getParentPath(this.id);
                }
                if (packagePath != null) {
                    if ((packagePath = packagePath.replace('/', '.')).endsWith(".")) {
                        packagePath = packagePath.substring(0, packagePath.length() - 1);
                    }
                    p = packagePath;
                }
            } else {
                p = this.pkg;
            }
            return p != null && n != null ? p + "." + n : null;
        }

        public String getPackage() {
            if (this.pkg == null) {
                String packagePath = null;
                if (JavaTypeTable.this.fileTableCache != null) {
                    packagePath = (String)((Pair)JavaTypeTable.this.fileTableCache.get(this.id)).getFirst();
                }
                if (packagePath != null) {
                    if ((packagePath = packagePath.replace('/', '.')).endsWith(".")) {
                        packagePath = packagePath.substring(0, packagePath.length() - 1);
                    }
                    return packagePath;
                }
            }
            return this.pkg;
        }

        public URL getURL() throws InterruptedException, IOException {
            return JavaTypeTable.this.fileTable.getURL(this.id);
        }

        public Pair<Integer, Integer> getLocation() throws InterruptedException, IOException {
            SourceName sourceName = this.getSourceName();
            if (sourceName != null) {
                int start = sourceName.getStartOffset();
                int length = sourceName.getEndOffset() - start;
                return new Pair((Object)start, (Object)length);
            }
            return null;
        }

        private SourceName getSourceName() throws InterruptedException, IOException {
            SourceClass sourceClass = this.getSourceClass();
            if (sourceClass != null) {
                return sourceClass.getNameElement();
            }
            return null;
        }

        private SourceClass getSourceClass() throws InterruptedException, IOException {
            SourceFile file = JavaTypeTable.this.getJavaManager().getSourceFile(this.getURL());
            if (file != null) {
                String[] parts = this.getNameUncached().split("\\.");
                SourceClass sourceClass = file.getSourceClass(parts[0]);
                for (int i = 1; i < parts.length && sourceClass != null; sourceClass = sourceClass.getSourceClass(parts[i]), ++i) {
                }
                return sourceClass;
            }
            return null;
        }

        public boolean isInterface() {
            return Modifier.isInterface(this.modifiers);
        }

        public boolean isEnum() {
            return Modifier.isEnum(this.modifiers);
        }

        public boolean isAnnotation() {
            return Modifier.isAnnotation(this.modifiers);
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.modifiers);
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.modifiers);
        }

        public boolean isPrivate() {
            return Modifier.isPrivate(this.modifiers);
        }

        public boolean isFinal() {
            return Modifier.isFinal(this.modifiers);
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.modifiers);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.modifiers);
        }
    }

    public static interface JavaTypeVisitor {
        public Result visit(TypeInfo var1) throws InterruptedException;
    }

    public static enum Result {
        CONTINUE,
        STOP;

    }

    public class UpdateSession {
        private final int version;
        private final long cookie;
        private final IntHashMap<URL> toUpdate;
        private final JavaTypeParser parser;

        UpdateSession(int version, long cookie, IntHashMap<URL> toUpdate, JavaTypeParser parser) {
            this.version = version;
            this.cookie = cookie;
            this.toUpdate = toUpdate;
            this.parser = parser;
        }

        public void update(URL url, int id, ReadTextBuffer buffer) {
            JavaTypeTable.this.updateFile(url, id, this.parser.getTypes(buffer, url));
            this.toUpdate.remove(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            try {
                Iterator iterator = this.toUpdate.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    URL url = (URL)this.toUpdate.get(id);
                    JavaTypeTable.this.updateFile(url, id, this.parser);
                }
                if (JavaTypeTable.this.version != this.version || JavaTypeTable.this.cookie != this.cookie) {
                    JavaTypeTable.this.version = this.version;
                    JavaTypeTable.this.cookie = this.cookie;
                    JavaTypeTable.this.save();
                }
                this.parser.dispose();
            }
            finally {
                JavaTypeTable.this.lock.unlock();
            }
        }
    }

    private final class LoadTask
    extends IOTask<Record> {
        private LoadTask() {
        }

        @Override
        protected Record run(NameSpace namespace, String key) throws IOException {
            byte[] record = namespace.getRecord(key);
            if (record != null) {
                try {
                    return (Record)JavaTypeTable.this.FACTORY.assemble(record);
                }
                catch (AssemblyException assemblyException) {
                    // empty catch block
                }
            }
            return new Record();
        }
    }

    private final class Record {
        private final int version;
        private final long cookie;
        private final Map<Integer, Collection<TypeInfo>> data;

        Record() {
            this(0, -1L, new ConcurrentHashMap<Integer, Collection<TypeInfo>>());
        }

        Record(int version, long cookie, Map<Integer, Collection<TypeInfo>> data) {
            this.version = version;
            this.cookie = cookie;
            this.data = data;
        }
    }

    private final class SaveTask
    extends IOTask<Void> {
        private final Record record;

        SaveTask(Record record) {
            this.record = record;
        }

        @Override
        protected Void run(NameSpace namespace, String key) throws IOException {
            try {
                namespace.putRecord(key, JavaTypeTable.this.FACTORY.disassemble((Object)this.record));
            }
            catch (AssemblyException e) {
                throw new IOException("Cannot disassemble " + JavaTypeTable.this.fileTable, e);
            }
            return null;
        }
    }

    private abstract class IOTask<T>
    implements Callable<T> {
        private IOTask() {
        }

        protected abstract T run(NameSpace var1, String var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws IOException {
            Storage storage = JavaTypeTable.this.fileTable.getStorage();
            NameSpace namespace = storage.getNameSpace(JavaTypeTable.NAMESPACE_KEY);
            if (namespace == null) {
                throw new IOException("Unable to open namespace for " + JavaTypeTable.this.fileTable);
            }
            try {
                T t = this.run(namespace, JavaTypeTable.this.fileTable.getStorageKey());
                return t;
            }
            finally {
                namespace.close();
            }
        }
    }
}

