/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.html.HTMLEditorKit;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.cmtimpl.Res;

final class JbEventChooserPanel
extends JPanel
implements VetoableChangeListener {
    private CmtPropertyState state;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String value;
    private JLabel promptLabel = new JLabel();
    private JLabel scopeLabel = new JLabel();
    private JTextField valueText = new JTextField();
    private JLabel argsLabel = new JLabel();
    private JLabel closeBraceLabel = new JLabel();
    private JLabel sampleLabel = new JLabel();
    private JEditorPane sampleArea = new JEditorPane();
    private GridBagLayout mainLayout = new GridBagLayout();

    public JbEventChooserPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guieventeditor_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPropertyState(CmtPropertyState state) {
        Object name = null;
        this.state = state;
        if (state != null) {
            this.value = (String)state.getValue();
            Object object = name = this.value != null ? this.value.trim() : null;
            if (name == null || ((String)name).length() == 0) {
                CmtSubcomponent sub = state.getSubcomponent();
                CmtProperty prop = state.getProperty();
                name = sub != null && prop != null ? sub.getName() + "_" + prop.getName() : "stub";
            }
        } else {
            this.value = null;
        }
        this.valueText.setText((String)name);
        this.valueText.selectAll();
        this.updateSample(null);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if ("closed".equals(e.getPropertyName()) && ((Boolean)e.getNewValue()).booleanValue()) {
            String name = this.valueText.getText().trim();
            if (name.length() > 0 && !IdeUtil.isJavaIdentifier((String)name)) {
                JOptionPane.showMessageDialog(this, Res.getString(54), Res.getString(48), 0);
                throw new PropertyVetoException(name, e);
            }
            this.support.firePropertyChange(null, this.value, name);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.promptLabel.setText(Res.getString(52));
        ResourceUtils.resLabel((JLabel)this.scopeLabel, (Component)this.valueText, (String)"&void");
        this.valueText.setText("stub");
        this.valueText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JbEventChooserPanel.this.updateSample(e);
            }
        });
        this.argsLabel.setText("(...) {");
        this.closeBraceLabel.setText("}");
        this.sampleLabel.setText(Res.getString(53));
        this.sampleArea.setEditable(false);
        this.sampleArea.setRequestFocusEnabled(false);
        this.sampleArea.setBackground(SystemColor.window);
        this.sampleArea.setEditorKit(new HTMLEditorKit());
        this.sampleArea.setForeground(Color.BLACK);
        FontMetrics metrics = this.sampleArea.getFontMetrics(this.sampleArea.getFont());
        int height = (metrics.getMaxAscent() + metrics.getMaxDescent()) * 5;
        Dimension dimension = this.sampleArea.getMinimumSize();
        this.add((Component)this.promptLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.scopeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.valueText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 0, 0), 0, 0));
        this.add((Component)this.argsLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 2, 0, 5), 0, 0));
        this.add((Component)this.closeBraceLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.sampleLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.sampleArea, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, height));
    }

    private void updateSample(KeyEvent e) {
        String name = this.valueText.getText().trim();
        if (name.length() == 0) {
            this.sampleArea.setText("<html><head></head><body><br>" + Res.getString(55) + "<br></body></html>");
        } else {
            StringBuffer text = new StringBuffer("<html><head></head><body>public void ");
            text.append(this.state.getProperty().getName());
            text.append("(...) {<br>&nbsp;&nbsp;<B>");
            text.append(this.valueText.getText());
            text.append("</B>(...);<br>}</body></html>");
            this.sampleArea.setText(text.toString());
        }
    }
}

