/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.uicanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.LayoutConstants;
import oracle.jdeveloper.uieditor.uicanvas.SelectNib;
import oracle.jdeveloper.uieditor.uicanvas.SelectionEffects;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;
import oracle.jdeveloper.uieditor.uicanvas.UIModel;

public abstract class AbstractAssistant
implements LayoutAssistant {
    public static JMenu ZORDER_MENU;
    public static JMenuItem MOVE_TO_FIRST_ITEM;
    public static JMenuItem MOVE_TO_LAST_ITEM;
    protected static IdeAction MOVE_TO_FIRST_ACTION;
    protected static IdeAction MOVE_TO_LAST_ACTION;

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public String getInitializer() {
        return null;
    }

    @Override
    public void prepareAddComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset, Dimension size) {
        this.changeZ(node, toNode, this.calcBestZ(node, toNode, location, size, null));
        AbstractAssistant.removeBoundsSetting(node);
    }

    @Override
    public void prepareMoveComponent(CmtModelNode node, CmtModelNode toNode, Point location, Point offset) {
        Object obj;
        CmtSubcomponent cmtSub = node != null ? node.getSubcomponent() : null;
        Object object = obj = cmtSub != null ? cmtSub.getLiveInstance() : null;
        if (obj instanceof Component) {
            Component comp = (Component)obj;
            this.prepareAddComponent(node, toNode, location, offset, comp.getSize());
        }
    }

    @Override
    public void layoutChanged(CmtModelNode container) {
    }

    @Override
    public void prepareChangeLayout(CmtModelNode parent) {
        ArrayList children = this.sortedNodes(parent);
        ArrayList<Object> values = new ArrayList<Object>();
        ListIterator iter = children.listIterator(children.size());
        Point offset = new Point(0, 0);
        while (iter.hasPrevious()) {
            CmtModelNode child = (CmtModelNode)iter.previous();
            CmtSubcomponent sub = child != null ? child.getSubcomponent() : null;
            Object obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            values.add(child);
            values.add(((Component)obj).getBounds());
        }
        int count = values.size();
        for (int i = 0; i < count; i += 2) {
            try {
                CmtModelNode child = (CmtModelNode)values.get(i);
                Rectangle rect = (Rectangle)values.get(i + 1);
                this.prepareAddComponent(child, parent, new Point(rect.x, rect.y), offset, new Dimension(rect.width, rect.height));
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    @Override
    public void prepareResizeComponent(CmtModelNode node, SelectionEffects effects, SelectNib nib) {
        Rectangle bounds = nib.getNibBounds();
        this.prepareAddComponent(node, (CmtModelNode)node.getParent(), new Point(bounds.x, bounds.y), new Point(0, 0), new Dimension(bounds.width, bounds.height));
    }

    @Override
    public String prepareResizeStatus(CmtModelNode node, Point location, Dimension size) {
        return this.prepareAddStatus(node, (CmtModelNode)node.getParent(), location, size);
    }

    @Override
    public String resizeAction(Point location, SelectionEffects effects, SelectNib nib) {
        return "";
    }

    @Override
    public void prepareSelectComponent(CmtModelNode node, SelectionEffects effects) {
        Object obj;
        UICanvas canvas = effects.getUICanvas();
        effects.hideAll();
        canvas.getBoxEffects().hideAll();
        CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
        Object object = obj = sub != null ? sub.getLiveInstance() : null;
        if (!(obj instanceof Component)) {
            return;
        }
        Component component = (Component)obj;
        CmtModelNode parent = (CmtModelNode)node.getParent();
        this.prepareSelectDescendant(parent, node, effects);
        Point parentLocation = null;
        parentLocation = parent == null ? new Point(0, 0) : canvas.getAbsoluteLocation(parent.getSubcomponent().getAsContainer());
        Point p = canvas.getAbsoluteLocation(component);
        Dimension s = component.getSize();
        int xs = p.x;
        int ys = p.y;
        int xe = p.x + s.width - 1;
        int ye = p.y + s.height - 1;
        int xm = (xs + xe) / 2;
        int ym = (ys + ye) / 2;
        int startSub = 0;
        if (node.getAllowsChildren()) {
            startSub = -1;
        }
        SelectNib[] selectNibs = effects.getSelectNibs(4 - startSub);
        int n = 0;
        for (int j = startSub; j < 4; ++j) {
            int x;
            int y = switch (j) {
                case 0 -> {
                    x = xs;
                    yield ys;
                }
                case 1 -> {
                    x = xe;
                    yield ys;
                }
                case 2 -> {
                    x = xs;
                    yield ye;
                }
                case 3 -> {
                    x = xe;
                    yield ye;
                }
                default -> {
                    x = xm;
                    yield ym;
                }
            };
            SelectNib nib = selectNibs[n];
            Dimension nibSize = nib.getSize();
            nib.setBackground(j < 0 ? Color.black : SystemColor.controlShadow);
            nib.target = node;
            nib.setRectangleLocation(p);
            nib.setRectangleDimension(s);
            nib.setLayoutAssistant(this);
            nib.parentLocation = parentLocation;
            nib.use = 0;
            if (j == -1) {
                nib.setSelectable(true);
                nib.type = 8;
            } else {
                nib.setSelectable(false);
                nib.type = j;
            }
            effects.moveNib(nib, x - nibSize.width / 2, y - nibSize.height / 2);
            nib.setVisible(true);
            ++n;
        }
    }

    @Override
    public void prepareSelectDescendant(CmtModelNode parent, CmtModelNode child, SelectionEffects effects) {
        if (parent != null) {
            LayoutAssistant assistant;
            UICanvas canvas = effects.getUICanvas();
            CmtModelNode ancestor = (CmtModelNode)parent.getParent();
            LayoutAssistant layoutAssistant = assistant = ancestor != null ? canvas.getLayoutAssistant(ancestor) : null;
            if (assistant != null) {
                assistant.prepareSelectDescendant(ancestor, parent, effects);
            }
        }
        if (child != null) {
            this.raiseChildToView(parent, child);
        }
    }

    protected void raiseChildToView(CmtModelNode parent, CmtModelNode child) {
    }

    @Override
    public String prepareAddStatus(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size) {
        return toNode + " z: " + this.calcBestZ(node, toNode, location, size, null);
    }

    @Override
    public String prepareMouseMoveStatus(CmtModelNode node, CmtModelNode toNode, Point location) {
        return node == null ? toNode.toString() : node.toString();
    }

    @Override
    public String constrainMove(CmtModelNode node, CmtModelNode toNode, Point mousePos, Point mouseOffset, Point newPos, Dimension newSize) {
        return node == null ? toNode.toString() : node.toString();
    }

    @Override
    public void constrainAdd(CmtModelNode toNode, Point mouseOrigin, Point mousePos, Point newPos, Dimension newSize) {
    }

    @Override
    public void cleanupRemovedComponent(CmtModelNode parent) {
    }

    @Override
    public JComponent getEffects(UICanvas canvas, Container host) {
        return null;
    }

    @Override
    public boolean usesReverseZOrder() {
        return false;
    }

    @Override
    public void drawGrid(Container host, Graphics g) {
    }

    @Override
    public synchronized JComponent[] getContextMenuItems(Context context) {
        if (MOVE_TO_FIRST_ITEM == null) {
            Menubar menubar = Ide.getMenubar();
            ZORDER_MENU = menubar.createSubMenu(LayoutConstants.ZORDER_MENU, LayoutConstants.ZORDER_MENU_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ARRANGE);
            ZORDER_MENU.putClientProperty("menu-section-id", Float.valueOf(JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT));
            MOVE_TO_FIRST_ITEM = menubar.createMenuItem((ToggleAction)MOVE_TO_FIRST_ACTION);
            MOVE_TO_LAST_ITEM = menubar.createMenuItem((ToggleAction)MOVE_TO_LAST_ACTION);
            menubar.add((Component)MOVE_TO_FIRST_ITEM, ZORDER_MENU);
            menubar.add((Component)MOVE_TO_LAST_ITEM, ZORDER_MENU);
        }
        return new JComponent[]{ZORDER_MENU};
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmd;
        int n = cmd = action != null ? action.getCommandId() : -1;
        if (cmd == LayoutConstants.MOVE_TO_FIRST_CMD_ID || cmd == LayoutConstants.MOVE_TO_LAST_CMD_ID) {
            ArrayList siblings = AbstractAssistant.getSelectedSiblings(context);
            if (siblings.size() == 1) {
                CmtModelNode node = (CmtModelNode)siblings.get(0);
                int count = 0;
                node = node != null ? (CmtModelNode)node.getParent() : null;
                int n2 = count = node != null ? node.getChildCount() : 0;
                if (count > 1) {
                    Object obj;
                    CmtSubcomponent sub = (node = (CmtModelNode)node.getChildAt(0)) != null ? node.getSubcomponent() : null;
                    Object object = obj = sub != null ? sub.getLiveInstance() : null;
                    if (!(obj instanceof Component)) {
                        --count;
                    }
                    action.setEnabled(count > 1);
                }
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmd;
        int n = cmd = action != null ? action.getCommandId() : -1;
        if (cmd == LayoutConstants.MOVE_TO_FIRST_CMD_ID) {
            CmtComponentSource src = null;
            try {
                Element[] selection = context.getSelection();
                CmtModelNode anchor = (CmtModelNode)selection[0];
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                this.changeZ(anchor, (CmtModelNode)anchor.getParent(), 0);
                anchor.adjustPosition(true);
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        if (cmd == LayoutConstants.MOVE_TO_LAST_CMD_ID) {
            CmtComponentSource src = null;
            try {
                Element[] selection = context.getSelection();
                CmtModelNode anchor = (CmtModelNode)selection[0];
                String undo = (String)action.getValue("Name");
                src = (CmtComponentSource)anchor.getCmtModel().getComponent();
                src.beginTrans();
                this.changeZ(anchor, (CmtModelNode)anchor.getParent(), -1);
                anchor.adjustPosition(true);
                src.commit(undo);
            }
            catch (Exception e) {
                if (src != null) {
                    src.abort();
                }
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    protected static final ArrayList getSelectedSiblings(Context context) {
        CmtModelNode parent;
        ArrayList<Element> siblings = new ArrayList<Element>();
        Element[] selection = context != null ? context.getSelection() : null;
        TreeNode anchor = null;
        if (selection != null && selection.length > 0) {
            Object obj;
            CmtSubcomponent cmtSub = ((CmtModelNode)selection[0]).getSubcomponent();
            Object object = obj = cmtSub != null ? cmtSub.getLiveInstance() : null;
            if (obj instanceof Component) {
                anchor = (CmtModelNode)selection[0];
            }
        }
        CmtModelNode cmtModelNode = parent = anchor != null ? (CmtModelNode)anchor.getParent() : null;
        if (parent != null) {
            for (int i = 0; i < selection.length; ++i) {
                if (!parent.containsChild(selection[i])) {
                    Object obj;
                    CmtSubcomponent cmtSub = ((CmtModelNode)selection[i]).getSubcomponent();
                    Object object = obj = cmtSub != null ? cmtSub.getLiveInstance() : null;
                    if (obj instanceof Component) {
                        siblings.clear();
                        break;
                    }
                    siblings.add(selection[i]);
                    continue;
                }
                siblings.add(selection[i]);
            }
        }
        return siblings;
    }

    protected static final void removeBoundsSetting(CmtModelNode node) {
        try {
            CmtSubcomponent subComp = node.getSubcomponent();
            CmtPropertyState ps = subComp.getPropertyState("bounds");
            if (ps != null) {
                ps.setDefaultValue(ps.getValue());
                ps.reset();
            }
        }
        catch (Exception e) {
            Assert.println((String)("BasicLayoutAssistant.removeBoundsSetting " + e));
        }
    }

    protected int calcBestZ(CmtModelNode node, CmtModelNode toNode, Point location, Dimension size, Rectangle zBounds) {
        Iterator i;
        if (location == null) {
            location = new Point(0x7FFFFFF0, Integer.MAX_VALUE);
        }
        int x = location.x;
        int y = location.y;
        int bestZ = 0;
        int myoldZ = -1;
        Iterator iterator = i = toNode != null ? toNode.getChildren() : null;
        if (i != null) {
            while (i.hasNext()) {
                CmtModelNode sibling = (CmtModelNode)i.next();
                CmtSubcomponent sub = sibling != null ? sibling.getSubcomponent() : null;
                Object obj = sub != null ? sub.getLiveInstance() : null;
                if (!(obj instanceof Component)) continue;
                Rectangle r = ((Component)obj).getBounds();
                if (zBounds != null && myoldZ != bestZ) {
                    zBounds.x = r.x + 15;
                    zBounds.y = r.y;
                    zBounds.width = r.width;
                    zBounds.height = r.height;
                }
                if (sibling != node) {
                    if (y < r.y || y < r.y + r.height && x < r.x) {
                        if (zBounds == null || myoldZ == bestZ) break;
                        zBounds.x -= 30;
                        break;
                    }
                    if (zBounds != null && myoldZ == bestZ) {
                        zBounds.x = r.x + 15;
                        zBounds.y = r.y;
                        zBounds.width = r.width;
                        zBounds.height = r.height;
                    }
                    ++bestZ;
                    continue;
                }
                if (zBounds != null) {
                    zBounds.x -= 15;
                }
                myoldZ = bestZ;
            }
        }
        return bestZ;
    }

    protected boolean changeZ(CmtModelNode node, CmtModelNode toNode, int z) {
        CmtComponentSource src = (CmtComponentSource)toNode.getCmtModel().getComponent();
        DefaultTreeModel treeModel = src.getStructure();
        CmtModelNode sibling = null;
        Iterator i = toNode.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                Object obj;
                CmtModelNode gl = (CmtModelNode)i.next();
                CmtSubcomponent sub = gl.getSubcomponent();
                Object object = obj = sub != null ? sub.getLiveInstance() : null;
                if (obj instanceof Component && gl != node) {
                    sibling = gl;
                    if (z-- != 0) continue;
                    treeModel.removeNodeFromParent(node);
                    toNode.insert(node, toNode.getIndex(sibling));
                    treeModel.nodesWereInserted(toNode, new int[]{toNode.getIndex(node)});
                    return true;
                }
                if (gl != node || z != 0) continue;
                return false;
            }
        }
        if (sibling == node) {
            return false;
        }
        treeModel.removeNodeFromParent(node);
        toNode.add((Element)node);
        treeModel.nodesWereInserted(toNode, new int[]{toNode.getIndex(node)});
        return true;
    }

    protected Object getKey(Component comp) {
        Rectangle r = comp.getBounds();
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    protected boolean lessThan(Object o1, Object o2) {
        Point r = (Point)o1;
        Point s = (Point)o2;
        return r.y < s.y || r.y == s.y && r.x < s.x;
    }

    protected void sort(ArrayList array, ArrayList key) {
        int n = array.size();
        int h = 1;
        while (h <= n / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h; i < n; i += h) {
                int j;
                Object a = array.get(i);
                Object k = key.get(i);
                for (j = i; j >= h && this.lessThan(k, key.get(j - h)); j -= h) {
                    array.set(j, array.get(j - h));
                    key.set(j, key.get(j - h));
                }
                array.set(j, a);
                key.set(j, k);
            }
            h /= 3;
        }
    }

    protected ArrayList sortedNodes(CmtModelNode parent) {
        ArrayList<CmtModelNode> children = new ArrayList<CmtModelNode>();
        ArrayList<Object> key = new ArrayList<Object>();
        Iterator i = parent.getChildren();
        while (i.hasNext()) {
            CmtModelNode node = (CmtModelNode)i.next();
            CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
            Object obj = sub != null ? sub.getLiveInstance() : null;
            if (!(obj instanceof Component)) continue;
            children.add(node);
            key.add(this.getKey((Component)obj));
        }
        this.sort(children, key);
        return children;
    }

    static {
        ModelFactory factory = UIManager.getFactory(UIModel.class);
        try {
            float weight;
            int parentID = factory.registerSubMenu(0, LayoutConstants.ZORDER_MENU, LayoutConstants.ZORDER_MENU_MNEMONIC, JDeveloperMenuConstants.WEIGHT_JAVA_UI_DESIGN_ARRANGE, JDeveloperMenuConstants.SECTION_DESIGN_NO_LAYOUT);
            float f = weight = 0.0f;
            weight = f + 1.0f;
            MOVE_TO_FIRST_ACTION = factory.registerAction(LayoutConstants.MOVE_TO_FIRST_CMD_ID, LayoutConstants.MOVE_TO_FIRST, LayoutConstants.MOVE_TO_FIRST_MNEMONIC, LayoutConstants.ARB, 14, parentID, f, Float.MAX_VALUE);
            MOVE_TO_LAST_ACTION = factory.registerAction(LayoutConstants.MOVE_TO_LAST_CMD_ID, LayoutConstants.MOVE_TO_LAST, LayoutConstants.MOVE_TO_LAST_MNEMONIC, LayoutConstants.ARB, 17, parentID, weight, Float.MAX_VALUE);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }
}

