/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.file.ProjectCache;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;

public final class JDevDependencyCache {
    public static final String INITIAL_PROJECT_QUEUE = "JDevDependencyCacheInitialProjectQueue";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<Project> getProjectsUsing(Context context, String ... fqClassNames) throws InterruptedException {
        Workspace workspace = context.getWorkspace();
        try (ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);){
            HashSet<Project> results = new HashSet<Project>();
            Object queueProperty = context.getProperty(INITIAL_PROJECT_QUEUE);
            LinkedList queue = queueProperty != null && queueProperty instanceof LinkedList ? (LinkedList)queueProperty : new LinkedList();
            ArrayList<String> classNames = new ArrayList<String>(Arrays.asList(fqClassNames));
            Project currentProject = context.getProject();
            if (currentProject != null) {
                queue.add(currentProject);
            }
            HashMap<String, ClassOrigin> classOrigins = new HashMap<String, ClassOrigin>();
            block3: for (String className : classNames) {
                boolean workspaceOriginChecked = false;
                boolean jdkOriginChecked = false;
                LinkedList<Project> copiedQueue = new LinkedList<Project>(queue);
                HashSet<Project> alreadyLoopedProjects = new HashSet<Project>(queue);
                while (!copiedQueue.isEmpty()) {
                    Collection upList;
                    boolean classFound = false;
                    Project project = (Project)copiedQueue.removeFirst();
                    JavaManager javaManager = JavaManager.getJavaManager(project);
                    JavaClass javaClass = javaManager.getClass(className);
                    if (javaClass != null) {
                        ProjectLibraryOrigin libraryOrigin;
                        classFound = true;
                        ProjectOrigin projectOrigin = JDevDependencyCache.checkProjectOrigin(project, javaClass, cache);
                        if (projectOrigin != null) {
                            classOrigins.put(className, projectOrigin);
                            continue block3;
                        }
                        if (!jdkOriginChecked) {
                            jdkOriginChecked = true;
                            JDKOrigin jdkOrigin = JDevDependencyCache.checkJDKOrigin(workspace, project, javaClass);
                            if (jdkOrigin != null) {
                                classOrigins.put(className, jdkOrigin);
                                break block3;
                            }
                        }
                        if (!workspaceOriginChecked) {
                            workspaceOriginChecked = true;
                            WorkspaceLibraryOrigin workspaceClassOrigin = JDevDependencyCache.checkWorkspaceLibraryOrigin(workspace, javaClass);
                            if (workspaceClassOrigin != null) {
                                classOrigins.put(className, workspaceClassOrigin);
                                break block3;
                            }
                        }
                        if ((libraryOrigin = JDevDependencyCache.checkProjectLibraryOrigin(project, javaClass, cache)) != null) {
                            classOrigins.put(className, libraryOrigin);
                            continue block3;
                        }
                    }
                    if (!classFound || (upList = cache.getDirectDependencies(project)) == null) continue;
                    for (Project upProject : upList) {
                        if (!alreadyLoopedProjects.add(upProject)) continue;
                        copiedQueue.add(upProject);
                    }
                }
            }
            for (ClassOrigin classOrigin : classOrigins.values()) {
                results.addAll(classOrigin.gatherEligibleProjects());
            }
            results.add(currentProject);
            Collection collection = Collections.unmodifiableCollection(results);
            return collection;
        }
    }

    private static boolean isOwner(Project project, JavaClass javaClass) {
        SourceClass sourceClass = javaClass.getSourceElement();
        if (sourceClass != null) {
            SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
            ContentSet contents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (contents.canHaveMember(owningSourceFile.getURL())) {
                return true;
            }
        }
        return false;
    }

    private static WorkspaceLibraryOrigin checkWorkspaceLibraryOrigin(Workspace workspace, JavaClass javaClass) {
        for (JLibrary jLibrary : ApplicationLibraries.getInstance((Workspace)workspace).getLibraryReferences()) {
            URLPath libraryClassPath = jLibrary.getClassPath();
            if (libraryClassPath == null || !JDevDependencyCache.checkUrlPathContainsUrl(libraryClassPath, javaClass.getURL())) continue;
            return new WorkspaceLibraryOrigin(workspace);
        }
        return null;
    }

    private static JDKOrigin checkJDKOrigin(Workspace workspace, Project project, JavaClass javaClass) {
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        JDK jdk = jProjectLibraries.getJDK();
        URLPath classPath = jdk.getClassPath();
        if (classPath != null && JDevDependencyCache.checkUrlPathContainsUrl(classPath, javaClass.getURL())) {
            return new JDKOrigin(workspace);
        }
        return null;
    }

    private static ProjectLibraryOrigin checkProjectLibraryOrigin(Project project, JavaClass javaClass, ProjectCache projectCache) {
        URL javaClassURL = javaClass.getURL();
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        for (JLibrary library : jProjectLibraries.getLibraries()) {
            URLPath libraryClassPath = library.getClassPath();
            if (!JDevDependencyCache.checkUrlPathContainsUrl(libraryClassPath, javaClassURL)) continue;
            return new ProjectLibraryOrigin(libraryClassPath, project.getWorkspace(), projectCache);
        }
        return null;
    }

    private static ProjectOrigin checkProjectOrigin(Project project, JavaClass javaClass, ProjectCache projectCache) {
        if (JDevDependencyCache.isOwner(project, javaClass)) {
            return new ProjectOrigin(project, projectCache);
        }
        return null;
    }

    private static boolean checkUrlPathContainsUrl(URLPath urlPath, URL url) {
        if (urlPath == null || url == null) {
            return false;
        }
        for (URL entry : urlPath) {
            if (!URLFileSystem.isBaseURLFor((URL)entry, (URL)url)) continue;
            return true;
        }
        return false;
    }

    private static class ProjectOrigin
    implements ClassOrigin {
        private Project originProject;
        private ProjectCache cache;

        public ProjectOrigin(Project originProject, ProjectCache cache) {
            this.originProject = originProject;
            this.cache = cache;
        }

        @Override
        public Collection<Project> gatherEligibleProjects() throws InterruptedException {
            ArrayList<Project> res = new ArrayList<Project>();
            res.add(this.originProject);
            res.addAll(this.cache.getDownstreamDependencies(this.originProject));
            return res;
        }
    }

    private static class JDKOrigin
    implements ClassOrigin {
        private Workspace workspace;

        private JDKOrigin(Workspace workspace) {
            this.workspace = workspace;
        }

        @Override
        public Collection<Project> gatherEligibleProjects() {
            HashSet<Project> res = new HashSet<Project>();
            res.addAll(this.workspace.projects());
            return res;
        }
    }

    private static class WorkspaceLibraryOrigin
    implements ClassOrigin {
        private Workspace workspace;

        private WorkspaceLibraryOrigin(Workspace workspace) {
            this.workspace = workspace;
        }

        @Override
        public Collection<Project> gatherEligibleProjects() throws InterruptedException {
            return new ArrayList<Project>(this.workspace.projects());
        }
    }

    private static class ProjectLibraryOrigin
    implements ClassOrigin {
        private URLPath libraryClassPath;
        private Workspace workspace;
        private ProjectCache cache;

        private ProjectLibraryOrigin(URLPath libraryClassPath, Workspace workspace, ProjectCache cache) {
            this.libraryClassPath = libraryClassPath;
            this.workspace = workspace;
            this.cache = cache;
        }

        @Override
        public Collection<Project> gatherEligibleProjects() throws InterruptedException {
            HashSet<Project> res = new HashSet<Project>();
            block0: for (Project project : this.workspace.projects()) {
                JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
                for (JLibrary jLibrary : jProjectLibraries.getLibraries()) {
                    URLPath tempClassPath = jLibrary.getClassPath();
                    if (!ModelUtil.areEqual((Object)tempClassPath, (Object)this.libraryClassPath)) continue;
                    res.add(project);
                    List<JLibrary> exportedLibraries = Arrays.asList(jProjectLibraries.getExports());
                    if (!exportedLibraries.contains(jLibrary)) continue block0;
                    res.addAll(this.cache.getDownstreamDependencies(project));
                    continue block0;
                }
            }
            return res;
        }
    }

    private static interface ClassOrigin {
        public Collection<Project> gatherEligibleProjects() throws InterruptedException;
    }
}

