/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.ClassKind;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaHelper;

public final class CreateTypeHelper {
    private final JavaType JAVA_UTIL_COLLECTION;
    private final JavaType JAVA_UTIL_MAP;
    private final SourceFactory factory;
    private final String className;
    private final ClassKind kind;
    private final String[] superTypes;
    private final JavaManager javaManager;
    private final String[] constructorTypes;
    private final List<SourceTypeArgument> typeArguments;
    private final TypeArgumentNameGenerator typeArgumentNameGenerator;

    public CreateTypeHelper(SourceFactory factory, String className, ClassKind kind, String[] superTypes, JavaManager javaManager, String[] constructorTypes, List<SourceTypeArgument> typeArguments) {
        this.factory = factory;
        this.className = className;
        this.kind = kind;
        this.superTypes = superTypes;
        this.javaManager = javaManager;
        this.constructorTypes = constructorTypes;
        this.typeArguments = typeArguments;
        this.typeArgumentNameGenerator = new TypeArgumentNameGenerator();
        this.JAVA_UTIL_COLLECTION = javaManager.getClass("java.util.Collection");
        this.JAVA_UTIL_MAP = javaManager.getClass("java.util.Map");
    }

    public CreatedTypeData createType() {
        HashSet<String> typeNamesToImport = new HashSet<String>();
        HashSet<JavaHasType> typesToImport = new HashSet<JavaHasType>();
        SourceTypeReference createdSuperClass = null;
        ArrayList<SourceTypeReference> superInterfaces = new ArrayList<SourceTypeReference>();
        if (this.superTypes != null) {
            boolean solveSuperTypeArguments = this.superTypes.length == 1;
            for (String superTypeName : this.superTypes) {
                JavaClass superType = this.javaManager.getClass(superTypeName);
                if (superType == null) continue;
                if (superType.isInterface()) {
                    SourceTypeReference createdSuperInterface = this.factory.createType(superType.getName());
                    superInterfaces.add(createdSuperInterface);
                    if (solveSuperTypeArguments) {
                        this.addSuperTypeArguments(this.factory, createdSuperInterface, (JavaType)superType);
                    }
                } else if (!"java.lang.Object".equals(superType.getQualifiedName())) {
                    createdSuperClass = this.factory.createType(superType.getName());
                    if (solveSuperTypeArguments) {
                        this.addSuperTypeArguments(this.factory, createdSuperClass, (JavaType)superType);
                    }
                }
                typesToImport.add((JavaHasType)superType);
            }
        }
        SourceSuperclassClause superclassClause = createdSuperClass == null ? null : this.factory.createSuperclassClause(createdSuperClass);
        int interfacesSize = superInterfaces.size();
        SourceInterfacesClause interfacesClause = interfacesSize == 0 ? null : this.factory.createInterfacesClause(superInterfaces.toArray(new SourceTypeReference[interfacesSize]));
        SourceTypeParameter[] typeParameters = this.createTypeParameters(this.factory, this.typeArguments);
        SourceClass newSourceClass = this.factory.createClass(this.kind, this.className, typeParameters, superclassClause, interfacesClause, null);
        if (!newSourceClass.isInterface() && this.constructorTypes != null && this.constructorTypes.length > 0) {
            JavaHelper.createConstructor(newSourceClass, this.constructorTypes, null);
            typeNamesToImport.addAll(Arrays.asList(this.constructorTypes));
        }
        return new CreatedTypeData(newSourceClass, typeNamesToImport, typesToImport);
    }

    private void addSuperTypeArguments(SourceFactory factory, SourceTypeReference superClass, JavaType superType) {
        if (superType.isSubtypeOf(this.JAVA_UTIL_COLLECTION)) {
            this.typeArgumentNameGenerator.reset(TypeArgumentNameGenerator.COLLECTION_ARG_NAMES);
        } else if (superType.isSubtypeOf(this.JAVA_UTIL_MAP)) {
            this.typeArgumentNameGenerator.reset(TypeArgumentNameGenerator.MAP_ARG_NAMES);
        }
        Collection actualSuperTypeArguments = superType.getActualTypeArguments();
        if (actualSuperTypeArguments == null || actualSuperTypeArguments.isEmpty()) {
            return;
        }
        if (this.typeArguments == null || this.typeArguments.size() == 0) {
            if (!this.checkTypeArgumentsForNull(actualSuperTypeArguments)) {
                return;
            }
            ArrayList<SourceTypeArgument> classTypeArguments = new ArrayList<SourceTypeArgument>();
            block3: for (JavaType actualTypeArgument : actualSuperTypeArguments) {
                switch (actualTypeArgument.getElementKind()) {
                    case 11: {
                        JavaWildcardType wildCardType = (JavaWildcardType)actualTypeArgument;
                        Collection bounds = wildCardType.getLowerBounds();
                        if (bounds == null || bounds.isEmpty()) {
                            bounds = wildCardType.getUpperBounds();
                        }
                        for (JavaType bound : bounds) {
                            SourceTypeReference typeReference = factory.createType(bound.getQualifiedName());
                            SourceTypeArgument typeArgument = factory.createTypeArgument(0, typeReference);
                            classTypeArguments.add(typeArgument);
                        }
                        continue block3;
                    }
                    default: {
                        SourceTypeReference typeReference = factory.createType(actualTypeArgument.getQualifiedName());
                        SourceTypeArgument typeArgument = factory.createTypeArgument(0, typeReference);
                        classTypeArguments.add(typeArgument);
                    }
                }
            }
            if (classTypeArguments != null && !classTypeArguments.isEmpty()) {
                superClass.setTypeArguments(classTypeArguments);
            }
        } else if (this.typeArguments.size() == actualSuperTypeArguments.size()) {
            ArrayList<SourceTypeArgument> classTypeArguments = new ArrayList<SourceTypeArgument>();
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                SourceTypeReference typeReference = factory.createType(this.typeArgumentNameGenerator.getUniqueTypeArgumentName());
                classTypeArguments.add(factory.createTypeArgument(0, typeReference));
            }
            superClass.setTypeArguments(classTypeArguments);
        }
        this.typeArgumentNameGenerator.reset();
    }

    private SourceTypeParameter[] createTypeParameters(SourceFactory factory, List<SourceTypeArgument> typeArguments) {
        if (typeArguments == null || typeArguments.isEmpty()) {
            return null;
        }
        SourceTypeParameter[] res = new SourceTypeParameter[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            res[i] = factory.createTypeParameter(this.typeArgumentNameGenerator.getUniqueTypeArgumentName());
        }
        return res;
    }

    private boolean checkTypeArgumentsForNull(Collection<JavaType> actualSuperTypeArguments) {
        for (JavaType jt : actualSuperTypeArguments) {
            if (jt != null) continue;
            return false;
        }
        return true;
    }

    private static class TypeArgumentNameGenerator {
        private static final String[] TYPE_ARG_NAMES = new String[]{"T", "U", "V", "X", "Y", "Z"};
        private static final String[] COLLECTION_ARG_NAMES = new String[]{"E"};
        private static final String[] MAP_ARG_NAMES = new String[]{"K", "V"};
        private String[] argNames = TYPE_ARG_NAMES;
        private int typeArgNamesUsed = 0;

        private TypeArgumentNameGenerator() {
        }

        private void reset(String[] argNames) {
            this.argNames = argNames;
        }

        private void reset() {
            this.typeArgNamesUsed = 0;
        }

        private String getUniqueTypeArgumentName() {
            int suffix = this.typeArgNamesUsed / this.argNames.length;
            String res = this.argNames[this.typeArgNamesUsed % this.argNames.length] + (Serializable)(suffix == 0 ? "" : Integer.valueOf(suffix));
            ++this.typeArgNamesUsed;
            return res;
        }
    }

    public static final class CreatedTypeData {
        private final SourceClass newSourceClass;
        private final String[] typeNamesToImport;
        private final Collection<JavaHasType> typesToImport;

        private CreatedTypeData(SourceClass newSourceClass, Collection<String> typeNamesToImport, Collection<JavaHasType> typesToImport) {
            this.newSourceClass = newSourceClass;
            this.typeNamesToImport = typeNamesToImport.toArray(new String[0]);
            this.typesToImport = typesToImport;
        }

        public SourceClass getNewSourceClass() {
            return this.newSourceClass;
        }

        public String[] getTypeNamesToImport() {
            return this.typeNamesToImport;
        }

        public Collection<JavaHasType> getTypesToImport() {
            return this.typesToImport;
        }
    }
}

