/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.legacy;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.util.IdeUtil;

public class JotNames {
    public static final String SIGS = "L[BCDFIJSVZ";
    public static final String[] TYPES = new String[]{"<class>", "<array>", "byte", "char", "double", "float", "int", "long", "short", "void", "boolean"};
    public static final Class[] PRIMITIVE_CLASSES = new Class[]{null, null, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE, Boolean.TYPE};

    public static final String getClassName(String pkg, String name) {
        return pkg != null && pkg.length() > 0 ? pkg + "." + name : name;
    }

    public static final String getShortClassName(String fullName) {
        int index = fullName.lastIndexOf(46);
        return index >= 0 ? fullName.substring(index + 1) : fullName;
    }

    public static final String getPackageFromFullClassName(String fullName) {
        int index = fullName.lastIndexOf(".");
        return index >= 0 ? fullName.substring(0, index) : "";
    }

    public static boolean isKeyword(String name) {
        return IdeUtil.isJavaKeyword((String)name);
    }

    public static boolean isValidIdentifier(String name) {
        return IdeUtil.isJavaIdentifier((String)name);
    }

    public static boolean isValidClassName(String name) {
        boolean result = false;
        if (name.length() > 0 && !name.startsWith(".") && !name.endsWith(".") && name.indexOf("..") == -1) {
            StringTokenizer tok = new StringTokenizer(name, ".");
            result = true;
            while (tok.hasMoreTokens()) {
                if (JotNames.isValidIdentifier(tok.nextToken())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static final String typeToDotSignature(String type) {
        int i;
        int bracket = type.indexOf(91);
        if (bracket == 0) {
            return type;
        }
        String tail = "";
        String workingType = type;
        if (bracket > 0) {
            tail = workingType.substring(bracket);
            workingType = workingType.substring(0, bracket);
        }
        StringBuffer dotSignature = new StringBuffer();
        for (i = 0; i < tail.length(); ++i) {
            if (tail.charAt(i) != '[') continue;
            dotSignature.append('[');
        }
        for (i = 2; i < TYPES.length; ++i) {
            if (!TYPES[i].equals(workingType)) continue;
            dotSignature.append(SIGS.charAt(i));
            return dotSignature.toString();
        }
        if (bracket < 0) {
            return workingType;
        }
        dotSignature.append("L");
        dotSignature.append(workingType);
        dotSignature.append(";");
        return dotSignature.toString();
    }

    public static String dotSignatureToType(String signature) {
        String type = JotNames.signatureToType(signature);
        return type != null ? type : signature;
    }

    public static String signatureToType(String signature) {
        Object sig = null;
        int typeIndex = SIGS.indexOf(signature.charAt(0));
        switch (typeIndex) {
            case -1: {
                break;
            }
            case 0: {
                sig = signature.substring(1, signature.indexOf(59)).replace('/', '.');
                break;
            }
            case 1: {
                sig = JotNames.signatureToType(signature.substring(1)) + "[]";
                break;
            }
            default: {
                sig = TYPES[typeIndex];
            }
        }
        return sig;
    }

    public static int getSignatureItemCount(String signature) {
        int count = 0;
        int sigLen = signature.length();
        int i = 0;
        block4: while (i < sigLen) {
            char ch = signature.charAt(i++);
            switch (ch) {
                case '[': {
                    continue block4;
                }
                case 'L': {
                    int end = signature.indexOf(59, i);
                    if (end < 0) {
                        end = sigLen;
                    }
                    i = end + 1;
                    ++count;
                    continue block4;
                }
            }
            ++count;
        }
        return count;
    }

    public static String[] signatureToTypes(String signature) {
        ArrayList<String> typearray = new ArrayList<String>();
        int sigLen = signature.length();
        int i = 0;
        int arrayDepth = 0;
        block4: while (i < sigLen) {
            String type;
            char ch = signature.charAt(i++);
            switch (ch) {
                case '[': {
                    ++arrayDepth;
                    continue block4;
                }
                case 'L': {
                    int end = signature.indexOf(59, i);
                    if (end < 0) {
                        end = sigLen;
                    }
                    type = signature.substring(i, end).replace('/', '.');
                    i = end + 1;
                    break;
                }
                default: {
                    int typeIndex = SIGS.indexOf(ch);
                    if (typeIndex < 0) continue block4;
                    type = TYPES[typeIndex];
                }
            }
            if (arrayDepth > 0) {
                StringBuffer buf = new StringBuffer(type);
                for (int j = 0; j < arrayDepth; ++j) {
                    buf.append("[]");
                }
                arrayDepth = 0;
                type = buf.toString();
            }
            typearray.add(type);
        }
        return typearray.toArray(new String[0]);
    }

    public static final Class classForName(String type) throws ClassNotFoundException {
        int primitiveIndex;
        String dotSignature = JotNames.typeToDotSignature(type);
        if (dotSignature.indexOf(46) >= 0 || dotSignature.indexOf(91) >= 0) {
            return Class.forName(dotSignature);
        }
        if (dotSignature.length() > 0 && (primitiveIndex = SIGS.indexOf(dotSignature.charAt(0))) >= 0) {
            return PRIMITIVE_CLASSES[primitiveIndex];
        }
        throw new ClassNotFoundException();
    }

    public static final Class primitiveClassForName(String dotSignature) {
        int primitiveIndex;
        if (dotSignature.length() == 1 && (primitiveIndex = SIGS.indexOf(dotSignature.charAt(0))) >= 0) {
            return PRIMITIVE_CLASSES[primitiveIndex];
        }
        return null;
    }
}

