/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.ClassEngine;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;

public class MethodEngine
implements EngineConstants {
    public static MethodInfo addMethod(ClassEngine classEngine, MethodInfo mi) {
        return MethodEngine.addMethod(classEngine, mi, null);
    }

    public static MethodInfo addMethod(ClassEngine classEngine, MethodInfo mi, MethodInfo prevMi) {
        if (!classEngine.isEditable() || MethodEngine.findSourceMethod(classEngine, mi.name, mi.parameters) != null) {
            return null;
        }
        SourceFile srcFile = classEngine.getSourceFile();
        SourceMethod srcMethod = mi.createSourceMethod(srcFile, true);
        SourceMethod prevMethod = prevMi != null ? MethodEngine.findSourceMethod(classEngine, prevMi.name, prevMi.parameters) : null;
        EngineUtils.openTransaction(srcFile);
        if (prevMethod != null) {
            List methods = classEngine.getSourceClass().getSourceMethods();
            int i = 0;
            boolean found = false;
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                if (prevMethod.equals(iter.next())) {
                    methods.add(i + 1, srcMethod);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                methods.add(srcMethod);
            }
        } else {
            classEngine.getSourceClass().getSourceMethods().add(srcMethod);
        }
        return mi;
    }

    public static void addDefaultImpl(MethodInfo mi, SourceFile srcFile, SourceMethod srcMethod) {
        if (!(EngineUtils.isAbstract(mi.modifiers) || EngineUtils.isNative(mi.modifiers) || mi.type == null || mi.type.length() <= 0 || mi.type.equals("void"))) {
            String temp = EngineUtils.getClassFromPrimitive(mi.type);
            temp = temp == null ? (mi.type.equals("java.lang.Boolean") ? "Boolean.FALSE" : "null") : (mi.type.equals("boolean") ? "false" : "0");
            EngineUtils.openTransaction(srcFile);
            SourceFactory factory = srcFile.getFactory();
            srcMethod.getBlock().getCodeElements().add(factory.createStatement("return " + temp + ";"));
        }
    }

    public static boolean removeMethod(ClassEngine classEngine, String methodName) {
        SourceClass srcClass = classEngine.getJavaClass().getSourceElement();
        if (srcClass == null || URLFileSystem.isReadOnly((URL)srcClass.getOwningSourceFile().getURL())) {
            return false;
        }
        Iterator iter = srcClass.getSourceMethods(methodName).iterator();
        if (iter.hasNext()) {
            iter.remove();
            return true;
        }
        return false;
    }

    public static boolean removeMethod(ClassEngine classEngine, MethodInfo mi) {
        SourceMethod srcMethod;
        if (classEngine.isEditable() && (srcMethod = MethodEngine.findSourceMethod(classEngine, mi.name, mi.parameters)) != null) {
            EngineUtils.openTransaction(classEngine.getSourceFile());
            srcMethod.removeSelf();
            return true;
        }
        return false;
    }

    public static MethodInfo addReader(ClassEngine classEngine, FieldInfo fi, String getter, int modifiers) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceFile srcFile = classEngine.getSourceFile();
        MethodInfo mi = new MethodInfo(fi.type, getter, modifiers);
        SourceMethod srcMethod = mi.createSourceMethod(srcFile, MethodEngine.getReaderStatement(fi.type, fi.name, modifiers));
        SourceClass srcClass = classEngine.getSourceClass();
        if (!MethodEngine.doesSourceMethodExist(mi, srcClass)) {
            EngineUtils.openTransaction(srcFile);
            srcClass.getSourceMethods().add(srcMethod);
            EngineUtils.createSavepoint(srcFile);
            EngineUtils.openTransaction(srcFile);
            classEngine.getSourceClass().getSourceMethods().add(srcMethod);
            EngineUtils.createSavepoint(srcFile);
        }
        MethodInfo newMethodInfo = new MethodInfo(srcMethod);
        newMethodInfo.type = mi.type;
        return newMethodInfo;
    }

    private static String getReaderStatement(String fieldType, String fieldName, int modifiers) {
        String stmt = null;
        if (!EngineUtils.isAbstract(modifiers)) {
            Object arg = null;
            arg = ModelUtil.hasLength((String)fieldName) ? " " + fieldName : (EngineUtils.getClassFromPrimitive(fieldType) != null ? (fieldType.equals(" boolean") ? " false" : " 0") : " null");
            stmt = "return" + (String)arg + ";";
        }
        return stmt;
    }

    public static void updateReader(ClassEngine classEngine, MethodInfo omi, String oldFieldName, MethodInfo nmi, String newFieldName) {
        SourceMethod srcMethod;
        if (!classEngine.isEditable()) {
            return;
        }
        nmi = MethodEngine.updateMethod(classEngine, omi, nmi);
        if (!EngineUtils.isAbstract(nmi.modifiers) && (srcMethod = MethodEngine.findSourceMethod(classEngine, nmi.name, nmi.parameters)) != null) {
            try {
                SourceBlock sourceBlock = srcMethod.getBlock();
                List codeElements = sourceBlock.getCodeElements();
                SourceElement srcElem = (SourceElement)codeElements.get(0);
                SourceExpression expr = ((SourceReturnStatement)srcElem).getExpression();
                String stmt = ((SourceSimpleNameExpression)expr).getName();
                if (stmt.equals(oldFieldName)) {
                    ((SourceSimpleNameExpression)expr).setName(newFieldName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static MethodInfo removeReader(ClassEngine classEngine, FieldInfo fi) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass srcClass = classEngine.getSourceClass();
        String getter = EngineUtils.makeReaderName(fi.name, fi.type);
        SourceMethod srcMethod = srcClass.getSourceMethod(getter, JavaType.EMPTY_ARRAY);
        MethodInfo mi = null;
        if (srcMethod == null) {
            getter = EngineUtils.makeReaderName(fi.name);
            srcMethod = srcClass.getSourceMethod(getter, JavaType.EMPTY_ARRAY);
        }
        if (srcMethod != null) {
            mi = new MethodInfo(srcMethod);
            EngineUtils.openTransaction(classEngine.getSourceFile());
            srcMethod.removeSelf();
        }
        return mi;
    }

    public static MethodInfo addWriter(ClassEngine classEngine, FieldInfo fi, String setter, int modifiers) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceFile srcFile = classEngine.getSourceFile();
        MethodInfo mi = new MethodInfo("void", setter, modifiers);
        mi.addParameter(fi.type, fi.name);
        EngineUtils.openTransaction(srcFile);
        SourceMethod srcMethod = mi.createSourceMethod(srcFile, MethodEngine.getWriterStatement(fi.name, setter, modifiers));
        SourceClass srcClass = classEngine.getSourceClass();
        if (!MethodEngine.doesSourceMethodExist(mi, srcClass)) {
            srcClass.getSourceMethods().add(srcMethod);
        }
        return mi;
    }

    private static String getWriterStatement(String fieldName, String setter, int modifiers) {
        String stmt;
        StringBuffer strBuf = new StringBuffer();
        if (!EngineUtils.isAbstract(modifiers)) {
            if (!ModelUtil.hasLength((String)fieldName)) {
                strBuf.append("super.");
                strBuf.append(setter);
                strBuf.append('(');
                strBuf.append(fieldName);
                strBuf.append(')');
            } else {
                strBuf.append("this.");
                strBuf.append(fieldName);
                strBuf.append(" = ");
                strBuf.append(fieldName);
            }
            strBuf.append(';');
        }
        return ModelUtil.hasLength((String)(stmt = strBuf.toString())) ? stmt : null;
    }

    public static void updateWriter(ClassEngine classEngine, MethodInfo omi, String oldFieldName, MethodInfo nmi, String newFieldName) {
        SourceMethod srcMethod;
        if (!classEngine.isEditable()) {
            return;
        }
        nmi = MethodEngine.updateMethod(classEngine, omi, nmi);
        if (!EngineUtils.isAbstract(nmi.modifiers) && (srcMethod = MethodEngine.findSourceMethod(classEngine, nmi.name, nmi.parameters)) != null) {
            try {
                SourceBlock sourceBlock = srcMethod.getBlock();
                List codeElements = sourceBlock.getCodeElements();
                SourceElement srcElem = (SourceElement)codeElements.get(0);
                SourceExpressionStatement stmt = (SourceExpressionStatement)srcElem;
                SourceAssignmentExpression expr = (SourceAssignmentExpression)stmt.getExpression();
                SourceDotExpression dotExpr = (SourceDotExpression)expr.getFirstOperand();
                SourceSimpleNameExpression thisExpr = (SourceSimpleNameExpression)dotExpr.getFirstOperand();
                SourceSimpleNameExpression paramExpr = (SourceSimpleNameExpression)expr.getSecondOperand();
                if ("this".equals(thisExpr.getName()) && oldFieldName.equals(dotExpr.getName()) && oldFieldName.equals(paramExpr.getName())) {
                    dotExpr.setName(newFieldName);
                    paramExpr.setName(newFieldName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static MethodInfo removeWriter(ClassEngine classEngine, FieldInfo fi) {
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass srcClass = classEngine.getSourceClass();
        String setter = EngineUtils.makeWriterName(fi.name);
        JavaManager javaManager = classEngine.getJavaManager();
        JavaClass javaType = javaManager.getClass(fi.type);
        SourceMethod srcMethod = srcClass.getSourceMethod(setter, new JavaType[]{javaType});
        MethodInfo mi = null;
        if (srcMethod != null) {
            mi = new MethodInfo(srcMethod);
            EngineUtils.openTransaction(classEngine.getSourceFile());
            srcMethod.removeSelf();
        }
        return mi;
    }

    public static MethodInfo updateMethod(ClassEngine classEngine, MethodInfo oldMethodInfo, MethodInfo newMethodInfo) {
        SourceBlock oldBlock;
        if (!classEngine.isEditable()) {
            return null;
        }
        if (oldMethodInfo != null && oldMethodInfo.equals(newMethodInfo) && ModelUtil.areEqual((Object)oldMethodInfo.type, (Object)newMethodInfo.type)) {
            return newMethodInfo;
        }
        SourceFile srcFile = classEngine.getSourceFile();
        SourceMethod oldMethod = MethodEngine.findSourceMethod(classEngine, oldMethodInfo.name, oldMethodInfo.parameters);
        if (oldMethod == null) {
            return MethodEngine.addMethod(classEngine, newMethodInfo);
        }
        EngineUtils.openTransaction(srcFile);
        SourceFactory factory = srcFile.getFactory();
        SourceBlock newBlock = null;
        if (!EngineUtils.isAbstract(newMethodInfo.modifiers) && (oldBlock = oldMethod.getBlock()) != null) {
            newBlock = factory.createBlock(oldBlock.getText());
        }
        if (oldMethod.hasTypeParameters()) {
            ArrayList<String> typeParameters = new ArrayList<String>();
            Iterator iterator = oldMethod.getTypeParameters().iterator();
            while (iterator.hasNext()) {
                JavaTypeVariable typeParam;
                JavaTypeVariable jvt = typeParam = (JavaTypeVariable)iterator.next();
                typeParameters.add(jvt.getName());
            }
            newMethodInfo.typeParameters = typeParameters;
        }
        SourceMethod newMethod = newMethodInfo.createSourceMethod(srcFile, newBlock);
        srcFile.getTransaction().savepoint();
        SourceDocComment docComm = oldMethod.getDocComment();
        if (docComm != null) {
            String text = docComm.getText();
            newMethod.setDocComment(factory.createDocComment(text));
        }
        List oldAnnos = oldMethod.getSourceAnnotations();
        List newAnnos = newMethod.getSourceAnnotations();
        if (oldAnnos != null) {
            for (SourceAnnotation srcAnno : oldAnnos) {
                String text = srcAnno.getText();
                newAnnos.add(factory.createAnnotationFromText(text));
            }
        }
        oldMethod.replaceSelf((SourceElement)newMethod);
        return newMethodInfo;
    }

    public static SourceMethod findSourceMethod(ClassEngine classEngine, String methodName, List params) {
        SourceClass srcClass = classEngine.getSourceClass();
        if (srcClass == null) {
            return null;
        }
        int pcount = params != null ? params.size() : 0;
        JavaType[] paramTypes = new JavaType[pcount];
        JavaManager javaManager = classEngine.getJavaManager();
        if (pcount > 0) {
            pcount = 0;
            for (List param : params) {
                paramTypes[pcount++] = javaManager.getClass((String)param.get(0));
            }
        }
        return srcClass.getSourceMethod(methodName, paramTypes);
    }

    public static JavaMethod findMethod(ClassEngine classEngine, String methodName, List params) {
        JavaClass javaClass = classEngine.getJavaClass();
        if (javaClass == null) {
            return null;
        }
        int pcount = params != null ? params.size() : 0;
        JavaType[] paramTypes = new JavaType[pcount];
        JavaManager javaManager = classEngine.getJavaManager();
        if (pcount > 0) {
            pcount = 0;
            for (Object param : params) {
                if (param instanceof List) {
                    param = ((List)param).get(0);
                }
                paramTypes[pcount++] = javaManager.getClass(param.toString());
            }
        }
        return javaClass.getMethod(methodName, paramTypes);
    }

    public static boolean updateParamInMethod(ClassEngine classEngine, SourceMethod meth, String oldParamType, String oldParamName, String newParamType, String newParamName) {
        for (SourceVariable param : meth.getSourceParameters()) {
            if (!oldParamName.equals(param.getName()) || !oldParamType.equals(param.getResolvedType().getQualifiedName())) continue;
            param.setName(newParamName);
            param.setSourceType(EngineUtils.createType(classEngine.getFactory(), newParamType));
            return true;
        }
        return false;
    }

    public static boolean doesSourceMethodExist(MethodInfo methodInfo, SourceClass srcClass) {
        boolean exists = false;
        List existingSourceMethods = srcClass.getSourceMethods();
        for (int i = 0; i < existingSourceMethods.size(); ++i) {
            SourceMethod existingSourceMethod = (SourceMethod)existingSourceMethods.get(i);
            MethodInfo existingMethodInfo = new MethodInfo(existingSourceMethod);
            if (methodInfo.compareTo(existingMethodInfo) != 0) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

