/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.ui.Colors;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilter2V2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageSearchPanel;
import oracle.jdeveloper.dialogs.ClassPackageTreePanel;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.dialogs.DlgArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.PatternMatchNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageBrowserV2
extends JPanel
implements ClassPackageBrowserContext,
ItemListener {
    JTabbedPane tabControl = new JTabbedPane();
    JLabel filterLabel = new JLabel();
    DefaultComboBoxModel filterModel = new DefaultComboBoxModel();
    JComboBox filterCombo = new JComboBox(this.filterModel);
    BorderLayout borderLayout = new BorderLayout(0, 10);
    protected JWrappedLabel descriptiveText = new JWrappedLabel();
    private int _classPackageMode = 3;
    private JavaManager _javaManager;
    private JEWTDialog _dlg;
    private String _title;
    private Component _hostParent;
    private CompoundFilter _classFilter = new CompoundFilter();
    private CompoundFilter _packageFilter = new CompoundFilter();
    private ClassPackageView[] _tabs;
    private static int _activeTab = 0;
    private Collection<JavaType> _usedIfaceList = new ArrayList<JavaType>();
    private static final ClassPackageBrowserFilter2V2 _defaultFilter = new DefaultFilter();
    public static final int PACKAGE_ONLY = 1;
    public static final int CLASS_ONLY = 2;
    public static final int CLASS_AND_PACKAGE = 3;
    public static final String PACKAGE_TITLE = DialogsArb.getString((int)0);
    public static final String CLASS_TITLE = DialogsArb.getString((int)1);
    public static final String CLASS_PACKAGE_TITLE = DialogsArb.getString((int)2);

    public ClassPackageBrowserV2() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeDialog(String[] defaultSelection) {
        for (ClassPackageView tab : this._tabs) {
            tab.setSelectedItems(defaultSelection);
        }
    }

    public void initializeDialog(String defaultSelection) {
        for (ClassPackageView tab : this._tabs) {
            tab.setSelection(defaultSelection);
        }
    }

    public void setInitialInterfaceFilter(String className) {
        this.setUsedInterfaceFilter(className);
    }

    private void setUsedInterfaceFilter(String className) {
        JavaClass implClass;
        if (className == null || className.equals("")) {
            this._usedIfaceList.clear();
        }
        if ((implClass = this._javaManager.getClass(className)) != null) {
            this._usedIfaceList = implClass.getInterfaces();
        }
    }

    public void setSelection(String selection) {
        this.initializeDialog(selection);
    }

    public void setSelectedItems(String[] multipleSelection) {
        this.initializeDialog(multipleSelection);
    }

    public String getSelection() {
        return this._tabs[_activeTab].getSelection();
    }

    public String[] getSelectedItems() {
        return this._tabs[_activeTab].getSelectedItems();
    }

    public void setJavaManager(JavaManager mgr) {
        Assert.check((mgr != null ? 1 : 0) != 0);
        this._javaManager = mgr;
        this.initializeFilters();
        for (ClassPackageView tab : this._tabs) {
            tab.setJavaManager(mgr);
            tab.setClassAndPackageNameFilters((ClassNameFilter)this._classFilter, (PackageNameFilter)this._packageFilter);
        }
    }

    private void initializeFilters() {
        switch (this._classPackageMode) {
            case 3: {
                this._packageFilter = new CompoundFilter();
                this._classFilter = new CompoundFilter();
                break;
            }
            case 1: {
                this._packageFilter = new CompoundFilter();
                break;
            }
            default: {
                this._classFilter = new CompoundFilter();
            }
        }
    }

    public void setMode(int mode) {
        this._classPackageMode = mode;
        this.initializeFilters();
        this.descriptiveText.setText(this.getDescription());
        for (ClassPackageView tab : this._tabs) {
            tab.setMode(mode);
            tab.setClassAndPackageNameFilters((ClassNameFilter)this._classFilter, (PackageNameFilter)this._packageFilter);
        }
    }

    public void setHostParent(Component hostParent) {
        this._hostParent = hostParent;
    }

    public Component getInitialFocusComponent() {
        return this._tabs[_activeTab].getComponent();
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public ClassPackageBrowserFilterV2 getFilter() {
        return new UsedInterfaceWrapperFilter((ClassPackageBrowserFilterV2)this.filterModel.getSelectedItem());
    }

    public void setFilter(ClassPackageBrowserFilterV2 filter) {
        this.filterCombo.setVisible(false);
        this.filterLabel.setVisible(false);
        this.filterCombo.removeItemListener(this);
        this.filterModel.removeAllElements();
        ClassPackageBrowserFilterV2 activeFilter = filter != null ? filter : _defaultFilter;
        this.filterModel.addElement(activeFilter);
        this.activateFilter(activeFilter);
    }

    public void setFilters(ClassPackageBrowserFilterV2[] filters) {
        ClassPackageBrowserFilterV2 activeFilter;
        this.filterCombo.removeItemListener(this);
        this.filterModel.removeAllElements();
        if (filters != null && filters.length > 0) {
            activeFilter = filters[0];
            for (ClassPackageBrowserFilterV2 filter : filters) {
                this.filterModel.addElement(filter);
            }
        } else {
            activeFilter = _defaultFilter;
            this.filterModel.addElement(_defaultFilter);
            this.filterLabel.setVisible(false);
            this.filterCombo.setVisible(false);
        }
        this.activateFilter(activeFilter);
        boolean mulitpleFilters = filters.length > 1;
        this.filterLabel.setVisible(mulitpleFilters);
        this.filterCombo.setVisible(mulitpleFilters);
        if (mulitpleFilters) {
            this.filterCombo.addItemListener(this);
        }
    }

    public void addFilters(ClassPackageBrowserFilterV2[] filters) {
        if (filters == null || filters.length == 0) {
            return;
        }
        this.filterCombo.removeItemListener(this);
        for (ClassPackageBrowserFilterV2 filter : filters) {
            this.filterModel.addElement(filter);
        }
        boolean mulitpleFilters = this.filterModel.getSize() > 1;
        this.filterLabel.setVisible(mulitpleFilters);
        this.filterCombo.setVisible(mulitpleFilters);
        this.activateFilter(_defaultFilter);
        if (mulitpleFilters) {
            this.filterCombo.addItemListener(this);
        }
    }

    private void activateFilter(ClassPackageBrowserFilterV2 activeFilter) {
        if (this.filterModel.getIndexOf(activeFilter) == -1) {
            this.filterModel.addElement(activeFilter);
        }
        this.filterCombo.setSelectedItem(activeFilter);
        for (ClassPackageView tab : this._tabs) {
            tab.setFilter(new UsedInterfaceWrapperFilter(activeFilter));
        }
    }

    public void setMultiSelect(boolean isMultiSelect) {
        for (ClassPackageView tab : this._tabs) {
            tab.setMultiSelect(isMultiSelect);
        }
    }

    @Override
    public void classPackageSelected() {
        this.fireActionPerformed(this.tabControl.getSelectedComponent());
    }

    @Override
    public void enableControls(boolean enable) {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(enable);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this._javaManager != null) {
            for (ClassPackageView tab : this._tabs) {
                tab.setFilter(new UsedInterfaceWrapperFilter(this.getFilter()));
            }
            String[] selection = this.getSelectedItems();
            this.initializeDialog(selection);
            this._tabs[_activeTab].activateView();
            this.setUsedInterfaceFilter(e.getItem().toString());
        }
    }

    public String browseClassOrPackage(JavaManager mgr, int mode) {
        return this.browseClassOrPackage(mgr, mode, null);
    }

    public String browseClassOrPackage(JavaManager mgr, int mode, ClassPackageBrowserFilterV2 filter) {
        String[] result = this.browseClassOrPackage(mgr, mode, false, filter);
        return result.length > 0 ? result[0] : null;
    }

    public String[] browseClassOrPackage(JavaManager mgr, int mode, boolean isMultiSelect) {
        return this.browseClassOrPackage(mgr, mode, isMultiSelect, null);
    }

    public String[] browseClassOrPackage(JavaManager mgr, int mode, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter) {
        return this.browseClassOrPackage(mgr, mode, isMultiSelect, filter, null);
    }

    public String[] browseClassOrPackage(JavaManager mgr, int mode, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter, String initialSelection) {
        ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array;
        if (filter == null) {
            classPackageBrowserFilterV2Array = new ClassPackageBrowserFilterV2[]{};
        } else {
            ClassPackageBrowserFilterV2[] classPackageBrowserFilterV2Array2 = new ClassPackageBrowserFilterV2[1];
            classPackageBrowserFilterV2Array = classPackageBrowserFilterV2Array2;
            classPackageBrowserFilterV2Array2[0] = filter;
        }
        ClassPackageBrowserFilterV2[] filters = classPackageBrowserFilterV2Array;
        return this.showDialog(mgr, mode, isMultiSelect, filters, true, initialSelection);
    }

    public String[] browseClassOrPackage(JavaManager mgr, int mode, boolean isMultiSelect, ClassPackageBrowserFilter2V2[] filters, String initialSelection) {
        return this.showDialog(mgr, mode, isMultiSelect, filters, false, initialSelection);
    }

    private String[] showDialog(JavaManager mgr, int mode, boolean isMultiSelect, ClassPackageBrowserFilterV2[] filters, boolean replaceFilters, String initialSelection) {
        this.setMode(mode);
        this.setJavaManager(mgr);
        if (replaceFilters) {
            this.setFilters(filters);
        } else {
            this.addFilters(filters);
        }
        this.setMultiSelect(isMultiSelect);
        this.initializeDialog(initialSelection);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_ideclasspkgbrowser_html");
        return WizardLauncher.runDialog((JDialog)this._createDialog()) ? this.getSelectedItems() : new String[]{};
    }

    public static String browseClassOrPackage(Component parent, Project proj, int mode) {
        return ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, null);
    }

    public static String browseClassOrPackage(Component parent, Project proj, int mode, ClassPackageBrowserFilterV2 filter) {
        String[] result = ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, false, filter);
        return result.length > 0 ? result[0] : null;
    }

    public static String[] browseClassOrPackage(Component parent, Project proj, int mode, boolean isMultiSelect) {
        return ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, isMultiSelect, null);
    }

    public static String[] browseClassOrPackage(Component parent, Project proj, int mode, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter) {
        return ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, isMultiSelect, filter, null);
    }

    public static String[] browseClassOrPackage(Component parent, Project proj, int mode, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter, String initialSelection) {
        JavaManager mgr = JavaManager.getJavaManager(proj);
        ClassPackageBrowserV2 pkgPanel = new ClassPackageBrowserV2();
        if (parent != null) {
            pkgPanel.setHostParent(parent);
        }
        return pkgPanel.browseClassOrPackage(mgr, mode, isMultiSelect, filter, initialSelection);
    }

    private void jbInit() throws Exception {
        this.descriptiveText.setForeground(Colors.HINT_TEXT);
        this.descriptiveText.setPreferredAspectRatio(10.0f);
        this.descriptiveText.setText(this.getDescription());
        this.filterModel.addElement(_defaultFilter);
        this.filterModel.setSelectedItem(_defaultFilter);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filterCombo, (String)DlgArb.getString(2));
        this.filterLabel.setVisible(false);
        this.filterCombo.setVisible(false);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        filterPanel.add((Component)this.filterLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        filterPanel.add((Component)this.filterCombo, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 50, 0));
        ClassPackageSearchPanel searchPanel = new ClassPackageSearchPanel(this);
        ClassPackageTreePanel treePanel = new ClassPackageTreePanel(this, new UsedInterfaceWrapperFilter(_defaultFilter));
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        searchPanel.setBorder(border);
        treePanel.setBorder(border);
        this.tabControl.add(searchPanel.getTitle(), searchPanel);
        this.tabControl.add(treePanel.getTitle(), treePanel);
        this.tabControl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                _activeTab = ClassPackageBrowserV2.this.tabControl.getSelectedIndex();
                ClassPackageBrowserV2.this._tabs[_activeTab].activateView();
            }
        });
        this._tabs = new ClassPackageView[]{searchPanel, treePanel};
        if (_activeTab >= 2) {
            _activeTab = 0;
        }
        this.tabControl.setSelectedIndex(_activeTab);
        this.setLayout(this.borderLayout);
        this.add((Component)this.descriptiveText, "North");
        this.add((Component)this.tabControl, "Center");
        this.add((Component)filterPanel, "South");
        this.setPreferredSize(new Dimension(400, 300));
    }

    private JEWTDialog _createDialog() {
        BrowserDialog dlg;
        Dialog dialog = null;
        Object frame = null;
        if (this._hostParent != null && (dialog = DialogUtil.getAncestorDialog((Component)this._hostParent)) == null) {
            frame = DialogUtil.getAncestorFrame((Component)this._hostParent);
        }
        if (dialog != null) {
            dlg = new BrowserDialog(dialog);
        } else {
            if (frame == null) {
                frame = Ide.getMainWindow();
            }
            dlg = new BrowserDialog((Frame)frame);
        }
        this.descriptiveText.setText(this.getDescription());
        dlg.setContent(this);
        dlg.setOKButtonEnabled(false);
        dlg.setResizable(true);
        dlg.setMaximumInitialSize(525, 400);
        dlg.setInitialFocus(this._tabs[_activeTab].getComponent());
        this.addActionListener(dlg);
        return dlg;
    }

    private String getDescription() {
        return switch (this._classPackageMode) {
            case 1 -> DialogsArb.getString((int)9);
            case 2 -> DialogsArb.getString((int)4);
            case 3 -> DialogsArb.getString((int)15);
            default -> throw new IllegalArgumentException("Invalid mode '" + this._classPackageMode + "'");
        };
    }

    protected String _getTitle() {
        if (this._title != null && this._title.length() > 0) {
            return this._title;
        }
        for (ClassPackageView tab : this._tabs) {
            tab.setMode(this._classPackageMode);
        }
        switch (this._classPackageMode) {
            case 1: {
                return PACKAGE_TITLE;
            }
            case 2: {
                return CLASS_TITLE;
            }
            case 3: {
                return CLASS_PACKAGE_TITLE;
            }
        }
        throw new IllegalArgumentException("Invalid mode '" + this._classPackageMode + "' passed to ClassPackageBrowserV2._getTitle()");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._dlg == null) {
            Container parent = this.getParent();
            while (parent != null && this._dlg == null) {
                if (parent instanceof JEWTDialog) {
                    this._dlg = (JEWTDialog)parent;
                    continue;
                }
                parent = parent.getParent();
            }
        }
    }

    @Override
    public void removeNotify() {
        if (this._dlg != null) {
            this._dlg = null;
        }
        for (ClassPackageView tab : this._tabs) {
            tab.dispose();
        }
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        this._tabs[_activeTab].getComponent().requestFocus();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionPerformed(Object src) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        String actionCommand = "ITEM_INVOKED";
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(src, 1001, actionCommand, 0);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public static String[] browseClassOrPackage(Component parent, Project proj, int mode, int needs, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter) {
        return ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, isMultiSelect, filter);
    }

    public static String[] browseClassOrPackage(Component parent, Project proj, int mode, int needs, boolean isMultiSelect, ClassPackageBrowserFilterV2 filter, String[] initialSelection) {
        return ClassPackageBrowserV2.browseClassOrPackage(parent, proj, mode, isMultiSelect, filter);
    }

    private class CompoundFilter
    extends PatternMatchNameFilter {
        CompoundFilter() {
            super(false);
        }

        public boolean acceptPackageName(String packageName) {
            if (super.acceptPackageName(packageName)) {
                ClassPackageBrowserFilterV2 activeFilter = ClassPackageBrowserV2.this.getFilter();
                if (activeFilter == null) {
                    return true;
                }
                return activeFilter.acceptPackage(packageName);
            }
            return false;
        }

        public boolean acceptClassName(String className, String packagePrefix) {
            if (super.acceptClassName(className, packagePrefix)) {
                ClassPackageBrowserFilterV2 activeFilter = ClassPackageBrowserV2.this.getFilter();
                if (activeFilter == null) {
                    return true;
                }
                Object qualifiedClassName = packagePrefix.length() == 0 ? className : packagePrefix + "." + className;
                JavaClass javaClass = ClassPackageBrowserV2.this._javaManager.getClass((String)qualifiedClassName);
                if (javaClass == null) {
                    return false;
                }
                return activeFilter.acceptClass(javaClass);
            }
            return false;
        }
    }

    private class UsedInterfaceWrapperFilter
    implements ClassPackageBrowserFilter2V2 {
        private ClassPackageBrowserFilterV2 wrappedFilter;

        public UsedInterfaceWrapperFilter(ClassPackageBrowserFilterV2 filter) {
            this.wrappedFilter = filter;
        }

        @Override
        public void setContext(Context context) {
        }

        @Override
        public boolean acceptPackage(String pkg) {
            return this.wrappedFilter == null || this.wrappedFilter.acceptPackage(pkg);
        }

        @Override
        public boolean acceptClass(JavaClass cls) {
            if (this.wrappedFilter == null || this.wrappedFilter.acceptClass(cls)) {
                return ClassPackageBrowserV2.this._usedIfaceList == null || !ClassPackageBrowserV2.this._usedIfaceList.contains(cls);
            }
            return false;
        }
    }

    private class BrowserDialog
    extends JEWTDialog
    implements ActionListener {
        public BrowserDialog(Dialog parent) {
            super(parent, ClassPackageBrowserV2.this._getTitle(), 7);
        }

        public BrowserDialog(Frame parent) {
            super(parent, ClassPackageBrowserV2.this._getTitle(), 7);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dismissDialog(false);
        }
    }

    private static class DefaultFilter
    implements ClassPackageBrowserFilter2V2 {
        private DefaultFilter() {
        }

        @Override
        public boolean acceptPackage(String pkg) {
            return true;
        }

        @Override
        public boolean acceptClass(JavaClass cls) {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DefaultFilter;
        }

        @Override
        public String toString() {
            return DlgArb.getString(3);
        }

        @Override
        public void setContext(Context context) {
        }
    }
}

