/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.controller.NodeActionDelegate;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.resource.JavacoreExtension;

public abstract class JavaSourceNodeActionDelegate
extends NodeActionDelegate {
    private boolean redo;
    private UndoableEdit edit;
    private int[] selection;

    public boolean isEnabled(IdeAction action, Context context, Element[] elements, int[] text) {
        return context.getProject() != null;
    }

    public int[] doAction(final Context context, final Element[] elements, final int[] text, final IdeAction action) {
        if (this.redo) {
            if (this.edit != null) {
                this.edit.redo();
            }
        } else {
            this.redo = true;
            final Node node = context.getNode();
            node.runUnderWriteLock(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JavaManager manager = JavaManager.getJavaManager(context.getProject());
                    SourceFile file = manager.getSourceFile(node.getURL());
                    if (file == null) {
                        throw new IllegalStateException(JavacoreExtension.get("CANNOT_FIND_FILE"));
                    }
                    SourceTransaction transaction = file.beginTransaction();
                    try {
                        JavaSourceNodeActionDelegate.this.selection = JavaSourceNodeActionDelegate.this.doAction(file, context, elements, text, action);
                        transaction.savepoint();
                        JavaSourceNodeActionDelegate.this.edit = transaction.commit();
                        transaction = null;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.abort();
                        }
                    }
                }
            });
        }
        return this.selection;
    }

    protected abstract int[] doAction(SourceFile var1, Context var2, Element[] var3, int[] var4, IdeAction var5);

    public void undoAction(Context context, Element[] elements, int[] text, IdeAction action) {
        if (this.edit != null) {
            this.edit.undo();
        }
    }
}

