/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.OjcConfigurationConstants;
import oracle.jdevimpl.compiler.CompilerOptionManager;

public class OjcConfiguration
extends HashStructureAdapter
implements OjcConfigurationConstants {
    public static final String COMPILER_NAME = "compiler.name";
    public static final String DEFAULT_COMPILER_NAME = "Javac";
    public static final String COMPILER_OPTIONS_AS_STRING = "commandline.options";
    public static final String COMPILER_OPTIONS_AS_LIST = "commandline.optionlist";
    public static final String DATA_KEY;
    public static final String DEFAULT_TARGET = "Default";
    public static final String DEFAULT_SOURCE = "Default";
    public static final String DEFAULT_ENCODING = "Default";
    static final String[] DEFAULT_TARGETS;
    static final String JDK15_SOURCE = "1.5";
    static final String[] DEFAULT_SOURCES;
    private BuildSystemConfiguration buildSystemConfiguration;
    private CompilerOptionManager compilerOptionManager;

    private OjcConfiguration(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.buildSystemConfiguration = BuildSystemConfiguration.getInstance(project);
        this.compilerOptionManager = CompilerOptionManager.getInstance(project);
    }

    public static OjcConfiguration getInstance(PropertyStorage project) {
        return new OjcConfiguration(OjcConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static OjcConfiguration getOjcConfiguration(Project project, String configName) {
        return OjcConfiguration.getInstance((PropertyStorage)project);
    }

    public boolean isDebugInformation() {
        return this.compilerOptionManager.isDebugInformation();
    }

    public void setDebugInformation(boolean debugInformation) {
        this.compilerOptionManager.setDebugInformation(debugInformation);
    }

    public boolean isJDK15() {
        return this.buildSystemConfiguration.isJDK15();
    }

    public boolean isJDK15OrHigher() {
        return this.buildSystemConfiguration.isJDK15OrHigher();
    }

    public boolean isJDK16() {
        return this.buildSystemConfiguration.isJDK16();
    }

    public boolean isUseJavac() {
        return this.compilerOptionManager.isUseJavac();
    }

    public boolean isShowWarnings() {
        return this.compilerOptionManager.isShowWarnings();
    }

    public void setShowWarnings(boolean showWarnings) {
        this.compilerOptionManager.setShowWarnings(showWarnings);
    }

    public boolean isShowDeprecations() {
        return this.compilerOptionManager.isShowDeprecations();
    }

    public void setShowDeprecations(boolean showDeprecations) {
        this.compilerOptionManager.setShowDeprecations(showDeprecations);
    }

    public String[] getTargets() {
        return this.buildSystemConfiguration.getTargets();
    }

    public String getTargetString() {
        return this.buildSystemConfiguration.getTargetString();
    }

    public String getTarget() {
        return this.buildSystemConfiguration.getTarget();
    }

    public void setTarget(String target) {
        this.buildSystemConfiguration.setTarget(target);
    }

    public String[] getSources() {
        return this.buildSystemConfiguration.getSources();
    }

    public String getSourceString() {
        return this.buildSystemConfiguration.getSourceString();
    }

    public String getSource() {
        return this.buildSystemConfiguration.getSource();
    }

    public void setSource(String source) {
        this.buildSystemConfiguration.setSource(source);
    }

    public String[] getCopyRes() {
        return this.buildSystemConfiguration.getCopyRes();
    }

    public void setCopyRes(String[] copyRes) {
        this.buildSystemConfiguration.setCopyRes(copyRes);
    }

    public boolean getReverseCopyRes() {
        return this.buildSystemConfiguration.getReverseCopyRes();
    }

    public void setReverseCopyRes(boolean reverseCopyRes) {
        this.buildSystemConfiguration.setReverseCopyRes(reverseCopyRes);
    }

    public String getCurrentEncoding() throws TransientMarker {
        return this.buildSystemConfiguration.getCurrentEncoding();
    }

    public void setCurrentEncoding(String currentEncoding) {
        this.buildSystemConfiguration.setCurrentEncoding(currentEncoding);
    }

    static {
        int x;
        DATA_KEY = OjcConfiguration.class.getName();
        JdkVersion[] jdkVersions = JdkVersion.values();
        ArrayList<String> versionNumbers = new ArrayList<String>();
        versionNumbers.add("Default");
        for (x = 0; x < jdkVersions.length; ++x) {
            if (jdkVersions[x] == JdkVersion.JDK_UNKNOWN) continue;
            versionNumbers.add(jdkVersions[x].getVersionString());
        }
        DEFAULT_TARGETS = versionNumbers.toArray(new String[versionNumbers.size()]);
        versionNumbers.clear();
        versionNumbers.add("Default");
        for (x = 0; x < jdkVersions.length; ++x) {
            if (!jdkVersions[x].isGreaterThanOrEqualTo3() || jdkVersions[x] == JdkVersion.JDK_UNKNOWN) continue;
            versionNumbers.add(jdkVersions[x].getVersionString());
        }
        DEFAULT_SOURCES = versionNumbers.toArray(new String[versionNumbers.size()]);
    }
}

