/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmt;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.net.URL;
import java.util.HashMap;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdevimpl.cmtimpl.JbComponentManager;
import oracle.jdevimpl.uieditor.JdevUiEditorUtils;

public abstract class CmtComponentManager
implements CmtComponents,
Observer {
    protected static HashMap MANAGER_MAP = new HashMap();
    protected HashMap componentMap = new HashMap();

    public static final synchronized CmtComponents getCmtComponents(Project prj) {
        if (prj == null) {
            return null;
        }
        CmtComponents components = (CmtComponents)MANAGER_MAP.get(prj);
        if (components == null) {
            components = new JbComponentManager(prj);
            MANAGER_MAP.put(prj, components);
        }
        return components;
    }

    public static final PropertyEditor findEditor(Class targetType) {
        PropertyEditor editor = null;
        if (targetType != null) {
            editor = PropertyEditorManager.findEditor(targetType);
        }
        if (editor == null) {
            editor = JdevUiEditorUtils.getInstance().createSubcomponentChoiceEditor();
        }
        return editor;
    }

    protected CmtComponentManager() {
    }

    protected abstract CmtComponent createComponent(JavaClass var1);

    protected abstract CmtComponent createComponent(JavaFile var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CmtComponent getComponent(JavaClass clazz) {
        JavaClass jClass;
        SourceFile jFile;
        if (clazz == null) return null;
        SourceFile sourceFile = jFile = clazz instanceof SourceClass ? ((SourceClass)clazz).getOwningSourceFile() : null;
        if (jFile != null) return this.getComponent((JavaFile)jFile);
        if (!clazz.isArray()) return this.getComponent(clazz.getURL());
        String className = clazz.getQualifiedName();
        int bracket = className.indexOf(91);
        if (bracket >= 0) {
            className = className.substring(0, bracket);
        }
        if ((jClass = this.getPackages().getClass(className)) == null) return null;
        return this.createComponent(jClass);
    }

    @Override
    public CmtComponent getComponent(URL url) {
        JavaFile jFile;
        CmtComponent component = null;
        if (url != null && (component = (CmtComponent)this.componentMap.get(url)) == null && (jFile = this.getPackages().getFile(url)) != null) {
            component = this.createComponent(jFile);
            this.componentMap.put(url, component);
        }
        return component;
    }

    @Override
    public CmtComponent getComponent(JavaFile jFile) {
        URL url = jFile != null ? jFile.getURL() : null;
        CmtComponent component = (CmtComponent)this.componentMap.get(url);
        if (component == null && jFile instanceof SourceFile && !((SourceFile)jFile).isExpired()) {
            component = this.createComponent(jFile);
            this.componentMap.put(url, component);
        }
        return component != null ? component : this.getComponent(url);
    }

    @Override
    public void release(CmtComponent component) {
        URL url;
        JavaFile jFile = component != null ? component.getFile() : null;
        URL uRL = url = jFile != null ? jFile.getURL() : null;
        if (url != null) {
            this.componentMap.remove(url);
            component.release();
        }
    }

    @Override
    public void shutdown() {
    }
}

