/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.javapckg;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilderPanel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class PackageBuilderPanel
extends FileBuilderPanel {
    public PackageBuilderPanel() {
        this.setFilePrompt(BuilderArb.getString(170));
        this.setDirectoryPrompt(BuilderArb.getString(171));
    }

    @Override
    public boolean validateAndWriteToState(BaliWizardState state) {
        FileBuilderModel model = (FileBuilderModel)state;
        String packageName = this.getFileField().getText();
        String prefixPackage = model.getRelativeDirectory().replace('\\', '.').replace('/', '.');
        if (packageName != null && !"".equals(packageName) && JotNames.isValidClassName((String)("".equals(prefixPackage) ? "" : prefixPackage + ".") + packageName)) {
            try {
                URL url = this.getFileURL();
                if (url != null) {
                    URLPath urlPath = PathsConfiguration.getInstance((Project)model.getProject()).getProjectSourcePath();
                    if (urlPath.toRelativePath(url) == null && !JavaProject.askDynamicProjectSourcePathUpdate()) {
                        return false;
                    }
                    model.setFileName(this.getFileField().getText());
                    model.setURL(url);
                    return true;
                }
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
            }
        } else {
            model.reportError(BuilderArb.getString(172), MessageFormat.format(BuilderArb.getString(173), prefixPackage + "." + packageName), "f1_idedclassnameinvalid_html");
        }
        return false;
    }
}

