/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.sqlcl.commands.dg.DgConfigInst;
import oracle.dbtools.sqlcl.commands.dg.DgConfigMember;
import oracle.dbtools.sqlcl.commands.dg.DgDBUtils;
import oracle.dbtools.sqlcl.commands.dg.DgResult;
import oracle.dbtools.sqlcl.commands.dg.DgResultMessage;
import oracle.dbtools.sqlcl.commands.dg.DgUtils;
import oracle.dbtools.sqlcl.commands.dg.DgXmlObject;

public class DgConfig {
    public String name;
    public Hashtable<Integer, DgConfigMember> memberMap = new Hashtable();
    public boolean enabled;
    public boolean istateOnline;
    public int protectMode;
    public int fsfoMode;
    public String fsfoTarget;
    public String observer;
    public static final int PMODE_MAX_PERFORMANCE = 0;
    public static final int PMODE_MAX_AVAIL = 1;
    public static final int PMODE_MAX_PROTECT = 2;
    public static final int FSFO_DISABLED = 0;
    public static final int FSFO_ENABLED = 1;
    public static final int FSFO_ENABLED_OBONLY = 2;
    public static final int ROLE_NULL = 0;
    public static final int ROLE_PRIMARY = 1;
    public static final int ROLE_PHYSICAL = 2;
    public static final int ROLE_LOGICAL = 3;
    public static final int ROLE_SNAPSHOT = 4;
    public static final int ROLE_FAR_SYNC = 5;
    public static final int ROLE_RA = 6;
    public static final int ROLE_REMOTE_CONFIG = 7;
    public static final int ROLE_REMOTE_PDB = 8;
    protected static final Logger LOGGER = Logger.getLogger(DgConfig.class.getName());

    public static DgConfig readConfig(Connection conn) {
        return DgConfig.readConfig(conn, false);
    }

    public static DgConfig readConfig(Connection conn, boolean read_status) {
        DgConfig config = new DgConfig();
        if (config.read(conn, read_status) == 0) {
            return config;
        }
        return null;
    }

    public void refresh(Connection conn, boolean read_status) {
        String indoc = String.format("<DO_MONITOR version=\"%s\"><VERIFY object_id=\"%d\" level=\"minor\"/></DO_MONITOR>", "23.1.0.0.0", 4096);
        String outdoc = DgDBUtils.doControl(conn, indoc, null);
        DgResult result = (DgResult)DgXmlObject.create(outdoc);
        DgResultMessage rm = result.resultMsgList.get(0);
        LOGGER.info("refresh severity: " + rm.severity);
        this.read(conn, read_status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(Connection conn, boolean readStatus) {
        int objid;
        String sql = "select object_id, attribute, value FROM x$drc";
        String sql_st = "select object_id, attribute, value, status, errnum, errtime FROM x$drc";
        ResultSet rs = null;
        Statement stmt = null;
        this.memberMap = new Hashtable();
        try {
            stmt = conn.createStatement();
            rs = readStatus ? stmt.executeQuery("select object_id, attribute, value, status, errnum, errtime FROM x$drc") : stmt.executeQuery("select object_id, attribute, value FROM x$drc");
            while (rs.next()) {
                objid = rs.getInt("object_id");
                String attr = rs.getString("attribute");
                String value = rs.getString("value");
                String status = null;
                int errnum = 0;
                int errtime = 0;
                if (readStatus) {
                    status = rs.getString("status");
                    errnum = rs.getInt("errnum");
                    errtime = rs.getInt("errtime");
                }
                int memID = DgUtils.extractMemberId(objid);
                int instID = DgUtils.extractInstanceId(objid);
                DgConfigMember member = null;
                DgConfigInst inst = null;
                if (memID == 0) {
                    this.addAttribute(objid, attr, value);
                    continue;
                }
                member = this.memberMap.get(memID);
                if (member == null) {
                    member = new DgConfigMember();
                    member.memberID = memID;
                    this.memberMap.put(memID, member);
                }
                if (instID == 0) {
                    member.addAttribute(objid, attr, value, status, errnum, errtime);
                    continue;
                }
                inst = member.getInst(instID);
                if (inst == null) {
                    inst = new DgConfigInst();
                    inst.instID = instID;
                    member.addInst(inst);
                }
                inst.addAttribute(objid, attr, value);
            }
            objid = 0;
        }
        catch (SQLException ex) {
            try {
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                DgDBUtils.cleanup(stmt, rs);
                throw throwable;
            }
            DgDBUtils.cleanup(stmt, rs);
            return -1;
        }
        DgDBUtils.cleanup(stmt, rs);
        return objid;
    }

    public DgConfigMember getMember(int memID) {
        return this.memberMap.get(memID);
    }

    public DgConfigMember getMember(String memberName) {
        for (DgConfigMember member : this.memberMap.values()) {
            if (!memberName.equalsIgnoreCase(member.name)) continue;
            return member;
        }
        return null;
    }

    public DgConfigMember getPrimary() {
        for (DgConfigMember member : this.memberMap.values()) {
            if (member.role != 1) continue;
            return member;
        }
        return null;
    }

    private void addAttribute(int ojbid, String attr, String value) {
        if (attr.equalsIgnoreCase("DRC")) {
            this.name = value;
        } else if (attr.equalsIgnoreCase("INTENDED_STATE")) {
            this.istateOnline = !"OFFLINE".equalsIgnoreCase(value);
        } else if (attr.equalsIgnoreCase("PROTECTION_MODE")) {
            this.protectMode = "MaxProtection".equalsIgnoreCase(value) ? 2 : ("MaxAvailability".equalsIgnoreCase(value) ? 1 : 0);
        } else if (attr.equalsIgnoreCase("ENABLED")) {
            this.enabled = DgUtils.parseYes(value);
        } else if (attr.equalsIgnoreCase("FAST_START_FAILOVER")) {
            this.fsfoMode = "ENABLED_OBONLY".equalsIgnoreCase(value) ? 2 : ("ENABLED".equalsIgnoreCase(value) ? 1 : 0);
        } else if (attr.equalsIgnoreCase("FSFO_TARGET")) {
            this.fsfoTarget = value;
        } else if (attr.equalsIgnoreCase("OBSERVER")) {
            this.observer = value;
        } else if (attr.equalsIgnoreCase("ExternalDestination")) {
            this.observer = value;
        }
    }

    public void print(DgConfig cfg) {
        LOGGER.info(String.format("Config - %s", this.name));
        LOGGER.info(String.format("  enabled: %b", this.enabled));
        for (DgConfigMember member : this.memberMap.values()) {
            LOGGER.info(String.format("Member - %s", member.name));
            LOGGER.info(String.format("  role: %d", member.role));
            LOGGER.info(String.format("  enabled: %b", member.enabled));
            LOGGER.info(String.format("  ship_to: %s", member.shipTo));
            LOGGER.info(String.format("  status: %d", member.status));
            LOGGER.info(String.format("  severity: %s", member.severity));
            LOGGER.info(String.format("  message: %s", member.status_message));
        }
    }
}

