/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.provider;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.AttributeDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.provider.reader.DimensionReader;
import oracle.sql.CLOB;

public class DimensionProvider {
    private Logger LOG = Logger.getLogger(DimensionProvider.class.getName());
    private AWDO awDO;

    public DimensionProvider(AWDO aWDO) {
        this.awDO = aWDO;
    }

    public void populateDimensionInformation() {
        int n = 0;
        ArrayList<DimensionDO> arrayList = this.awDO.getDimensionDOs();
        n = arrayList.size();
        DimensionReader dimensionReader = new DimensionReader(this.awDO.getModelOwner(), this.awDO.getName());
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionReader.getHierarchyDOs(dimensionDO.getName());
            dimensionDO.setHierarchyDOs(arrayList2);
            ArrayList<LevelDO> arrayList3 = dimensionReader.getHierarchyLevelDOs(dimensionDO);
            ArrayList<AttributeDO> arrayList4 = dimensionReader.getAttributeDOs(dimensionDO);
            dimensionDO.setAttributeDOs(arrayList4);
        }
        this.readXMLForDimensions();
    }

    public void readXMLForDimensions() {
        Connection connection = null;
        String string = this.awDO.getModelOwner();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method readXMLForDimensions, SQL Exception occurred.", sQLException);
        }
        ArrayList<DimensionDO> arrayList = this.awDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            try {
                String string2 = string + "." + dimensionDO.getName();
                Object object = DimensionProvider.executeStoredProc(connection, "dbms_cube.export_xml", new Object[]{string2, CLOB.class});
                if (!(object instanceof CLOB)) continue;
                CLOB cLOB = (CLOB)object;
                String string3 = DimensionProvider.convertCLOBToString(cLOB);
                dimensionDO.setXMLString(string3);
                dimensionDO.parseMappingFromXML(string);
            }
            catch (Exception exception) {
                this.LOG.log(Level.SEVERE, "In method readXMLForDimensions, Exception occurred.", exception);
            }
        }
    }

    public static Object executeStoredProc(Connection connection, String string, Object[] objectArray) throws SQLException, IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
        }
        return DimensionProvider.executeStoredProc(connection, string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeStoredProc(Connection connection, String string, List list) throws SQLException, IOException {
        CLOB cLOB = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("?,");
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            String string2 = "begin " + string + "(" + stringBuffer.toString() + "); end;";
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string2);
            int n = 1;
            int n2 = -1;
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                Class clazz;
                String string3;
                object = object2.next();
                if (object instanceof Class && (string3 = (clazz = (Class)object).getName()).equals("oracle.sql.CLOB")) {
                    n2 = n;
                    oracleCallableStatement.registerOutParameter(n++, 2005);
                }
                if (object instanceof CLOB) {
                    oracleCallableStatement.setCLOB(n++, (CLOB)object);
                }
                if (object instanceof String) {
                    oracleCallableStatement.setString(n++, (String)object);
                }
                if (object instanceof Integer) {
                    oracleCallableStatement.setInt(n++, ((Integer)object).intValue());
                }
                if (!(object instanceof Date)) continue;
                oracleCallableStatement.setDate(n++, (Date)object);
            }
            oracleCallableStatement.execute();
            if (n2 != -1 && list.get(n2 - 1) instanceof Class && ((String)(object = ((Class)(object2 = (Class)list.get(n2 - 1))).getName())).equals("oracle.sql.CLOB")) {
                cLOB = oracleCallableStatement.getCLOB(n2);
            }
        }
        return cLOB;
    }

    public static String convertCLOBToString(CLOB cLOB) throws SQLException, IOException {
        Reader reader = cLOB.getCharacterStream();
        char[] cArray = new char[1000];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(2000);
        while ((n = reader.read(cArray)) != -1) {
            String string = new String(cArray, 0, n);
            stringBuffer.append(string);
        }
        reader.close();
        return stringBuffer.toString();
    }
}

