/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

class CustomFilterPanel {
    private static final String DEFAULT_EXPRESSION = "DATE = ${system.date}";
    private JButton _addButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private JButton _removeButton;
    private JButton _restoreDefaultsButton;
    private JLabel _filterListLabel;
    private JList _filterList;
    private SyntaxTextArea _filterExpressionTextArea;
    private DefaultListModel _filterListModel;
    private TitledBorder _detailBorder;
    private JPanel _detailPanel;
    private JRadioButton _simpleExpressionRadioButton;
    private JRadioButton _complexExpressionRadioButton;
    private JLabel _columnLabel;
    private JComboBox _columnComboBox;
    private JLabel _operatorLabel;
    private JComboBox _operatorComboBox;
    private JLabel _valueLabel;
    private SyntaxTextField _valueTextField;
    private JButton _insertButton;
    private Component _gui;
    private CustomFilter _editedFilter;

    private CustomFilterPanel() {
    }

    Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._moveUpButton = new JButton();
        this._moveDownButton = new JButton();
        this._removeButton = new JButton();
        this._restoreDefaultsButton = new JButton();
        this._addButton = new JButton();
        this._filterListLabel = new JLabel();
        this._filterList = new JList();
        this._filterExpressionTextArea = new SyntaxTextArea();
        this._simpleExpressionRadioButton = new JRadioButton();
        this._complexExpressionRadioButton = new JRadioButton();
        this._columnLabel = new JLabel();
        this._columnComboBox = new JComboBox();
        this._operatorLabel = new JLabel();
        this._operatorComboBox = new JComboBox();
        this._valueLabel = new JLabel();
        this._valueTextField = new SyntaxTextField();
        this._insertButton = new JButton();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._simpleExpressionRadioButton);
        bg.add(this._complexExpressionRadioButton);
        this._filterList.setSelectionMode(0);
        this._detailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)HistoryArb.get("FILTER_REMOVE"));
        ResourceUtils.resButton((AbstractButton)this._restoreDefaultsButton, (String)HistoryArb.get("FILTER_RESTORE_DEFAULT"));
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)HistoryArb.get("FILTER_ADD"));
        ResourceUtils.resLabel((JLabel)this._filterListLabel, (Component)this._filterList, (String)HistoryArb.get("FILTER_LIST"));
        ResourceUtils.resButton((AbstractButton)this._simpleExpressionRadioButton, (String)HistoryArb.get("FILTER_EXPRESSION_SIMPLE"));
        ResourceUtils.resButton((AbstractButton)this._complexExpressionRadioButton, (String)HistoryArb.get("FILTER_EXPRESSION_COMPLEX"));
        ResourceUtils.resLabel((JLabel)this._columnLabel, (Component)this._columnComboBox, (String)HistoryArb.get("FILTER_COLUMN"));
        ResourceUtils.resLabel((JLabel)this._operatorLabel, (Component)this._operatorComboBox, (String)HistoryArb.get("FILTER_OPERATOR"));
        ResourceUtils.resLabel((JLabel)this._valueLabel, (Component)this._valueTextField, (String)HistoryArb.get("FILTER_VALUE"));
        ResourceUtils.resButton((AbstractButton)this._insertButton, (String)HistoryArb.get("FILTER_INSERT"));
        this._moveUpButton.setIcon(OracleIcons.getIcon((String)"previous.png"));
        this._moveDownButton.setIcon(OracleIcons.getIcon((String)"next.png"));
        this._moveUpButton.setToolTipText(HistoryArb.get("FILTER_UP_TOOLTIP"));
        this._moveDownButton.setToolTipText(HistoryArb.get("FILTER_DOWN_TOOLTIP"));
        this.initializeToolButton(this._moveUpButton);
        this.initializeToolButton(this._moveDownButton);
        int toolButtonHeight = this._addButton.getPreferredSize().height;
        int toolButtonWidth = Math.max(toolButtonHeight, 16);
        Dimension toolButtonPreferredSize = new Dimension(toolButtonWidth, toolButtonHeight);
        this._moveUpButton.setPreferredSize(toolButtonPreferredSize);
        this._moveDownButton.setPreferredSize(toolButtonPreferredSize);
        JScrollPane filterListScrollPane = new JScrollPane(this._filterList);
        JScrollPane filterExpressionScrollPane = new JScrollPane(this._filterExpressionTextArea);
        this._filterExpressionTextArea.setRows(2);
        this._filterExpressionTextArea.setFont(new Font("monospaced", 0, this._filterExpressionTextArea.getFont().getSize()));
        this._filterExpressionTextArea.setLineWrap(true);
        this._filterExpressionTextArea.setWrapStyleWord(true);
        if (filterExpressionScrollPane.getBorder() != null) {
            Border border = filterExpressionScrollPane.getBorder();
            Insets insets = border.getBorderInsets(filterExpressionScrollPane);
            Dimension d = new Dimension(this._filterExpressionTextArea.getPreferredSize());
            d.height = d.height + (insets != null ? insets.top : 0);
            d.height = d.height + (insets != null ? insets.bottom : 0);
            filterExpressionScrollPane.setPreferredSize(d);
        }
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(Box.createHorizontalStrut(225));
        buttonBox.add(this._addButton);
        buttonBox.add(this._removeButton);
        buttonBox.add(this._restoreDefaultsButton);
        buttonBox.add(Box.createHorizontalStrut(2));
        Box buttonBox2 = Box.createVerticalBox();
        buttonBox2.add(Box.createVerticalStrut(2));
        buttonBox2.add(buttonBox);
        buttonBox2.add(Box.createVerticalStrut(2));
        Box buttonBox3 = Box.createVerticalBox();
        buttonBox3.add(this._moveUpButton);
        buttonBox3.add(this._moveDownButton);
        buttonBox3.add(Box.createVerticalGlue());
        Box buttonBox4 = Box.createHorizontalBox();
        buttonBox4.add(Box.createHorizontalStrut(2));
        buttonBox4.add(buttonBox3);
        filterListScrollPane.setMinimumSize(new Dimension(filterListScrollPane.getPreferredSize().width, 50));
        JPanel filterListPanel = new JPanel(new BorderLayout());
        filterListPanel.add((Component)filterListScrollPane, "Center");
        filterListPanel.add((Component)buttonBox4, "East");
        this._filterList.setPrototypeCellValue("this is a prototype filter name");
        this._filterList.setVisibleRowCount(5);
        this._valueTextField.setColumns(40);
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel masterPanel = new JPanel(new BorderLayout());
        masterPanel.add((Component)this._filterListLabel, "North");
        masterPanel.add((Component)filterListPanel, "Center");
        masterPanel.add((Component)buttonBox2, "South");
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)this._simpleExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueLabel, insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._insertButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._complexExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)filterExpressionScrollPane, insets, 4, false, true);
        layoutBuilder.nl();
        this._detailPanel = new JPanel();
        layoutBuilder.addToPanel((Container)this._detailPanel);
        this._detailPanel.setBorder(this._detailBorder);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)masterPanel, "Center");
        contentPanel.add((Component)this._detailPanel, "South");
        this._gui = contentPanel;
        this._filterListModel = new DefaultListModel();
        this._filterList.setModel(this._filterListModel);
        CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        this._filterListModel.removeAllElements();
        for (int i = 0; i < customFilters.length; ++i) {
            this._filterListModel.addElement(customFilters[i]);
        }
        this._filterList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null && value instanceof CustomFilter) {
                    value = ((CustomFilter)value).getName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        Collection historyProviders = HistoryManager.getHistoryManager().getProviders();
        LinkedHashSet<ColumnItem> columnItems = new LinkedHashSet<ColumnItem>();
        Iterator itr = historyProviders.iterator();
        while (itr.hasNext()) {
            HistoryProperty[] historyProperties = ((HistoryProvider)itr.next()).getProperties();
            for (int i = 0; i < historyProperties.length; ++i) {
                String customFilterId;
                if (!(historyProperties[i] instanceof DefaultHistoryProperty) || (customFilterId = ((DefaultHistoryProperty)historyProperties[i]).getCustomFilterId()) == null) continue;
                columnItems.add(new ColumnItem((DefaultHistoryProperty)historyProperties[i]));
            }
        }
        Object[] columnItems0 = columnItems.toArray();
        Arrays.sort(columnItems0);
        this._columnComboBox.setModel(new DefaultComboBoxModel<Object>(columnItems0));
        ArrayList<OperatorItem> operatorItems = new ArrayList<OperatorItem>();
        operatorItems.add(new OperatorItem("="));
        operatorItems.add(new OperatorItem("<>"));
        operatorItems.add(new OperatorItem(">"));
        operatorItems.add(new OperatorItem("<"));
        operatorItems.add(new OperatorItem(">="));
        operatorItems.add(new OperatorItem("<="));
        operatorItems.add(new OperatorItem("MATCHES", HistoryArb.get("FILTER_MATCHES")));
        this._operatorComboBox.setModel(new DefaultComboBoxModel<Object>(operatorItems.toArray()));
        this._moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = CustomFilterPanel.this._filterList.getSelectedIndex();
                if (i <= 0) {
                    return;
                }
                Object customFilter = CustomFilterPanel.this._filterListModel.remove(i);
                CustomFilterPanel.this._filterListModel.add(i - 1, customFilter);
                CustomFilterPanel.this._filterList.grabFocus();
                CustomFilterPanel.this._filterList.setSelectedValue(customFilter, true);
            }
        });
        this._moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = CustomFilterPanel.this._filterList.getSelectedIndex();
                if (i < 0 || i > CustomFilterPanel.this._filterListModel.getSize() - 2) {
                    return;
                }
                Object customFilter = CustomFilterPanel.this._filterListModel.remove(i);
                CustomFilterPanel.this._filterListModel.add(i + 1, customFilter);
                CustomFilterPanel.this._filterList.grabFocus();
                CustomFilterPanel.this._filterList.setSelectedValue(customFilter, true);
            }
        });
        this._removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = CustomFilterPanel.this._filterList.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                CustomFilterPanel.this._filterListModel.remove(i);
                i = Math.min(CustomFilterPanel.this._filterListModel.getSize() - 1, i);
                CustomFilterPanel.this._removeButton.grabFocus();
                if (i >= 0) {
                    CustomFilterPanel.this._filterList.setSelectedIndex(i);
                }
            }
        });
        this._restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().createDefaultFilters();
                CustomFilterPanel.this._filterListModel.removeAllElements();
                for (int i = 0; i < customFilters.length; ++i) {
                    CustomFilterPanel.this._filterListModel.addElement(customFilters[i]);
                }
                if (CustomFilterPanel.this._filterListModel.getSize() > 0) {
                    CustomFilterPanel.this._filterList.setSelectedIndex(0);
                }
            }
        });
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SimpleInputDialog dlg = new SimpleInputDialog(CustomFilterPanel.this._gui){

                    protected boolean canOk() {
                        return super.canOk() && !this.getInputValue().equals("") && CustomFilterPanel.this.indexOfFilterName(this.getInputValue()) < 0;
                    }
                };
                if (!dlg.show(HistoryArb.get("ADD_FILTER_TITLE"), HistoryArb.get("ADD_FILTER_NAME_LABEL"), "f1_ideaddfilter_html")) {
                    return;
                }
                try {
                    CustomFilter customFilter = CustomFilter.parse(CustomFilterPanel.DEFAULT_EXPRESSION);
                    customFilter.setName(dlg.getInputValue());
                    CustomFilterPanel.this._filterListModel.addElement(customFilter);
                    CustomFilterPanel.this._filterList.grabFocus();
                    CustomFilterPanel.this._filterList.setSelectedValue(customFilter, true);
                }
                catch (ParseException pe) {
                    Assert.printStackTrace((Throwable)pe);
                }
            }
        });
        this._filterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                CustomFilterPanel.this.listSelectionChanged();
            }
        });
        this._filterExpressionTextArea.getDocument().addDocumentListener(new DocumentUpdateListener(){

            @Override
            protected void documentUpdate(DocumentEvent de) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomFilterPanel.this._filterExpressionTextArea.setSyntaxValid(CustomFilterPanel.this.createCustomFilter(CustomFilterPanel.this._filterExpressionTextArea.getText()) != null);
                    }
                });
            }
        });
        this._valueTextField.getDocument().addDocumentListener(new DocumentUpdateListener(){

            @Override
            protected void documentUpdate(DocumentEvent de) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomFilterPanel.this._valueTextField.setSyntaxValid(CustomFilterPanel.this.createCustomFilter(CustomFilterPanel.this.createSimpleExpression()) != null);
                    }
                });
            }
        });
        this._simpleExpressionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CustomFilterPanel.this.updateExpressionDependentStates();
            }
        });
        this._complexExpressionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CustomFilterPanel.this.updateExpressionDependentStates();
            }
        });
        this._insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JPanel insertPanel = new JPanel(new BorderLayout());
                JLabel insertLabel = new JLabel();
                final JList<String> insertList = new JList<String>();
                insertList.setSelectionMode(0);
                insertList.setPrototypeCellValue("this is a prototype substitution");
                insertList.setVisibleRowCount(3);
                DefaultListModel<CallSite> insertListModel = new DefaultListModel<CallSite>();
                insertList.setModel(insertListModel);
                CustomFilterSubstitution[] substitutions = HistoryManager.getHistoryManager().getCustomFilterManager().getSubstitutions();
                for (int i = 0; i < substitutions.length; ++i) {
                    insertListModel.addElement((CallSite)((Object)("${" + substitutions[i].getName() + "}")));
                }
                ResourceUtils.resLabel((JLabel)insertLabel, insertList, (String)HistoryArb.get("FILTER_INSERT_SUBSTITUTION"));
                insertLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
                insertPanel.add((Component)insertLabel, "North");
                insertPanel.add((Component)new JScrollPane(insertList), "Center");
                HelpSystem.getHelpSystem().registerTopic((JComponent)insertPanel, "f1_ideinsertvalue_html");
                final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)CustomFilterPanel.this._gui, (Component)insertPanel, null, (String)HistoryArb.get("FILTER_INSERT_TITLE"), (int)7);
                dlg.setDefaultButton(2);
                dlg.setResizable(false);
                if (insertList.getModel().getSize() > 0) {
                    insertList.setSelectedIndex(0);
                }
                insertList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent lse) {
                        dlg.setOKButtonEnabled(insertList.getSelectedValue() != null);
                    }
                });
                dlg.setOKButtonEnabled(insertList.getSelectedValue() != null);
                if (!dlg.runDialog()) {
                    return;
                }
                try {
                    int caretPosition = Math.max(0, CustomFilterPanel.this._valueTextField.getCaretPosition());
                    CustomFilterPanel.this._valueTextField.getDocument().insertString(caretPosition, insertList.getSelectedValue().toString(), null);
                    CustomFilterPanel.this._valueTextField.requestFocus();
                }
                catch (BadLocationException ble) {
                    Assert.printStackTrace((Throwable)ble);
                }
            }
        });
        if (this._filterList.getModel().getSize() > 0) {
            this._filterList.setSelectedIndex(0);
        }
        this.listSelectionChanged();
        return this._gui;
    }

    void commitEdits() {
        if (this._editedFilter == null) {
            return;
        }
        int i = this._filterListModel.indexOf(this._editedFilter);
        CustomFilter newFilter = null;
        if (this._simpleExpressionRadioButton.isSelected()) {
            newFilter = this.createCustomFilter(this.createSimpleExpression());
        }
        if (this._complexExpressionRadioButton.isSelected()) {
            newFilter = this.createCustomFilter(this._filterExpressionTextArea.getText());
        }
        if (i < 0 || newFilter == null) {
            return;
        }
        newFilter.setName(this._editedFilter.getName());
        this._filterListModel.set(i, newFilter);
    }

    CustomFilter[] getCustomFilters() {
        Object[] customFilters = new CustomFilter[this._filterListModel.getSize()];
        this._filterListModel.copyInto(customFilters);
        return customFilters;
    }

    private void initializeToolButton(JButton button) {
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setHorizontalAlignment(0);
        button.setFocusable(false);
        button.setFocusPainted(false);
        button.setText("");
    }

    private void listSelectionChanged() {
        this.commitEdits();
        this._editedFilter = (CustomFilter)this._filterList.getSelectedValue();
        this.updateListSelectionDependentStates();
    }

    private void updateListSelectionDependentStates() {
        int i = this._filterList.getSelectedIndex();
        this._moveUpButton.setEnabled(i > 0);
        this._moveDownButton.setEnabled(i >= 0 && i <= this._filterListModel.getSize() - 2);
        this._removeButton.setEnabled(this._editedFilter != null);
        this._detailBorder.setTitle(HistoryArb.format("FILTER_DETAIL", this._editedFilter != null ? this._editedFilter.getName() : ""));
        this._detailPanel.repaint();
        this._simpleExpressionRadioButton.setEnabled(this._editedFilter != null);
        this._complexExpressionRadioButton.setEnabled(this._editedFilter != null);
        boolean complex = false;
        if (this._editedFilter == null) {
            this.updateSimpleControlsFromExpression(DEFAULT_EXPRESSION);
            this._filterExpressionTextArea.setText("");
        } else {
            Pattern pattern;
            String expression = this._editedFilter.getSource();
            String[] tokens = expression.split("\\s+");
            if (tokens.length < 3 || !this.isRecognizedColumnId(tokens[0])) {
                complex = true;
            }
            if ((pattern = Pattern.compile("\\s+(AND|OR)\\s+", 2)).matcher(expression).find()) {
                complex = true;
            }
            if ((pattern = Pattern.compile("(\\+|^)NOT\\s+", 2)).matcher(expression).find()) {
                complex = true;
            }
            this.updateSimpleControlsFromExpression(complex ? DEFAULT_EXPRESSION : expression);
            this._filterExpressionTextArea.setText(expression);
            this._filterExpressionTextArea.setCaretPosition(0);
        }
        this._simpleExpressionRadioButton.setSelected(!complex);
        this._complexExpressionRadioButton.setSelected(complex);
        this.updateExpressionDependentStates();
    }

    private void updateSimpleControlsFromExpression(String expression) {
        int i;
        Pattern pattern = Pattern.compile("\\s*(.+?)\\s+(.+?)\\s+(.++)");
        Matcher matcher = pattern.matcher(expression);
        if (!matcher.find()) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return;
        }
        String columnId = matcher.group(1);
        String operatorId = matcher.group(2);
        String value = matcher.group(3);
        int n = this._columnComboBox.getModel().getSize();
        for (i = 0; i < n; ++i) {
            if (!((ColumnItem)this._columnComboBox.getModel().getElementAt(i)).getCustomFilterId().equals(columnId)) continue;
            this._columnComboBox.setSelectedIndex(i);
            break;
        }
        n = this._operatorComboBox.getModel().getSize();
        for (i = 0; i < n; ++i) {
            if (!((OperatorItem)this._operatorComboBox.getModel().getElementAt(i)).getCustomFilterId().equals(operatorId)) continue;
            this._operatorComboBox.setSelectedIndex(i);
            break;
        }
        this._valueTextField.setText(value);
    }

    private void updateExpressionDependentStates() {
        boolean simpleExpression = this._simpleExpressionRadioButton.isSelected();
        this._columnLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._columnComboBox.setEnabled(this._editedFilter != null && simpleExpression);
        this._operatorLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._operatorComboBox.setEnabled(this._editedFilter != null && simpleExpression);
        this._valueLabel.setEnabled(this._editedFilter != null && simpleExpression);
        this._valueTextField.setEnabled(this._editedFilter != null && simpleExpression);
        this._insertButton.setEnabled(this._editedFilter != null && simpleExpression);
        this._filterExpressionTextArea.setEnabled(this._editedFilter != null && !simpleExpression);
    }

    private String createSimpleExpression() {
        StringBuffer simpleExpressionBuffer = new StringBuffer();
        simpleExpressionBuffer.append(((ColumnItem)this._columnComboBox.getSelectedItem()).getCustomFilterId());
        simpleExpressionBuffer.append(' ');
        simpleExpressionBuffer.append(((OperatorItem)this._operatorComboBox.getSelectedItem()).getCustomFilterId());
        simpleExpressionBuffer.append(' ');
        simpleExpressionBuffer.append(this._valueTextField.getText());
        return simpleExpressionBuffer.toString();
    }

    private boolean isRecognizedColumnId(String columnId) {
        int n = this._columnComboBox.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            if (!((ColumnItem)this._columnComboBox.getModel().getElementAt(i)).getCustomFilterId().equals(columnId)) continue;
            return true;
        }
        return false;
    }

    private CustomFilter createCustomFilter(String filterExpression) {
        try {
            return CustomFilter.parse(filterExpression);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private int indexOfFilterName(String filterName) {
        for (int i = 0; i < this._filterListModel.getSize(); ++i) {
            if (!((CustomFilter)this._filterListModel.get(i)).getName().equals(filterName)) continue;
            return i;
        }
        return -1;
    }

    static final CustomFilter[] runDialog() {
        final CustomFilterPanel panel = new CustomFilterPanel();
        JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), HistoryArb.get("CUSTOM_FILTERS"), 7);
        dialog.setContent(panel.getGUI());
        dialog.setCenterOver((Component)IdeUtil.getMainWindow());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel.getGUI(), "f1_scscustomfilter_html");
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    panel.commitEdits();
                }
            }
        });
        return dialog.runDialog() ? panel.getCustomFilters() : null;
    }

    private static final Color getSyntaxBackgroundColor(boolean syntaxValid) {
        return UIManager.getColor(syntaxValid ? "TextField.background" : "ToolTip.background");
    }

    private static final Color getSyntaxForegroundColor(boolean syntaxValid) {
        return UIManager.getColor(syntaxValid ? "TextField.foreground" : "ToolTip.foreground");
    }

    private class SyntaxTextArea
    extends JTextArea {
        private boolean _syntaxValid;

        SyntaxTextArea() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean syntaxValid) {
            this._syntaxValid = syntaxValid;
            this.updateSyntaxUI();
        }

        @Override
        public void setBackground(Color background) {
        }

        @Override
        public void setForeground(Color foreground) {
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.getSyntaxForegroundColor(this._syntaxValid));
        }
    }

    private class SyntaxTextField
    extends JTextField {
        private boolean _syntaxValid;

        SyntaxTextField() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean syntaxValid) {
            this._syntaxValid = syntaxValid;
            this.updateSyntaxUI();
        }

        @Override
        public void setBackground(Color background) {
        }

        @Override
        public void setForeground(Color foreground) {
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.getSyntaxForegroundColor(this._syntaxValid));
        }
    }

    private class ColumnItem
    implements Comparable {
        private final DefaultHistoryProperty _historyProperty;

        ColumnItem(DefaultHistoryProperty historyProperty) {
            this._historyProperty = historyProperty;
        }

        String getCustomFilterId() {
            return this._historyProperty.getCustomFilterId();
        }

        public boolean equals(Object o) {
            return o instanceof ColumnItem && ((ColumnItem)o).getCustomFilterId().equals(this.getCustomFilterId());
        }

        public int hashCode() {
            return this.getCustomFilterId().intern().hashCode();
        }

        public String toString() {
            return this._historyProperty.getName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(((ColumnItem)o).toString());
        }
    }

    private class OperatorItem {
        private final String _id;
        private final String _renderedValue;

        OperatorItem(String id) {
            this(id, null);
        }

        OperatorItem(String id, String renderedValue) {
            this._id = id;
            this._renderedValue = renderedValue;
        }

        String getCustomFilterId() {
            return this._id;
        }

        public String toString() {
            return this._renderedValue != null ? this._renderedValue : this._id;
        }
    }

    private abstract class DocumentUpdateListener
    implements DocumentListener {
        private DocumentUpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.documentUpdate(de);
        }

        protected abstract void documentUpdate(DocumentEvent var1);
    }
}

