/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import java.util.BitSet;
import java.util.EventObject;
import javax.naming.InitialContext;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.compare.CompareContext;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.FileNotComparableException;
import oracle.jdeveloper.compare.FileTooLargeException;
import oracle.jdeveloper.compare.IdeCompareContributor;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.resource.CompareArb;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;

public class CompareIdeViewer
extends CompareViewer {
    static final String JNDI_NAME = "jdeveloper/compareviewer";
    private JMenu m_contextCompareMenu;
    private JMenu m_contextBaseCompareMenu;
    private MenuListener m_menuListener;
    private final int _otherFileAction = Ide.findOrCreateCmdID((String)"compare.CompareOther");
    private final int _savedFileAction = Ide.findOrCreateCmdID((String)"compare.CompareDirty");
    private final int _eachOtherAction = Ide.findOrCreateCmdID((String)"compare.CompareEachOther");

    public static final CompareIdeViewer getCompareIdeViewer() {
        InitialContext ic = Names.newInitialContext();
        CompareIdeViewer compareIdeViewer = (CompareIdeViewer)Names.lookup((javax.naming.Context)ic, (String)JNDI_NAME);
        if (compareIdeViewer == null) {
            compareIdeViewer = new CompareIdeViewer();
            Names.bind((javax.naming.Context)ic, (String)JNDI_NAME, (Object)compareIdeViewer);
        }
        return compareIdeViewer;
    }

    @Override
    @Deprecated
    public JMenu getMainCompareMenu() {
        Ide.getMenubar();
        return Menubar.getJMenu((String)"subMenu.FileCompare");
    }

    @Override
    public JMenu getContextCompareMenu() {
        if (this.m_contextCompareMenu == null) {
            this.m_contextCompareMenu = this.createContextCompareMenu();
        }
        return this.m_contextCompareMenu;
    }

    @Override
    public JMenu getBaseContextCompareMenu() {
        if (this.m_contextBaseCompareMenu == null) {
            this.m_contextBaseCompareMenu = this.createContextCompareMenu();
        }
        return this.m_contextBaseCompareMenu;
    }

    @Override
    public void show(final CompareContributor left, final CompareContributor right, final Element contextNode) {
        RequestProcessor processor = new RequestProcessor(CompareArb.get("COMPARE_PROGRESS_NAME"), 1, true);
        RequestProcessor.Task task = processor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)CompareArb.get("COMPARE_PROGRESS_NAME"));
                handle.start();
                final CompareInvocation invocationContext = CompareUtil.createInvocationContext(contextNode, left, right);
                try {
                    CompareModel model = CompareUtil.createCompareModel(left, right, invocationContext);
                    Node node = null;
                    if (node == null && left instanceof IdeCompareContributor) {
                        node = ((IdeCompareContributor)left).getNode();
                    }
                    if (node == null && right instanceof IdeCompareContributor) {
                        node = ((IdeCompareContributor)right).getNode();
                    }
                    if (node != null && node.getURL() != null && FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)node.getURL())) == ContentType.BINARY && (left instanceof TextCompareContributor || right instanceof TextCompareContributor)) {
                        model = null;
                    }
                    final CompareModel final_model = model;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (final_model == null || final_model.getDifferences().length != 0 || CompareUtil.confirmIdenticalCompare()) {
                                CompareIdeViewer.this._show(left, right, final_model, invocationContext);
                            }
                        }
                    });
                }
                catch (FileTooLargeException ftle) {
                    CompareIdeViewer.this.showOnFailure(left, right, invocationContext, (CompareFailedException)((Object)ftle));
                }
                catch (FileNotComparableException fnce) {
                    CompareIdeViewer.this.showOnFailure(left, right, invocationContext, (CompareFailedException)((Object)fnce));
                }
                catch (CompareFailedException cfe) {
                    if (FeedbackManager.isOn()) {
                        FeedbackManager.reportException((Throwable)cfe);
                        return;
                    }
                    ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)cfe, (String)IdeUtil.getProgramName(), (String)cfe.getMessage(), null);
                }
                catch (RuntimeException re) {
                    if (FeedbackManager.isOn()) {
                        FeedbackManager.reportException((Throwable)re);
                        return;
                    }
                    ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)re, (String)IdeUtil.getProgramName(), (String)re.getMessage(), null);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private final JMenu createContextCompareMenu() {
        JMenu compareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.get("COMPARE_WITH_MENU")), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)CompareArb.get("COMPARE_WITH_MENU"))), 0.2f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        IdeAction compareDirtyAction = IdeAction.find((int)this._savedFileAction);
        IdeAction compareOtherAction = IdeAction.find((int)this._otherFileAction);
        IdeAction compareEachOtherAction = IdeAction.find((int)this._eachOtherAction);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareDirtyAction, 1.0f), compareMenu, 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareOtherAction, 2.0f), compareMenu, 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareEachOtherAction, 1.0f), compareMenu, 2.0f);
        if (this.m_menuListener == null) {
            this.m_menuListener = new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent me) {
                }

                @Override
                public void menuDeselected(MenuEvent me) {
                }

                @Override
                public void menuSelected(MenuEvent me) {
                    View active = Ide.getMainWindow().getLastActiveView();
                    Context context = active.getContext((EventObject)me);
                    IdeAction.find((int)CompareIdeViewer.this._eachOtherAction).updateAction(context);
                    IdeAction.find((int)CompareIdeViewer.this._otherFileAction).updateAction(context);
                    IdeAction.find((int)CompareIdeViewer.this._savedFileAction).updateAction(context);
                }
            };
        }
        compareMenu.addMenuListener(this.m_menuListener);
        return compareMenu;
    }

    private final void showOnFailure(final CompareContributor left, final CompareContributor right, final CompareInvocation invocationContext, CompareFailedException cfe) {
        invocationContext.setFailure(cfe);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareIdeViewer.this._show(left, right, null, invocationContext);
            }
        });
    }

    protected void _show(CompareContributor left, CompareContributor right, CompareModel model, CompareInvocation invocationContext) {
        try {
            Context detailedContext = Context.newIdeContext();
            BitSet sequences = new BitSet();
            sequences.set(0);
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                int seq;
                URL cmpUrl;
                URL url;
                if (!(editor instanceof CompareEditor) || !(url = editor.getContext().getNode().getURL()).getProtocol().startsWith(this.getProtocol())) continue;
                if (!invocationContext.duplicatesAllowed() && (cmpUrl = this.newURL(left, right, seq = this.getSequence(url))).sameFile(url)) {
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                }
                sequences.set(this.getSequence(url));
            }
            URL u = this.newURL(left, right, sequences.nextClearBit(0));
            Node node = NodeFactory.find((URL)u);
            if (!this.validateNodeType(node)) {
                NodeFactory.uncache((URL)u);
            }
            CompareNode cn = (CompareNode)NodeFactory.findOrCreate(this.getNodeClass(), (URL)u);
            cn.setSource(left);
            cn.setTarget(right);
            cn.setModel(model);
            if (model == null) {
                cn.setMessage(CompareIdeViewer.getCompareNotAvailableMessage(invocationContext, (Exception)((Object)invocationContext.getFailure())));
            }
            detailedContext.setNode((Node)cn);
            detailedContext.setElement((Element)cn);
            detailedContext.setProperty("CompareOpenHint", (Object)invocationContext.getHint());
            CompareContext.setContributors(detailedContext, new CompareContributor[]{left, right});
            Editor ed = EditorManager.getEditorManager().openEditorInFrame(this.getEditorClass(), detailedContext);
            this.postShow(ed, u);
        }
        catch (InstantiationException ie) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ie);
        }
        catch (IllegalAccessException ille) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ille);
        }
    }

    protected void postShow(Editor ed, URL url) {
    }

    protected Class getEditorClass() {
        return CompareEditor.class;
    }

    protected Class<? extends Node> getNodeClass() {
        return CompareNode.class;
    }

    protected URL newURL(CompareContributor left, CompareContributor right, int sequence) {
        return CompareURLHelper.newCompareURL(left, right, sequence);
    }

    protected String getProtocol() {
        return "ide.compare";
    }

    protected int getSequence(URL url) {
        return CompareURLHelper.getSequence(url);
    }

    protected boolean validateNodeType(Node node) {
        if (node != null && !(node instanceof CompareNode)) {
            Assert.println((String)"CompareIdeViewer: Warning: incompatible node cached against compare URL");
            return false;
        }
        return true;
    }

    public static final String getCompareNotAvailableMessage(CompareInvocation invocationContext, Exception e) {
        if (invocationContext.isCanceled()) {
            return HistoryArb.get("COMPARE_NOT_AVAILABLE_CANCELLED");
        }
        if (e instanceof FileNotComparableException) {
            return HistoryArb.get("COMPARE_NOT_AVAILABLE_FILE_NOT_COMPARABLE");
        }
        if (e instanceof FileTooLargeException) {
            return HistoryArb.get("COMPARE_NOT_AVAILABLE_FILE_TOO_LARGE");
        }
        if (e != null) {
            return HistoryArb.get("COMPARE_NOT_AVAILABLE_ERROR_OCCURRED");
        }
        return HistoryArb.get("COMPARE_NOT_AVAILABLE");
    }
}

