/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.svg;

import oracle.viz.util.svg.SVGGraphics;
import oracle.viz.util.svg.internal.ATag;
import oracle.viz.util.svg.internal.ATagEnd;
import oracle.viz.util.svg.internal.SVGShape;
import oracle.viz.util.svg.internal.Util;

public class SVGChartGraphics
extends SVGGraphics {
    boolean enableSvg = false;

    public void setEnableSVG(boolean enable) {
        this.enableSvg = enable;
    }

    public boolean getEnableSVG() {
        return this.enableSvg;
    }

    public void setStartATagLink(String uri) {
        ATag a = new ATag();
        a.setAttributeString("xlink:href=\"" + uri + "\"");
        this.SVGElement.addElement(a);
    }

    public void setEndATag() {
        this.SVGElement.addElement(new ATagEnd());
    }

    public void drawOvalSVG(int x, int y, int width, int height) {
        SVGShape s = new SVGShape();
        String cString = Util.colorToString(this.getColor());
        String oString = Util.opacityToString(this.getColor());
        s.drawOval(x, y, width, height, cString, oString, this.strokeWidth);
        this.SVGElement.addElement(s);
    }

    public String getPlotWindowClipDef(String name, int x, int y, int width, int height) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n<clipPath id=\"");
        sbuf.append(name);
        sbuf.append("\">");
        sbuf.append("\n<rect id=\"rect1\" x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\"" + " height=\"" + height + "\"" + "/>");
        sbuf.append("\n</clipPath>\n\n");
        return sbuf.toString();
    }
}

