/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.codec;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class WBMPEncoder {
    private static final boolean DEBUG = false;
    private OutputStream output = null;
    private int width = 0;
    private int height = 0;

    public WBMPEncoder(OutputStream output) {
        this.output = output;
    }

    public void encode(RenderedImage im) throws IOException {
        SampleModel sampleModel = im.getSampleModel();
        int dataType = sampleModel.getTransferType();
        if (dataType != 0 || sampleModel.getNumBands() > 1) {
            throw new RuntimeException("Sample format not supported by WBMP");
        }
        ColorModel colorModel = im.getColorModel();
        if (colorModel.getPixelSize() != 1) {
            throw new RuntimeException("Color format not supported by WBMP");
        }
        this.writeMBInt(0, this.output);
        this.writeMBInt(0, this.output);
        this.width = im.getWidth();
        this.height = im.getHeight();
        this.writeMBInt(this.width, this.output);
        this.writeMBInt(this.height, this.output);
        boolean invertBits = false;
        if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 1) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int size = icm.getMapSize();
            byte[] reds = new byte[size];
            icm.getReds(reds);
            if (0 == reds[1]) {
                invertBits = true;
            }
        }
        DataBufferByte dbuf = (DataBufferByte)im.getData().getDataBuffer();
        int scanlineBytes = (this.width + 7) / 8;
        byte[] pixels = new byte[scanlineBytes];
        int[] buf = new int[this.width];
        int row = 0;
        while (row < this.height) {
            sampleModel.getPixels(im.getMinX(), row + im.getMinY(), this.width, 1, buf, (DataBuffer)dbuf);
            int i = 0;
            while (i < pixels.length) {
                pixels[i] = 0;
                ++i;
            }
            int col = 0;
            while (col < this.width) {
                if (buf[col] != 0) {
                    int n = col / 8;
                    pixels[n] = (byte)(pixels[n] | 1 << 7 - col % 8);
                }
                ++col;
            }
            if (invertBits) {
                this.invertBuffer(pixels);
                int padding = 8 - this.width % 8;
                if (padding < 8) {
                    int n = pixels.length - 1;
                    pixels[n] = (byte)(pixels[n] & 255 << padding);
                }
            }
            this.output.write(pixels);
            ++row;
        }
    }

    private void invertBuffer(byte[] buf) {
        int i = 0;
        while (i < buf.length) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    private void writeMBInt(int val, OutputStream str) throws IOException {
        int mask = 127;
        int shift = 0;
        while ((val & mask << 7) != 0) {
            mask <<= 7;
            shift += 7;
        }
        while (mask != 0) {
            int dummy = (val & mask) >> shift;
            if (mask >> 7 != 0) {
                dummy |= 0x80;
            }
            str.write(dummy);
            mask >>= 7;
            shift -= 7;
        }
    }
}

