/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import java.util.Vector;
import oracle.charts.axischart.internal.MathUtil;
import oracle.charts.axischart.internal.NumAxisMetrics;
import oracle.charts.internal.Precision;
import oracle.charts.types.GridDesc;
import oracle.viz.util.svg.SVGChartGraphics;

public final class NumAxisGrid {
    public GridDesc gridD = new GridDesc();
    public double spacing = 10.0;
    public boolean autoSpacing = true;
    public int numYLabels = 0;
    static final int maxSpaces = 8;
    boolean paintZeroLine = false;
    final int minLabelSeparation = 3;
    public boolean isIntegerLabels = false;
    public boolean userDefinedNumYLabels = false;
    final int[] YAxisSpacing = new int[]{1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10, 15, 15, 15, 15, 20, 20, 20, 20, 20, 20, 25, 25, 25, 25, 25, 30, 30, 30, 30, 30, 35, 35, 35, 35, 35, 40, 40, 40, 40, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 80, 80, 80, 80, 80, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};

    protected void paintZeroLineOn() {
        this.paintZeroLine = true;
    }

    protected void setSpacing(double s) {
        this.autoSpacing = false;
        this.spacing = s;
    }

    protected void setNumYLabels(int x) {
        this.numYLabels = x - 1;
        this.userDefinedNumYLabels = true;
    }

    public void setAutoSpacing(boolean vertical, double subchartDisplaywidth, double subchartDisplayheight, boolean subchartContainsDwellLabels, int subchartLabelXSpaceLeft, int subchartLabelXSpaceRight, int labelHeight, int maxLabelWidth, NumAxisMetrics yAxisMet, boolean timeIntervalFormat, boolean logScale, NumberFormat nf) {
        if (this.autoSpacing) {
            double yspread = logScale ? MathUtil.log10(yAxisMet.Ymax_non_adjusted) - MathUtil.log10(yAxisMet.Ymin_non_adjusted) : yAxisMet.Ymax_non_adjusted - yAxisMet.Ymin_non_adjusted;
            if (yspread == 0.0) {
                // empty if block
            }
            if (vertical) {
                if (!this.userDefinedNumYLabels) {
                    this.deriveNumYLabels(subchartDisplayheight, subchartContainsDwellLabels, labelHeight);
                }
                this.spacing = yAxisMet.AutoExtentMax ? this.deriveSpacing(yspread, timeIntervalFormat, nf) : this.deriveSpacing(yspread, yAxisMet, logScale, nf);
            } else {
                if (!this.userDefinedNumYLabels) {
                    this.deriveNumYLabelsHorizontal(subchartDisplaywidth, subchartContainsDwellLabels, subchartLabelXSpaceLeft, subchartLabelXSpaceRight, labelHeight, maxLabelWidth);
                }
                this.spacing = yAxisMet.AutoExtentMax ? this.deriveSpacing(yspread, timeIntervalFormat, nf) : this.deriveSpacing(yspread, yAxisMet, logScale, nf);
            }
        } else {
            int integerSpacing = (int)this.spacing;
            double diff = this.spacing - (double)integerSpacing;
            this.isIntegerLabels = diff == 0.0;
        }
    }

    private void myDrawDashHLine(Graphics2D g2, int x1, int x2, int y, BasicStroke dashedStroke) {
        g2.setStroke(dashedStroke);
        g2.drawLine(x1, y, x2, y);
    }

    private void myDrawDashVLine(Graphics2D g2, int y1, int y2, int x, BasicStroke dashedStroke) {
        g2.setStroke(dashedStroke);
        g2.drawLine(x, y1, x, y2);
    }

    public void drawBuffer(Graphics2D g2, SVGChartGraphics svgG, int x_min, int width, int y_min, int height, Vector vgrid_y, Vector vgrid_y_raster, BasicStroke defaultStroke, BasicStroke dashedStroke, BasicStroke dashedStroke2, boolean firstSubchart, boolean lastSubchart) {
        if (this.gridD.getDrawGrid()) {
            int y_max = y_min + height;
            g2.setColor(this.gridD.getColor());
            BasicStroke selectedStroke = defaultStroke;
            switch (this.gridD.getGridStyle()) {
                case 1: {
                    selectedStroke = defaultStroke;
                    break;
                }
                case 2: {
                    selectedStroke = dashedStroke;
                    break;
                }
                case 3: {
                    selectedStroke = dashedStroke2;
                }
            }
            if (svgG.getEnableSVG()) {
                svgG.startGroup("cb_grid");
            }
            g2.setStroke(selectedStroke);
            int i = 0;
            while (i < vgrid_y_raster.size()) {
                int grid_y_coordinate = ((Double)vgrid_y_raster.elementAt(i)).intValue();
                if (!(lastSubchart && i == 0 && Math.abs(y_max - grid_y_coordinate) <= 1 || firstSubchart && i == vgrid_y_raster.size() - 1 && Math.abs(y_min - grid_y_coordinate) <= 1)) {
                    g2.drawLine(x_min, grid_y_coordinate, x_min + width, grid_y_coordinate);
                }
                ++i;
            }
            if (svgG.getEnableSVG()) {
                svgG.endGroup();
            }
            g2.setStroke(defaultStroke);
        } else if (this.paintZeroLine) {
            int i = 0;
            while (i < vgrid_y.size()) {
                double grid_y_coordinate_d = (Double)vgrid_y.elementAt(i);
                if (grid_y_coordinate_d == 0.0) break;
                ++i;
            }
            int grid_y_coordinate = ((Double)vgrid_y_raster.elementAt(i)).intValue();
            g2.drawLine(x_min, grid_y_coordinate, x_min + width, grid_y_coordinate);
        }
    }

    public void drawBufferHorizontal(Graphics2D g2, SVGChartGraphics svgG, int y_min, int height, Vector vgrid_y, Vector vgrid_y_raster, BasicStroke defaultStroke, BasicStroke dashedStroke) {
        if (this.gridD.getDrawGrid()) {
            if (svgG.getEnableSVG()) {
                svgG.startGroup("grid");
            }
            g2.setColor(this.gridD.getColor());
            int i = 0;
            while (i < vgrid_y.size()) {
                int grid_x_coordinate = ((Double)vgrid_y_raster.elementAt(i)).intValue();
                switch (this.gridD.getGridStyle()) {
                    case 1: {
                        g2.drawLine(grid_x_coordinate, y_min, grid_x_coordinate, y_min + height);
                        break;
                    }
                    case 2: {
                        this.myDrawDashVLine(g2, y_min, y_min + height, grid_x_coordinate, dashedStroke);
                    }
                }
                ++i;
            }
            if (svgG.getEnableSVG()) {
                svgG.endGroup();
            }
        } else if (this.paintZeroLine) {
            g2.setStroke(defaultStroke);
            int i = 0;
            while (i < vgrid_y.size()) {
                double grid_x_coordinate_d = (Double)vgrid_y.elementAt(i);
                if (grid_x_coordinate_d == 0.0) break;
                ++i;
            }
            int grid_x_coordinate = ((Double)vgrid_y_raster.elementAt(i)).intValue();
            g2.drawLine(grid_x_coordinate, y_min, grid_x_coordinate, y_min + height);
        }
    }

    protected void deriveNumYLabels(double subchartDisplayheight, boolean containsDwellLabels, int labelHeightP) {
        int labelHeight;
        boolean testYAxis = false;
        if (testYAxis) {
            System.out.println();
            System.out.println();
            System.out.println("Derive Num YLabels ");
        }
        if ((labelHeight = labelHeightP + (int)((double)labelHeightP * 0.5)) <= 0) {
            labelHeight = 10;
        }
        if (testYAxis) {
            System.out.println("deriveNumYLabels(): subchartDisplayheight " + subchartDisplayheight + " numYLabels " + this.numYLabels + " labelHeight " + labelHeight);
        }
        int temp = (int)subchartDisplayheight / labelHeight;
        if (testYAxis) {
            System.out.println(" deriveNumYLabels() temp = " + temp);
        }
        if (temp > 0) {
            this.numYLabels = temp;
            if (containsDwellLabels && this.numYLabels > 1) {
                --this.numYLabels;
            }
        } else {
            this.numYLabels = 1;
        }
        if (this.numYLabels > 8) {
            this.numYLabels = 8;
        }
        if (testYAxis) {
            System.out.println(" deriveNumYLabels() numYLabels = " + this.numYLabels);
        }
    }

    protected void deriveNumYLabelsHorizontal(double subchartDisplaywidth, boolean containsDwellLabels, int labelXSpaceLeft, int labelXSpaceRight, int labelHeight, int maxLabelWidth) {
        boolean test = false;
        int width = (int)(subchartDisplaywidth - (double)labelXSpaceLeft - (double)labelXSpaceRight);
        int temp = width / (maxLabelWidth + labelHeight);
        if (temp > 0) {
            this.numYLabels = temp;
            if (containsDwellLabels && this.numYLabels > 1) {
                --this.numYLabels;
            }
        } else {
            this.numYLabels = 1;
        }
    }

    protected double deriveSpacing(double yspread, boolean timeIntervalFormat, NumberFormat nf) {
        boolean test = false;
        double mult_factor = 1.0;
        if (yspread > 10.0 && yspread <= 100.0) {
            mult_factor = 1.0;
        } else if (yspread <= 10.0) {
            while (yspread * mult_factor <= 10.0) {
                mult_factor *= 10.0;
            }
        } else if (yspread > 100.0 && yspread * mult_factor > 100.0) {
            if (timeIntervalFormat && yspread * (mult_factor /= 60.0) > 100.0) {
                mult_factor /= 60.0;
            }
            while (yspread * mult_factor > 100.0) {
                mult_factor /= 10.0;
            }
        }
        long interLabelSpacing = Precision.IntCeil((int)(yspread *= mult_factor), this.numYLabels);
        if (interLabelSpacing < (long)this.YAxisSpacing.length) {
            interLabelSpacing = this.YAxisSpacing[(int)interLabelSpacing];
        } else {
            interLabelSpacing /= 5L;
            interLabelSpacing *= 5L;
        }
        double interLabelSpacingActual = interLabelSpacing;
        interLabelSpacingActual /= mult_factor;
        if (interLabelSpacingActual > 1000.0) {
            interLabelSpacing = (long)(interLabelSpacingActual += 0.5);
            interLabelSpacingActual = interLabelSpacing;
        }
        if (nf != null && nf.getMaximumFractionDigits() == 0) {
            if (interLabelSpacingActual < 1.0) {
                return 1.0;
            }
            return Math.round(interLabelSpacingActual);
        }
        long integerSpacing = (long)interLabelSpacingActual;
        double diff = interLabelSpacingActual - (double)integerSpacing;
        this.isIntegerLabels = diff == 0.0;
        return interLabelSpacingActual;
    }

    protected double deriveSpacing(double yspread, NumAxisMetrics yAxisMet, boolean logScale, NumberFormat nf) {
        int minYLabels;
        double spread = yspread;
        if (!yAxisMet.AutoExtentMin && !yAxisMet.AutoExtentMax) {
            spread = logScale ? MathUtil.log10(yAxisMet.Ymax_non_adjusted) - MathUtil.log10(yAxisMet.Ymin_non_adjusted) : yAxisMet.Ymax_non_adjusted - yAxisMet.Ymin_non_adjusted;
        }
        if (yAxisMet.AutoExtentMin && !yAxisMet.AutoExtentMax) {
            double zeroAdjustFactor = 0.3;
            spread = yAxisMet.Ymin_non_adjusted > 0.0 && yAxisMet.Ymin_non_adjusted < zeroAdjustFactor * yAxisMet.Ymax_non_adjusted ? (logScale ? MathUtil.log10(yAxisMet.Ymax_non_adjusted) : yAxisMet.Ymax_non_adjusted) : (logScale ? MathUtil.log10(yAxisMet.Ymax_non_adjusted) - MathUtil.log10(yAxisMet.Ymin_non_adjusted) : yAxisMet.Ymax_non_adjusted - yAxisMet.Ymin_non_adjusted);
        }
        if ((minYLabels = this.numYLabels / 3) <= 1) {
            minYLabels = 2;
        }
        long interval = 0L;
        boolean found = false;
        double mult_factor = 1.0;
        if (yspread <= 10.0) {
            mult_factor = 10.0;
            while (yspread * mult_factor < 10.0) {
                mult_factor *= 10.0;
            }
        }
        int i = this.numYLabels;
        while (i >= minYLabels) {
            interval = (long)(yspread * mult_factor) / (long)i;
            if ((double)((long)i * interval) == yspread * mult_factor) {
                found = true;
                break;
            }
            --i;
        }
        double interLabelSpacingActual = 1.0;
        interLabelSpacingActual = found ? (double)interval / mult_factor : spread / (double)this.numYLabels;
        if (nf != null && nf.getMaximumFractionDigits() == 0) {
            if (interLabelSpacingActual < 1.0) {
                return 1.0;
            }
            return Math.round(interLabelSpacingActual);
        }
        return interLabelSpacingActual;
    }
}

