/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.html;

import com.oracle.premigration.commons.io.ResourceFinder;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.addinform.redo.RedoHistory;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.ReportData;
import com.oracle.premigration.reports.html.HtmlReportData;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.html.sections.HtmlSection;
import com.oracle.premigration.reports.json.serialization.JsonSerializer;
import com.oracle.premigration.reports.text.TextProperty;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.json.JsonStructure;

public class HtmlReport {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(HtmlReport.class.getName());
    private static final Language lang = Language.getInstance();
    private static final String DEFAULT_COLUMN_DEFINITION = "[{\"field\":\"label\",\"style\":\"white-space:normal;\"},{\"field\":\"value\",\"style\":\"white-space:normal;\"}]";
    private static final String DEFAULT_COLUMN_DEFINITION_CHECK_RESULTS = "[{\"headerText\":\"Check Result\",\"field\":\"resultDisplayName\",\"style\":\"white-space:normal;\"},{\"headerText\":\"Result Description\",\"field\":\"resultDescription\",\"style\":\"white-space:normal;\"}]";
    private static final String DEFAULT_COLUMN_DEFINITION_PATCH_INFORMATION = "[{\"headerText\": \"COMMENTS\", \"field\": \"COMMENTS\" }, { \"headerText\": \"SOURCE_VERSION\", \"field\": \"SOURCE_VERSION\" }, { \"headerText\": \"TARGET_VERSION\", \"field\": \"TARGET_VERSION\" }, { \"headerText\": \"ACTION\", \"field\": \"ACTION\" }, { \"headerText\": \"ACTION_TIME\", \"field\": \"ACTION_TIME\" } ]";

    private HtmlReport() {
    }

    public static String writeHtml(Object reportData, String htmlOutputFilename) throws IOException, PremigrationException {
        HtmlReportData htmlReportData = HtmlReport.createJSONReportData(reportData);
        JsonStructure jsonReport = (JsonStructure)JsonSerializer.toJson(htmlReportData);
        String layout = new ResourceFinder("common/HtmlReport/layout.html").getResourceAsText();
        String oracleLogoSvg = new ResourceFinder("common/HtmlReport/Oracle_pms_180C.svg").getResourceAsText();
        DateFormat dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
        String dateString = dateFormatter.format(AppVersion.getAppVersionDate());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("charset", System.getProperty("file.encoding"));
        map.put("language", System.getProperty("user.language"));
        map.put("title", lang.txt("REPORT_TITLE_HTML"));
        map.put("appVersion", lang.txt("APP_VERSION_HTML"));
        map.put("appVersionValue", AppVersion.getVersionString());
        map.put("appVersionDate", lang.txt("APP_VERSION_DATE_HTML"));
        map.put("appVersionDateValue", dateString);
        map.put("buildDate", lang.txt("APP_AGE_LABEL_HTML"));
        map.put("buildDateValue", lang.txt("APP_AGE_VALUE_HTML"));
        map.put("oldVersion", HtmlReport.checkUpdateMessage());
        map.put("oldVersionValue", "90");
        map.put("time", new Date().toString());
        map.put("banner", lang.txt("REPORT_BANNER_HTML"));
        map.put("year", String.valueOf(Calendar.getInstance().get(1)));
        map.put("oracleLogo", oracleLogoSvg);
        map.put("expandAllButton", lang.txt("REPORT_BUTTON_EXPAND_LABEL"));
        map.put("closeAllButton", lang.txt("REPORT_BUTTON_CLOSE_LABEL"));
        String javascriptLayout = new ResourceFinder("common/HtmlReport/javascript.html").getResourceAsText();
        HashMap<String, String> javascriptMap = new HashMap<String, String>();
        javascriptMap.put("htmlReportData", jsonReport.toString());
        String javascriptTag = Utilities.mergeTags(javascriptLayout, javascriptMap);
        map.put("javascript", javascriptTag);
        String tableOfContentLayout = new ResourceFinder("common/HtmlReport/tableOfContents.html").getResourceAsText();
        String tableOfContentTag = Utilities.mergeTags(tableOfContentLayout, Collections.singletonMap("tableOfContentLabel", lang.txt("REPORT_TABLE_OF_CONTENT_LABEL_HTML")));
        map.put("tableOfContent", tableOfContentTag);
        String reportContentLayout = new ResourceFinder("common/HtmlReport/reportContent.html").getResourceAsText();
        String analysisNoteTable = new ResourceFinder("common/HtmlReport/reportAnalysisNoteTable.html").getResourceAsText();
        String detailsTableLayout = new ResourceFinder("common/HtmlReport/databaseDetailsTable.html").getResourceAsText();
        String patchInformationTablesLayout = new ResourceFinder("common/HtmlReport/sourceDatabasePatchInformation.html").getResourceAsText();
        String srcDatabaseVersionLayout = new ResourceFinder("common/HtmlReport/sourceDatabaseVersion.html").getResourceAsText();
        String reportDetailsLayout = new ResourceFinder("common/HtmlReport/reportDetails.html").getResourceAsText();
        String srcRedoDataLayout = new ResourceFinder("common/HtmlReport/sourceRedoData.html").getResourceAsText();
        String reportLegendLayout = new ResourceFinder("common/HtmlReport/reportLegend.html").getResourceAsText();
        String checkSummaryLayout = new ResourceFinder("common/HtmlReport/checkSummary.html").getResourceAsText();
        String checkListLayout = new ResourceFinder("common/HtmlReport/checkList.html").getResourceAsText();
        HashMap<String, String> reportDetailsMap = new HashMap<String, String>();
        reportDetailsMap.put("moreReportDetails", lang.txt("MORE_DETAILS_BUTTON_HTML"));
        reportDetailsLayout = Utilities.mergeTags(reportDetailsLayout, reportDetailsMap);
        HashMap<String, String> redoDataMap = new HashMap<String, String>();
        redoDataMap.put("srcLogMode", lang.txt("SRC_LOG_MODE"));
        redoDataMap.put("srcRedoSizeInfo", lang.txt("SRC_REDO_SIZE_INFO"));
        redoDataMap.put("srcRedoHistoryInfo", lang.txt("SRC_REDO_HISTORY_INFO"));
        srcRedoDataLayout = Utilities.mergeTags(srcRedoDataLayout, redoDataMap);
        HashMap<String, String> checkListMap = new HashMap<String, String>();
        checkListMap.put("expandAllButton", lang.txt("REPORT_BUTTON_EXPAND_LABEL"));
        checkListMap.put("closeAllButton", lang.txt("REPORT_BUTTON_CLOSE_LABEL"));
        checkListMap.put("moreReportDetails", lang.txt("MORE_DETAILS_BUTTON_HTML"));
        checkListLayout = Utilities.mergeTags(checkListLayout, checkListMap);
        HashMap<String, String> reportContentMap = new HashMap<String, String>();
        reportContentMap.put("reportAnalysisNoteTable", analysisNoteTable);
        reportContentMap.put("databaseDetailsTable", detailsTableLayout);
        reportContentMap.put("sourceDatabasePatchInformation", patchInformationTablesLayout);
        reportContentMap.put("sourceDatabaseVersion", srcDatabaseVersionLayout);
        reportContentMap.put("sourceRedoData", srcRedoDataLayout);
        reportContentMap.put("reportDetails", reportDetailsLayout);
        reportContentMap.put("reportLegend", reportLegendLayout);
        reportContentMap.put("checkSummary", checkSummaryLayout);
        reportContentMap.put("checkList", checkListLayout);
        reportContentMap.put("returnTable", lang.txt("REPORT_RETURN_TABLE_LABEL_HTML"));
        String reportContent = Utilities.mergeTags(reportContentLayout, reportContentMap);
        map.put("reportContent", reportContent);
        String result = Utilities.mergeTags(layout, map);
        File reportFile = new File(htmlOutputFilename);
        FileWriter fileWriter = new FileWriter(reportFile);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.write(result);
        printWriter.flush();
        printWriter.close();
        return reportFile.getCanonicalPath();
    }

    private static HtmlReportData createJSONReportData(Object reportData) {
        HtmlReportData htmlReportData = new HtmlReportData();
        ReportData data = (ReportData)reportData;
        try {
            htmlReportData.setCheckSummaryData(HtmlReport.getFormattedCheckSummaryData(data));
            htmlReportData.setReportDetailsData(HtmlReport.getFormattedReportDetailsData(data));
            htmlReportData.setSourceDatabaseDetailsData(HtmlReport.getFormattedSourceDatabaseDetails(data));
            htmlReportData.setReportAnalysisNotesData(data.getAnalysisNotes());
            htmlReportData.setSourceDatabaseVersionData(HtmlReport.getFormattedSourceDatabaseVersion(data));
            htmlReportData.setSourceDatabasePatchInformationData(HtmlReport.getFormattedSourcePatchInformation(data));
            htmlReportData.setSourceDatabaseRedoData(data.getSrcRedoData());
            htmlReportData.setCheckResultDescriptions(data.getCheckResultDescriptions());
            htmlReportData.setReportNotes(data.getReportNotes());
            htmlReportData.setCheckList(HtmlReport.getFormattedCheckList(data));
            htmlReportData.setReportResultsOverview(HtmlReport.getFormattedReportResultsOverview(data));
            htmlReportData.setReportResults(HtmlReport.getFormattedReportResults());
            htmlReportData.setSectionList(HtmlReport.getFormattedSectionList(htmlReportData));
        }
        catch (IllegalAccessException e) {
            log.severe("Exception attempting to format Report Data for Html Report", e);
            e.printStackTrace();
        }
        return htmlReportData;
    }

    private static List<Map<String, String>> getFormattedCheckSummaryData(ReportData reportData) throws IllegalAccessException {
        return new ArrayList<Map<String, String>>(HtmlReport.formatData(reportData, HtmlReportSectionName.CHECK_SUMMARY));
    }

    private static Map<String, List<Map<String, String>>> getFormattedReportDetailsData(ReportData reportData) throws IllegalAccessException {
        HashMap<String, List<Map<String, String>>> detailsData = new HashMap<String, List<Map<String, String>>>();
        detailsData.put("priorityInfo", HtmlReport.formatData(reportData, HtmlReportSectionName.REPORT_DETAILS));
        detailsData.put("hideInfo", HtmlReport.formatData(reportData, HtmlReportSectionName.REPORT_DETAILS_HIDE));
        detailsData.put("versionDate", Collections.singletonList(Collections.singletonMap("versionDate", Utilities.getISODateTimeString(AppVersion.getAppVersionDate()))));
        return detailsData;
    }

    private static List<Map<String, String>> getFormattedSourceDatabaseDetails(ReportData reportData) throws IllegalAccessException {
        return new ArrayList<Map<String, String>>(HtmlReport.formatData(reportData, HtmlReportSectionName.SRC_DATABASE_DETAILS));
    }

    private static Map<String, List<Map<String, String>>> getFormattedSourceDatabaseVersion(ReportData reportData) throws IllegalAccessException {
        HashMap<String, List<Map<String, String>>> detailsData = new HashMap<String, List<Map<String, String>>>();
        detailsData.put("versionTable", reportData.getSrcDatabaseVersionData());
        detailsData.put("versionInfo", HtmlReport.formatData(reportData, HtmlReportSectionName.SRC_VERSION_INFORMATION_INFO));
        return detailsData;
    }

    private static List<Map<String, String>> getFormattedSourcePatchInformation(ReportData reportData) {
        return new ArrayList<Map<String, String>>(reportData.getSrcDatabasePatchInfo());
    }

    private static List<Map<String, Object>> getFormattedCheckList(ReportData reportData) throws IllegalAccessException {
        ArrayList<Map<String, Object>> checkList = new ArrayList<Map<String, Object>>();
        List<Check> checks = reportData.getCheckList();
        for (Check check : checks) {
            HashMap<String, Object> checkMap = new HashMap<String, Object>();
            for (Field field : Check.class.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(HtmlProperty.class) || field.get(check) == null) continue;
                Object value = field.get(check);
                checkMap.put(field.getName(), value);
            }
            checkMap.put("fixups", HtmlReport.fromFixups(check));
            checkMap.put("columnDefinition", HtmlReport.createColumnDefinitionsFromCheck(check));
            checkList.add(checkMap);
        }
        return checkList;
    }

    private static List<Map<String, Object>> getFormattedReportResultsOverview(ReportData reportData) {
        ArrayList<Map<String, Object>> reportResultsOverviews = new ArrayList<Map<String, Object>>();
        for (Check.Group group : Check.Group.values()) {
            HashMap<String, Object> resultOverview = new HashMap<String, Object>();
            resultOverview.put("group", (Object)group);
            resultOverview.put("partition", group.toString().toLowerCase());
            resultOverview.put("title", lang.txt("TITLE_NAME_FOR_" + (Object)((Object)group)));
            ArrayList results = new ArrayList();
            for (CheckResult result : CheckResult.values()) {
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("result", result.name());
                entry.put("checks", HtmlReport.getNumberOfCheckPerGroupAndResult(reportData.getCheckList(), group, result));
                results.add(entry);
            }
            resultOverview.put("results", results);
            reportResultsOverviews.add(resultOverview);
        }
        return reportResultsOverviews;
    }

    private static List<HtmlSection> getFormattedSectionList(HtmlReportData data) {
        ArrayList<HtmlSection> sectionList = new ArrayList<HtmlSection>();
        HtmlSection checkSummary = HtmlSection.builder().sectionName(lang.txt("REPORT_SUMMARY_TITLE_LABEL_HTML")).idSection("reportCheckSummary").expanded("true").columns(Collections.singletonList(DEFAULT_COLUMN_DEFINITION)).build();
        sectionList.add(checkSummary);
        HtmlSection reportDetails = HtmlSection.builder().sectionName(lang.txt("REPORT_DETAILS_TITLE_LABEL_HTML")).idSection("reportDetailsTable").expanded("true").columns(Collections.singletonList(DEFAULT_COLUMN_DEFINITION)).build();
        sectionList.add(reportDetails);
        HtmlSection reportAnalysis = HtmlSection.builder().sectionName(lang.txt("REPORT_ANALYSIS_NOTES_TITLE_LABEL_HTML")).idSection("reportAnalysisNoteTable").expanded("false").columns(Collections.singletonList(HtmlReport.createColumnDefinitionFromObject(data.getReportAnalysisNotesData().get(0)))).build();
        sectionList.add(reportAnalysis);
        HtmlSection databaseDetails = HtmlSection.builder().sectionName(lang.txt("REPORT_DATABASE_DETAILS_TITLE_LABEL_HTML")).idSection("databaseDetailsTable").expanded("false").columns(Collections.singletonList(DEFAULT_COLUMN_DEFINITION)).build();
        sectionList.add(databaseDetails);
        ArrayList<String> columnsArrays = new ArrayList<String>();
        columnsArrays.add(HtmlReport.createColumnDefinitionFromObject(data.getSourceDatabaseVersionData().get("versionTable")));
        columnsArrays.add(DEFAULT_COLUMN_DEFINITION);
        HtmlSection sourceDatabaseVersion = HtmlSection.builder().sectionName(lang.txt("REPORT_DATABASE_VERSION_TITLE_LABEL_HTML")).idSection("sourceDatabaseVersion").expanded("false").columns(columnsArrays).build();
        sectionList.add(sourceDatabaseVersion);
        HtmlSection sourceDatabasePatch = HtmlSection.builder().sectionName(lang.txt("REPORT_DATABASE_PATCH_TITLE_LABEL_HTML")).idSection("sourceDatabasePatchInformation").expanded("false").columns(Collections.singletonList(DEFAULT_COLUMN_DEFINITION_PATCH_INFORMATION)).build();
        sectionList.add(sourceDatabasePatch);
        columnsArrays = new ArrayList();
        List<RedoHistory> redoHistoryList = data.getSourceDatabaseRedoData().getRedoHistory();
        if (redoHistoryList.isEmpty()) {
            columnsArrays.add(HtmlReport.createColumnDefinitionFromObject(RedoHistory.createEmptyRedoHistoryInstance()));
        } else {
            columnsArrays.add(HtmlReport.createColumnDefinitionFromObject(redoHistoryList));
        }
        columnsArrays.add(HtmlReport.createColumnDefinitionFromObject(data.getSourceDatabaseRedoData().getSysStatRedoSize()));
        HtmlSection sourceRedoSection = HtmlSection.builder().sectionName(lang.txt("REPORT_DATABASE_REDO_TITLE_LABEL_HTML")).idSection("sourceRedoData").expanded("false").columns(columnsArrays).build();
        sectionList.add(sourceRedoSection);
        HtmlSection checkList = HtmlSection.builder().sectionName(lang.txt("REPORT_CHECK_LIST_TITLE_LABEL_HTML")).idSection("checkList").expanded("true").columns(Collections.emptyList()).build();
        sectionList.add(checkList);
        columnsArrays = new ArrayList();
        columnsArrays.add(HtmlReport.createColumnDefinitionFromObject(data.getReportNotes().get(0)));
        columnsArrays.add(DEFAULT_COLUMN_DEFINITION_CHECK_RESULTS);
        HtmlSection reportLegend = HtmlSection.builder().sectionName(lang.txt("REPORT_REPORT_LEGEND_TITLE_LABEL_HTML")).idSection("reportLegend").expanded("false").columns(columnsArrays).build();
        sectionList.add(reportLegend);
        return sectionList;
    }

    private static List<Map<String, Object>> getFormattedReportResults() {
        ArrayList<Map<String, Object>> reportResults = new ArrayList<Map<String, Object>>();
        for (CheckResult result : CheckResult.values()) {
            HashMap<String, Object> reportResult = new HashMap<String, Object>();
            reportResult.put("result", (Object)result);
            reportResult.put("title", result.toString());
            reportResult.put("styleClass", result.name().toLowerCase() + "PartitionStyle");
            reportResults.add(reportResult);
        }
        return reportResults;
    }

    private static String getNumberOfCheckPerGroupAndResult(List<Check> checkList, Check.Group group, CheckResult result) {
        int resultCount = 0;
        for (Check check : checkList) {
            if (!check.getResult().equals((Object)result) || !check.getGrouping().equals((Object)group)) continue;
            ++resultCount;
        }
        return resultCount + "";
    }

    private static String fromFixups(Check check) {
        StringBuilder fixupString = new StringBuilder();
        if (check.getFixups() != null && !check.getFixups().isEmpty()) {
            for (Fixup fixup : check.getFixups()) {
                fixupString.append(fixup.toString()).append(" ");
            }
        }
        return fixupString.toString();
    }

    private static List<String> createColumnDefinitionsFromCheck(Check check) {
        if (check.getRelevantObjectsData() != null && !check.getRelevantObjectsData().isEmpty()) {
            return Collections.singletonList(HtmlReport.createColumnDefinitionFromObject(check.getRelevantObjectsData()));
        }
        return Collections.emptyList();
    }

    private static String createColumnDefinitionFromObject(Object data) {
        StringBuilder definition = new StringBuilder();
        if (data instanceof List) {
            Object object = ((List)data).get(0);
            return HtmlReport.createColumnDefinitionFromObject(object);
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            definition.append("[");
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                definition.append("{\"headerText\":\"").append(key.toString().toUpperCase()).append("\",");
                definition.append("\"field\":\"").append(key).append("\",");
                definition.append("\"style\":\"white-space:normal;\"},");
            }
        } else {
            definition.append("[");
            for (Field field : data.getClass().getDeclaredFields()) {
                if ("log".equals(field.getName()) && field.getType().getSimpleName().contains("PremigrationLogger")) continue;
                String headerText = field.isAnnotationPresent(HtmlProperty.class) ? lang.txt(field.getAnnotation(HtmlProperty.class).labelKey()) : (field.isAnnotationPresent(TextProperty.class) ? lang.txt(field.getAnnotation(TextProperty.class).labelKey()) : field.getName().toUpperCase());
                definition.append("{\"headerText\":\"").append(headerText).append("\",");
                definition.append("\"field\":\"").append(field.getName()).append("\",");
                definition.append("\"style\":\"white-space:normal;\"},");
            }
        }
        definition.deleteCharAt(definition.length() - 1);
        definition.append("]");
        return definition.toString();
    }

    private static List<Map<String, String>> formatData(Object object, HtmlReportSectionName reportSectionName) throws IllegalAccessException {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(HtmlProperty.class) || field.get(object) == null) continue;
            Object value = field.get(object);
            if (field.getAnnotation(HtmlProperty.class).isClassInfo()) {
                data.addAll(HtmlReport.formatData(value, reportSectionName));
                continue;
            }
            if (field.getAnnotation(HtmlProperty.class).section() != reportSectionName) continue;
            data.add(HtmlReport.createEntry(object, field));
        }
        return data;
    }

    private static String checkUpdateMessage() {
        if (AppVersion.getAppAgeInDays() >= 90) {
            return lang.txt("APP_UPDATE_MESSAGE", lang.txt("MOS_LINK_HTML"));
        }
        return "";
    }

    private static Map<String, String> createEntry(Object object, Field field) throws IllegalAccessException {
        HashMap<String, String> entry = new HashMap<String, String>();
        String labelKey = field.getAnnotation(HtmlProperty.class).labelKey();
        entry.put("label", lang.txt(labelKey));
        entry.put("value", field.get(object).toString());
        return entry;
    }
}

