/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;

public class has_public_synonyms
extends Check
implements Fixable {
    public has_public_synonyms() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.SCHEMA_ONLY);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "REFERENCED_OWNER");
        String sqlQuery = "SELECT OWNER, NAME, TYPE, REFERENCED_OWNER, REFERENCED_NAME, REFERENCED_TYPE FROM SYS.DBA_DEPENDENCIES " + whereClause + " AND OWNER = 'PUBLIC'  AND TYPE = 'SYNONYM'";
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "create_public_synonyms";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "create_public_synonyms" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("create_public_synonyms").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            ArrayList<String> dmlStatements = new ArrayList<String>();
            for (Map<String, String> relevantObject : this.getRelevantObjectsData()) {
                String dml = "CREATE PUBLIC SYNONYM " + relevantObject.get("NAME") + " FOR " + relevantObject.get("REFERENCED_OWNER") + "." + relevantObject.get("REFERENCED_NAME") + ";";
                dmlStatements.add(dml);
            }
            fileHelper.writeFixupText(dmlStatements, 1);
            this.addFixup(sqlFixup);
        }
        catch (Exception e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "create_public_synonyms", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }
}

