/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;

public class has_oracle_streams
extends Check {
    protected static final String FIND_ORACLE_STREAMS = "SELECT CAPTURE_NAME AS STREAMS_NAME, QUEUE_NAME AS OBJECT_NAME, QUEUE_OWNER AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_CAPTURE UNION ALL SELECT CAPTURE_NAME AS STREAMS_NAME, QUEUE_NAME AS OBJECT_NAME, QUEUE_OWNER AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_SYNC_CAPTURE UNION ALL SELECT APPLY_NAME AS STREAMS_NAME, QUEUE_NAME AS OBJECT_NAME, QUEUE_OWNER AS OBJECT_OWNER, 'APPLY' AS OBJECT_TYPE FROM SYS.DBA_APPLY UNION ALL SELECT PROPAGATION_NAME AS STREAMS_NAME,  SOURCE_QUEUE_NAME AS OBJECT_NAME, SOURCE_QUEUE_OWNER AS OBJECT_OWNER, 'PROPAGATION' AS OBJECT_TYPE FROM SYS.DBA_PROPAGATION UNION ALL SELECT STREAMS_NAME AS STREAMS_NAME, QUEUE_NAME AS OBJECT_NAME, QUEUE_OWNER AS OBJECT_OWNER, 'MESSAGE' AS OBJECT_TYPE FROM SYS.DBA_STREAMS_MESSAGE_CONSUMERS WHERE QUEUE_OWNER != 'SYS'UNION ALL SELECT SOURCE_DATABASE AS STREAMS_NAME,  SOURCE_OBJECT_NAME AS OBJECT_NAME, SOURCE_OBJECT_OWNER AS OBJECT_OWNER, 'APPLY' AS OBJECT_TYPE FROM SYS.DBA_APPLY_INSTANTIATED_OBJECTS UNION ALL SELECT SOURCE_DATABASE AS STREAMS_NAME,  ' ' AS OBJECT_NAME, ' ' AS OBJECT_OWNER, 'APPLY' AS OBJECT_TYPE FROM SYS.DBA_APPLY_INSTANTIATED_GLOBAL UNION ALL SELECT TABLE_NAME AS STREAMS_NAME, ' ' AS OBJECT_NAME, TABLE_OWNER AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_CAPTURE_PREPARED_TABLES UNION ALL SELECT TABLE_NAME AS STREAMS_NAME, ' ' AS OBJECT_NAME, TABLE_OWNER AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_SYNC_CAPTURE_PREPARED_TABS UNION ALL SELECT SCHEMA_NAME AS STREAMS_NAME, SCHEMA_NAME AS OBJECT_NAME, ' ' AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_CAPTURE_PREPARED_SCHEMAS UNION ALL SELECT 'DATABASE' AS STREAMS_NAME,  TO_CHAR(TIMESTAMP) AS OBJECT_NAME, ' ' AS OBJECT_OWNER, 'CAPTURE' AS OBJECT_TYPE FROM SYS.DBA_CAPTURE_PREPARED_DATABASE UNION ALL SELECT COLUMN_NAME AS STREAMS_NAME, OBJECT_NAME AS OBJECT_NAME, OBJECT_OWNER AS OBJECT_OWNER, 'APPLY' AS OBJECT_TYPE FROM SYS.DBA_APPLY_CONFLICT_COLUMNS UNION ALL SELECT COLUMN_NAME AS STREAMS_NAME, OBJECT_NAME AS OBJECT_NAME, OBJECT_OWNER AS OBJECT_OWNER, 'APPLY' AS OBJECT_TYPE FROM SYS.DBA_APPLY_KEY_COLUMNS";

    public has_oracle_streams() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setSqlQuery(FIND_ORACLE_STREAMS);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (Version.V19_1_0_0.compare(exeCtx.getDatabaseVersion()) <= 0 || exeCtx.isDatabaseIsCDB()) {
            this.skipCheck(this.lang.txt("CHECK.HAS_ORACLE_STREAMS.SKIP"), CheckResult.PASS);
        }
    }
}

