/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class has_db_link_synonyms
extends FilterableCheck
implements Fixable {
    public has_db_link_synonyms() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWS, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("SYNONYM_NAME").objectTypeFixed("SYNONYM").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String dbLinksSql = "SELECT OWNER, DB_LINK, SYNONYM_NAME, TABLE_NAME FROM SYS.DBA_SYNONYMS " + whereClause + " AND DB_LINK IS NOT NULL  ORDER BY 1, 2, 3";
        this.setSqlQuery(dbLinksSql);
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "create_db_link_synonyms";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "create_db_link_synonyms" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("create_db_link_synonyms").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            for (Map<String, String> relevantObject : this.getRelevantObjectsData()) {
                String ddlQuery = "SELECT DBMS_METADATA.GET_DDL('SYNONYM','" + relevantObject.get("SYNONYM_NAME") + "','" + relevantObject.get("OWNER") + "') FROM DUAL";
                List<String> ddlStaments = SqlUtils.getDDLStringList(ddlQuery, exeCtx);
                fileHelper.writeFixupText(ddlStaments, 1);
                this.addFixup(sqlFixup);
            }
        }
        catch (SQLException e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "create_db_link_synonyms", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }
}

