/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class has_columns_with_local_timezone
extends FilterableCheck
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_columns_with_local_timezone.class.getName());
    private String srcDBTimeZone;

    public has_columns_with_local_timezone() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.OTHER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        try {
            this.srcDBTimeZone = SqlUtils.getSingleString("SELECT DBTIMEZONE FROM DUAL", exeCtx);
            log.info("srcDBTimeZone = " + this.srcDBTimeZone);
        }
        catch (SQLException e) {
            String errorMessage = Utilities.getErrorText("ERROR2011", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, exeCtx.getEnvCtx(), Level.SEVERE, e);
            this.skipCheck(e.getMessage(), CheckResult.FATAL);
            return;
        }
        String tgtDBTimeZone = exeCtx.getAnalysisProperty(TargetInstanceProp.DB_TIME_ZONE.getKey(), "+00:00");
        log.info("tgtDBTimeZone = " + tgtDBTimeZone);
        if (tgtDBTimeZone.equals(this.srcDBTimeZone)) {
            String message = this.lang.txt("CHECK.HAS_COLUMNS_WITH_LOCAL_TIMEZONE.SKIP", this.getName(), "DBTIMEZONE", this.srcDBTimeZone);
            this.skipCheck(message, CheckResult.PASS);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "C.OWNER");
        String sqlQuery = "SELECT C.OWNER, C.TABLE_NAME, C.COLUMN_NAME, C.DATA_TYPE  FROM DBA_TAB_COLS C, DBA_OBJECTS O" + whereClause + "   AND C.DATA_TYPE LIKE 'TIMESTAMP%WITH LOCAL TIME ZONE'   AND C.OWNER=O.OWNER   AND C.TABLE_NAME = O.OBJECT_NAME   AND O.OBJECT_TYPE <> 'VIEW' ORDER BY 1,2,3,4";
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "alter_time_zone";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "alter_time_zone" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).runAtCDBLevel(false).restartRequired(true).fixupName("alter_time_zone").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            List<String> sqlStatements = Collections.singletonList("ALTER DATABASE SET TIME_ZONE = '" + this.srcDBTimeZone + "';");
            fileHelper.writeFixupText(sqlStatements, 1);
            this.addFixup(sqlFixup);
        }
    }
}

