/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.json.CpatJsonPreferNullOverEmpty;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class SourceApplications {
    private static final Language lang = Language.getInstance();
    private static final String SQL_SOURCE_APPLICATIONS = "SELECT 'EBS' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME = 'FND_PRODUCT_GROUPS' AND COLUMN_NAME = 'RELEASE_NAME' AND ROWNUM = 1 UNION ALL SELECT 'SIEBEL' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME = 'S_APP_VER' AND COLUMN_NAME = 'APP_VER' AND ROWNUM = 1 UNION ALL SELECT 'PEOPLESOFT' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME = 'PSSTATUS' AND COLUMN_NAME = 'TOOLSREL' AND ROWNUM = 1 UNION ALL SELECT 'SAP' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME = 'ICFSERVICE' AND COLUMN_NAME = 'ICF_NAME' AND ROWNUM = 1 UNION ALL SELECT 'HCM' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME IN ('PER_ASG_RESPONSIBILITIES','PER_ASG_RESPONSIBILITIES') AND COLUMN_NAME = 'ASG_RESPONSIBILITY_ID' AND ROWNUM = 1 UNION ALL SELECT 'FINANCIALS' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME IN ('AR_ADJUSTMENTS_ALL','AR_ADJUSTMENTS_ALL') AND COLUMN_NAME = 'ADJUSTMENT_ID' AND ROWNUM = 1 UNION ALL SELECT 'SCM' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME IN ('EGP_SYSTEM_ITEMS_B','EGP_SYSTEM_ITEMS_B') AND COLUMN_NAME = 'ORGANIZATION_ID' AND ROWNUM = 1 UNION ALL SELECT 'CX' AS APP_NAME, OWNER AS APP_OWNER FROM DBA_TAB_COLUMNS WHERE TABLE_NAME IN ('OKC_PRICING_TERMS','OKC_PRICING_TERMS') AND COLUMN_NAME = 'PRICING_TERM_ID' AND ROWNUM = 1";
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerEBS;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerSiebel;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerPeopleSoft;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerSAP;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerFusionHCM;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerFusionFinancials;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerFusionSCM;
    @CpatJsonPreferNullOverEmpty
    private String srcOwnerFusionCX;

    private SourceApplications() {
    }

    public static SourceApplications checkIfAppIsRunning(ExecutionContext exeCtx) throws SQLException {
        SourceApplications sourceApplications = new SourceApplications();
        List<Map<String, String>> sourceApp = SqlUtils.getMaps(exeCtx, SQL_SOURCE_APPLICATIONS);
        if (sourceApp.isEmpty()) {
            return sourceApplications;
        }
        for (Map<String, String> result : sourceApp) {
            App appName = App.valueOf(result.get("APP_NAME"));
            String appOwner = result.get("APP_OWNER");
            switch (appName) {
                case EBS: {
                    sourceApplications.setSrcOwnerEBS(appOwner);
                    break;
                }
                case SIEBEL: {
                    sourceApplications.setSrcOwnerSiebel(appOwner);
                    break;
                }
                case PEOPLESOFT: {
                    sourceApplications.setSrcOwnerPeopleSoft(appOwner);
                    break;
                }
                case SAP: {
                    sourceApplications.setSrcOwnerSAP(appOwner);
                    break;
                }
                case HCM: {
                    sourceApplications.setSrcOwnerFusionHCM(appOwner);
                    break;
                }
                case FINANCIALS: {
                    sourceApplications.setSrcOwnerFusionFinancials(appOwner);
                    break;
                }
                case SCM: {
                    sourceApplications.setSrcOwnerFusionSCM(appOwner);
                    break;
                }
                case CX: {
                    sourceApplications.setSrcOwnerFusionCX(appOwner);
                    break;
                }
            }
        }
        return sourceApplications;
    }

    public String toString() {
        EnumMap<App, String> apps = new EnumMap<App, String>(App.class);
        ArrayList<String> list = new ArrayList<String>();
        if (SourceApplications.isNotNull(this.srcOwnerEBS)) {
            apps.put(App.EBS, this.srcOwnerEBS);
        }
        if (SourceApplications.isNotNull(this.srcOwnerSiebel)) {
            apps.put(App.SIEBEL, this.srcOwnerSiebel);
        }
        if (SourceApplications.isNotNull(this.srcOwnerPeopleSoft)) {
            apps.put(App.PEOPLESOFT, this.srcOwnerPeopleSoft);
        }
        if (SourceApplications.isNotNull(this.srcOwnerSAP)) {
            apps.put(App.SAP, this.srcOwnerSAP);
        }
        if (SourceApplications.isNotNull(this.srcOwnerFusionHCM)) {
            apps.put(App.HCM, this.srcOwnerFusionHCM);
        }
        if (SourceApplications.isNotNull(this.srcOwnerFusionFinancials)) {
            apps.put(App.FINANCIALS, this.srcOwnerFusionFinancials);
        }
        if (SourceApplications.isNotNull(this.srcOwnerFusionSCM)) {
            apps.put(App.SCM, this.srcOwnerFusionSCM);
        }
        if (SourceApplications.isNotNull(this.srcOwnerFusionCX)) {
            apps.put(App.CX, this.srcOwnerFusionCX);
        }
        if (!apps.isEmpty()) {
            for (Map.Entry entry : apps.entrySet()) {
                App app = (App)((Object)entry.getKey());
                String owner = (String)entry.getValue();
                list.add((Object)((Object)app) + " (Owner: " + owner + ")");
            }
        } else {
            return lang.txt("SRC_NO_APPLICATION_DETECTED");
        }
        return Utilities.join(", ", list);
    }

    private static boolean isNotNull(String owner) {
        return owner != null && !owner.trim().isEmpty();
    }

    public void setSrcOwnerEBS(String srcOwnerEBS) {
        this.srcOwnerEBS = srcOwnerEBS;
    }

    public void setSrcOwnerSiebel(String srcOwnerSiebel) {
        this.srcOwnerSiebel = srcOwnerSiebel;
    }

    public void setSrcOwnerPeopleSoft(String srcOwnerPeopleSoft) {
        this.srcOwnerPeopleSoft = srcOwnerPeopleSoft;
    }

    public void setSrcOwnerSAP(String srcOwnerSAP) {
        this.srcOwnerSAP = srcOwnerSAP;
    }

    public void setSrcOwnerFusionHCM(String srcOwnerFusionHCM) {
        this.srcOwnerFusionHCM = srcOwnerFusionHCM;
    }

    public void setSrcOwnerFusionFinancials(String srcOwnerFusionFinancials) {
        this.srcOwnerFusionFinancials = srcOwnerFusionFinancials;
    }

    public void setSrcOwnerFusionSCM(String srcOwnerFusionSCM) {
        this.srcOwnerFusionSCM = srcOwnerFusionSCM;
    }

    public void setSrcOwnerFusionCX(String srcOwnerFusionCX) {
        this.srcOwnerFusionCX = srcOwnerFusionCX;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceApplications)) {
            return false;
        }
        SourceApplications other = (SourceApplications)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$srcOwnerEBS = this.getSrcOwnerEBS();
        String other$srcOwnerEBS = other.getSrcOwnerEBS();
        if (this$srcOwnerEBS == null ? other$srcOwnerEBS != null : !this$srcOwnerEBS.equals(other$srcOwnerEBS)) {
            return false;
        }
        String this$srcOwnerSiebel = this.getSrcOwnerSiebel();
        String other$srcOwnerSiebel = other.getSrcOwnerSiebel();
        if (this$srcOwnerSiebel == null ? other$srcOwnerSiebel != null : !this$srcOwnerSiebel.equals(other$srcOwnerSiebel)) {
            return false;
        }
        String this$srcOwnerPeopleSoft = this.getSrcOwnerPeopleSoft();
        String other$srcOwnerPeopleSoft = other.getSrcOwnerPeopleSoft();
        if (this$srcOwnerPeopleSoft == null ? other$srcOwnerPeopleSoft != null : !this$srcOwnerPeopleSoft.equals(other$srcOwnerPeopleSoft)) {
            return false;
        }
        String this$srcOwnerSAP = this.getSrcOwnerSAP();
        String other$srcOwnerSAP = other.getSrcOwnerSAP();
        if (this$srcOwnerSAP == null ? other$srcOwnerSAP != null : !this$srcOwnerSAP.equals(other$srcOwnerSAP)) {
            return false;
        }
        String this$srcOwnerFusionHCM = this.getSrcOwnerFusionHCM();
        String other$srcOwnerFusionHCM = other.getSrcOwnerFusionHCM();
        if (this$srcOwnerFusionHCM == null ? other$srcOwnerFusionHCM != null : !this$srcOwnerFusionHCM.equals(other$srcOwnerFusionHCM)) {
            return false;
        }
        String this$srcOwnerFusionFinancials = this.getSrcOwnerFusionFinancials();
        String other$srcOwnerFusionFinancials = other.getSrcOwnerFusionFinancials();
        if (this$srcOwnerFusionFinancials == null ? other$srcOwnerFusionFinancials != null : !this$srcOwnerFusionFinancials.equals(other$srcOwnerFusionFinancials)) {
            return false;
        }
        String this$srcOwnerFusionSCM = this.getSrcOwnerFusionSCM();
        String other$srcOwnerFusionSCM = other.getSrcOwnerFusionSCM();
        if (this$srcOwnerFusionSCM == null ? other$srcOwnerFusionSCM != null : !this$srcOwnerFusionSCM.equals(other$srcOwnerFusionSCM)) {
            return false;
        }
        String this$srcOwnerFusionCX = this.getSrcOwnerFusionCX();
        String other$srcOwnerFusionCX = other.getSrcOwnerFusionCX();
        return !(this$srcOwnerFusionCX == null ? other$srcOwnerFusionCX != null : !this$srcOwnerFusionCX.equals(other$srcOwnerFusionCX));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceApplications;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $srcOwnerEBS = this.getSrcOwnerEBS();
        result = result * 59 + ($srcOwnerEBS == null ? 43 : $srcOwnerEBS.hashCode());
        String $srcOwnerSiebel = this.getSrcOwnerSiebel();
        result = result * 59 + ($srcOwnerSiebel == null ? 43 : $srcOwnerSiebel.hashCode());
        String $srcOwnerPeopleSoft = this.getSrcOwnerPeopleSoft();
        result = result * 59 + ($srcOwnerPeopleSoft == null ? 43 : $srcOwnerPeopleSoft.hashCode());
        String $srcOwnerSAP = this.getSrcOwnerSAP();
        result = result * 59 + ($srcOwnerSAP == null ? 43 : $srcOwnerSAP.hashCode());
        String $srcOwnerFusionHCM = this.getSrcOwnerFusionHCM();
        result = result * 59 + ($srcOwnerFusionHCM == null ? 43 : $srcOwnerFusionHCM.hashCode());
        String $srcOwnerFusionFinancials = this.getSrcOwnerFusionFinancials();
        result = result * 59 + ($srcOwnerFusionFinancials == null ? 43 : $srcOwnerFusionFinancials.hashCode());
        String $srcOwnerFusionSCM = this.getSrcOwnerFusionSCM();
        result = result * 59 + ($srcOwnerFusionSCM == null ? 43 : $srcOwnerFusionSCM.hashCode());
        String $srcOwnerFusionCX = this.getSrcOwnerFusionCX();
        result = result * 59 + ($srcOwnerFusionCX == null ? 43 : $srcOwnerFusionCX.hashCode());
        return result;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerEBS() {
        return this.srcOwnerEBS;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerSiebel() {
        return this.srcOwnerSiebel;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerPeopleSoft() {
        return this.srcOwnerPeopleSoft;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerSAP() {
        return this.srcOwnerSAP;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerFusionHCM() {
        return this.srcOwnerFusionHCM;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerFusionFinancials() {
        return this.srcOwnerFusionFinancials;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerFusionSCM() {
        return this.srcOwnerFusionSCM;
    }

    @CpatJsonPreferNullOverEmpty
    public String getSrcOwnerFusionCX() {
        return this.srcOwnerFusionCX;
    }

    private static enum App {
        EBS,
        SIEBEL,
        PEOPLESOFT,
        SAP,
        HCM,
        FINANCIALS,
        SCM,
        CX,
        NONE;


        public String toString() {
            return this.name();
        }
    }
}

