/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.CalculatedMember;

public class PermanentCalculatedMember
extends CalculatedMember {
    private String m_storageType = "DYNAMIC";
    private String m_lhs = null;
    private boolean m_isOverride = false;

    protected PermanentCalculatedMember() {
    }

    public PermanentCalculatedMember(BaseObject baseObject) {
        super(baseObject);
    }

    public String WriteToXML() {
        String string = null;
        string = PermanentCalculatedMember.TAB() + this.WriteElementStart("PermanentCalculatedMember");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + PermanentCalculatedMember.TAB() + this.WriteElementEndTag("PermanentCalculatedMember") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string + this.WriteAsAttribute("StorageType", this.m_storageType);
        if (this.m_lhs != null) {
            string = string + this.WriteAsAttribute("MemberReference", this.m_lhs);
        }
        if (this.m_isOverride) {
            string = string + this.WriteAsAttribute("IsOverride", Boolean.toString(this.m_isOverride));
        }
        return string;
    }

    public String WriteContentsToXML() {
        ++s_Indent;
        String string = super.WriteContentsToXML();
        --s_Indent;
        return string;
    }

    public String getStorageType() {
        return this.m_storageType;
    }

    public void setStorageType(String string) {
        if (string.equalsIgnoreCase("DYNAMIC") || string.equalsIgnoreCase("PRECOMPUTE")) {
            this.m_storageType = string.toUpperCase();
        }
    }

    public String Create(AWConnection aWConnection) {
        String string = "success";
        String string2 = AWNULL;
        if (this.m_lhs != null && this.m_lhs.length() > 0) {
            string2 = this.quoteValue(this.m_lhs);
        }
        String string3 = this.m_expressionText;
        string = aWConnection.executeCommand("call create_calculatedmember(" + this.quoteValue(this.getId()) + "," + this.quoteValue(string3) + "," + this.quoteValue(this.m_storageType) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + AWConnection.CommitMode + "," + string2 + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-200004", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Alter(AWConnection aWConnection) {
        String string = "success";
        String string2 = AWNULL;
        if (this.m_lhs != null) {
            string2 = this.quoteValue(this.m_lhs);
        }
        String string3 = this.m_expressionText;
        string = aWConnection.executeCommand("call alter_calculatedmember(" + this.quoteValue(this.getId()) + "," + this.quoteValue(string3) + "," + this.quoteValue(this.m_storageType) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + AWConnection.CommitMode + "," + string2 + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-200004", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "Success";
        try {
            super.Delete(aWConnection);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string;
    }

    public void setMemberReference(String string) {
        this.m_lhs = string;
    }

    public String getMemberReference() {
        return this.m_lhs;
    }

    public void setIsOverride(boolean bl) {
        this.m_isOverride = bl;
    }

    public void setIsOverride(Boolean bl) {
        this.m_isOverride = bl;
    }

    public boolean isOverride() {
        return this.m_isOverride;
    }
}

