/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.FetchCommand;
import org.netbeans.libs.git.jgit.commands.MergeCommand;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class PullCommand
extends TransportCommand {
    private final ProgressMonitor monitor;
    private final List<String> refSpecs;
    private final String remote;
    private Map<String, GitTransportUpdate> updates;
    private FetchResult result;
    private final String branchToMerge;
    private GitMergeResult mergeResult;

    public PullCommand(Repository repository, GitClassFactory gitFactory, String remote, List<String> fetchRefSpecifications, String branchToMerge, ProgressMonitor monitor) {
        super(repository, gitFactory, remote, monitor);
        this.monitor = monitor;
        this.remote = remote;
        this.refSpecs = fetchRefSpecifications;
        this.branchToMerge = branchToMerge;
    }

    @Override
    protected void runTransportCommand() throws GitException.AuthorizationException, GitException {
        FetchCommand fetch = new FetchCommand(this.getRepository(), this.getClassFactory(), this.remote, this.refSpecs, this.monitor);
        fetch.setCredentialsProvider(this.getCredentialsProvider());
        fetch.run();
        this.updates = fetch.getUpdates();
        MergeCommand merge = new MergeCommand(this.getRepository(), this.getClassFactory(), this.branchToMerge, null, this.monitor);
        merge.setCommitMessage("branch '" + this.findRemoteBranchName() + "' of " + fetch.getResult().getURI().setUser(null).setPass(null).toString());
        merge.run();
        this.mergeResult = merge.getResult();
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git pull ").append(this.remote);
        for (String refSpec : this.refSpecs) {
            sb.append(' ').append(refSpec);
        }
        return sb.toString();
    }

    public GitPullResult getResult() {
        return this.getClassFactory().createPullResult(this.updates, this.mergeResult);
    }

    private String findRemoteBranchName() throws GitException {
        Ref ref = null;
        try {
            ref = this.getRepository().exactRef(this.branchToMerge);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        if (ref != null) {
            for (String s : this.refSpecs) {
                String refName;
                RefSpec spec = new RefSpec(s);
                if (!spec.matchDestination(ref) || !(refName = (spec = spec.expandFromDestination(ref)).getSource()).startsWith("refs/heads/")) continue;
                return refName.substring("refs/heads/".length());
            }
        }
        return this.branchToMerge;
    }
}

