/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class MergeCommand
extends GitCommand {
    private final String revision;
    private GitMergeResult result;
    private String commitMessage;
    private final GitRepository.FastForwardOption ffOption;

    public MergeCommand(Repository repository, GitClassFactory gitFactory, String revision, GitRepository.FastForwardOption ffOption, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.ffOption = ffOption;
        this.revision = revision;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.MergeCommand command = new Git(repository).merge();
        this.setFastForward(command);
        Ref ref = null;
        try {
            ref = repository.exactRef(this.revision);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        if (ref == null) {
            command.include((AnyObjectId)Utils.findCommit(repository, this.revision));
        } else {
            String msg = this.commitMessage;
            if (msg == null) {
                msg = Utils.getRefName(ref);
            }
            command.include(msg, (AnyObjectId)ref.getTarget().getObjectId());
        }
        try {
            this.result = this.getClassFactory().createMergeResult(command.call(), repository.getWorkTree());
        }
        catch (NoMessageException | WrongRepositoryStateException ex) {
            throw new GitException(Utils.getBundle(MergeCommand.class).getString("MSG_MergeCommand.commitErr.wrongRepoState"), ex);
        }
        catch (org.eclipse.jgit.api.errors.CheckoutConflictException ex) {
            this.parseConflicts(ex);
        }
        catch (JGitInternalException ex) {
            if (ex.getCause() instanceof CheckoutConflictException) {
                this.parseConflicts(ex.getCause());
            }
            throw new GitException(ex);
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git merge ");
        if (this.ffOption != null) {
            sb.append((Object)this.ffOption).append(" ");
        }
        return sb.append(this.revision).toString();
    }

    public GitMergeResult getResult() {
        return this.result;
    }

    void setCommitMessage(String message) {
        if (message != null) {
            message = message.replace("\n", "").replace("\r", "");
        }
        this.commitMessage = message;
    }

    private void parseConflicts(Throwable original) throws GitException.CheckoutConflictException, GitException {
        String[] lines = original.getMessage().split("\n");
        if (lines.length > 1) {
            throw new GitException.CheckoutConflictException(Arrays.copyOfRange(lines, 1, lines.length), original);
        }
        throw new GitException(original);
    }

    private void setFastForward(org.eclipse.jgit.api.MergeCommand cmd) {
        if (this.ffOption == null) {
            return;
        }
        switch (this.ffOption) {
            case FAST_FORWARD: {
                cmd.setFastForward(MergeCommand.FastForwardMode.FF);
                break;
            }
            case FAST_FORWARD_ONLY: {
                cmd.setFastForward(MergeCommand.FastForwardMode.FF_ONLY);
                break;
            }
            case NO_FAST_FORWARD: {
                cmd.setFastForward(MergeCommand.FastForwardMode.NO_FF);
            }
        }
    }
}

