/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.sshd.DefaultProxyDataFactory;
import org.eclipse.jgit.transport.sshd.JGitKeyCache;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.JGitRepository;

public final class GitRepository {
    private static final Map<File, GitRepository> repositoryPool = new WeakHashMap<File, GitRepository>(5);
    private final File repositoryLocation;
    private JGitRepository gitRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized GitRepository getInstance(File repositoryLocation) {
        Map<File, GitRepository> map = repositoryPool;
        synchronized (map) {
            GitRepository repository = repositoryPool.get(repositoryLocation);
            if (repository == null) {
                repository = new GitRepository(new File(repositoryLocation.getAbsolutePath()));
                repositoryPool.put(repositoryLocation, repository);
            }
            return repository;
        }
    }

    private GitRepository(File repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public synchronized GitClient createClient() throws GitException {
        this.getRepository();
        return this.createClient(this.gitRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastForwardOption getDefaultFastForwardOption() throws GitException {
        JGitRepository repository = this.getRepository();
        repository.increaseClientUsage();
        try {
            MergeConfig cfg = MergeConfig.getConfigForCurrentBranch((Repository)repository.getRepository());
            MergeCommand.FastForwardMode mode = cfg.getFastForwardMode();
            switch (mode) {
                case FF_ONLY: {
                    FastForwardOption fastForwardOption = FastForwardOption.FAST_FORWARD_ONLY;
                    return fastForwardOption;
                }
                case NO_FF: {
                    FastForwardOption fastForwardOption = FastForwardOption.NO_FAST_FORWARD;
                    return fastForwardOption;
                }
            }
            FastForwardOption fastForwardOption = FastForwardOption.FAST_FORWARD;
            return fastForwardOption;
        }
        finally {
            repository.decreaseClientUsage();
        }
    }

    private synchronized JGitRepository getRepository() {
        if (this.gitRepository == null) {
            this.gitRepository = new JGitRepository(this.repositoryLocation);
            try {
                SshdSessionFactory sf = null;
                String currentSystemClasspath = System.getProperty("java.class.path");
                System.out.println(currentSystemClasspath);
                sf = new SshdSessionFactory((KeyCache)new JGitKeyCache(), (ProxyDataFactory)new DefaultProxyDataFactory());
                SshSessionFactory.setInstance((SshSessionFactory)sf);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.gitRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearRepositoryPool() {
        Map<File, GitRepository> map = repositoryPool;
        synchronized (map) {
            repositoryPool.clear();
        }
    }

    private GitClient createClient(JGitRepository repository) throws GitException {
        return new GitClient(repository);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FastForwardOption {
        FAST_FORWARD{

            public String toString() {
                return "--ff";
            }
        }
        ,
        FAST_FORWARD_ONLY{

            public String toString() {
                return "--ff-only";
            }
        }
        ,
        NO_FAST_FORWARD{

            public String toString() {
                return "--no-ff";
            }
        };

    }
}

