/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITCommonPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;

public class GITRepositoryPanel
extends GITCommonPanel {
    private static final String F1_HELP_ID = "f1_git_fetch_wizard_2_html";
    private final JMultiLineLabel _hintText = new JMultiLineLabel();
    private final JLabel _lblRemote = new JLabel();
    private JComboBox _cRemote = new JComboBox();
    private final JLabel _lblRepository = new JLabel();
    private final JComboBox _cmnRepository = new JComboBox();
    private final HyperlinkButton _btnProxy = new HyperlinkButton();
    private URL _localRootUrl;
    private Map<String, Collection<String>> _mapBranches = new HashMap<String, Collection<String>>();
    private Map<String, String> _mapNameRemoteUri = new HashMap<String, String>();

    public GITRepositoryPanel() {
        this.jbInit();
        this.initResources();
        this.addListeners();
        this.setHelpID(F1_HELP_ID);
    }

    protected JComponent getRemoteComponent() {
        return this._cRemote;
    }

    protected void setRemoteEditable(boolean edit) {
        this._cRemote.setEditable(edit);
    }

    protected String getRemoteText() {
        return (String)this._cRemote.getSelectedItem();
    }

    protected void populateRemote(String remoteURI) {
        String name = this.getRemoteName(remoteURI);
        if (name != null && !name.isEmpty()) {
            ((JComboBox)this.getRemoteComponent()).setSelectedItem(name);
        }
    }

    protected String populateRepository(String remoteName) {
        String uri = this._mapNameRemoteUri.get(remoteName);
        if (uri != null) {
            this._cmnRepository.setSelectedItem(uri);
            return uri;
        }
        return null;
    }

    private String getRemoteName(String remoteUri) {
        for (String name : this._mapNameRemoteUri.keySet()) {
            if (!this._mapNameRemoteUri.get(name).equals(remoteUri)) continue;
            return name;
        }
        return null;
    }

    private void jbInit() {
        Insets ins = new Insets(5, 5, 5, 5);
        Insets ins0 = new Insets(0, 0, 0, 0);
        Insets insL = new Insets(5, 20, 5, 5);
        this.setLayout(new GridBagLayout());
        this._btnProxy.setEnabled(false);
        this._hintText.setText(Resource.get("WZ_REMOTE_HINT"));
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._lblRemote, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this.getRemoteComponent(), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, insL, 0, 0));
        this.add(this._lblRepository, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._cmnRepository, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, insL, 0, 0));
        this.add((Component)this._btnProxy, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._authPanel, new GridBagConstraints(0, 4, 3, 4, 1.0, 0.0, 17, 2, ins0, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.setRemoteEditable(true);
        this._cmnRepository.setEditable(true);
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            this._localRootUrl = (URL)dataContext.get("git.local-url");
            Map defaultConfig = (Map)dataContext.get("git.remote-default-config");
            this.populateRepositoryCombo(GITUtil.getReposRoots());
            this.populateRepositoryCombo();
            this.setDefaultAuthentication(dataContext);
        }
    }

    private void setDefaultAuthentication(TraversableContext dataContext) {
        Map defaultConfig = (Map)dataContext.get("git.remote-default-config");
        String defRepo = (String)dataContext.get("git.default-remote");
        if (defRepo == null || defRepo.isEmpty()) {
            defRepo = this.getDefaultGITRepo(defaultConfig);
        }
        this._cmnRepository.setSelectedItem(defRepo);
        this.setDefaultAuthentication(defRepo);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            GitClient client = null;
            try {
                client = this.getClient();
                this.RepositoryOnExit(dataContext, client, this.getRemoteText(), (String)this._cmnRepository.getSelectedItem(), this._authPanel.getUser(), this._authPanel.getPassword(), this._authPanel.getKeyFile(), this._authPanel.getPassPhrase());
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITRepositoryPanel.class.getName()).warning("Repository " + e.getMessage());
                throw new TraversalException(e.getMessage());
            }
            finally {
                if (client == null) {
                    client.release();
                }
            }
        }
    }

    protected void populateReposAndAuthentication(String remoteUrl, String username, char[] passwd) {
        this.addNonDuplicateItem(this._cmnRepository, remoteUrl);
        this.setAuthentication(remoteUrl, username, passwd);
    }

    protected void readOnlyReposAndAuthentication() {
        this._cmnRepository.setEditable(false);
        this.readOnlyAuthentication();
    }

    private void initResources() {
        ResourceUtils.resLabel((JLabel)this._lblRemote, (Component)this.getRemoteComponent(), (String)Resource.get("WZ_REMOTE"));
        ResourceUtils.resLabel((JLabel)this._lblRepository, (Component)this._cmnRepository, (String)Resource.get("WZ_REPOSITORY_URL"));
        ResourceUtils.resButton((AbstractButton)this._btnProxy, (String)Resource.get("WZ_PROXY_BUTTON"));
    }

    protected GitClient getClient() throws GitException {
        return GITClientAdaptor.getClient(this._localRootUrl);
    }

    protected String getRemoteDefault() {
        return null;
    }

    private void populateRepositoryCombo() {
        Collection<Pair<String, String>> infoLst = GITConnectionManager.getInstance().getConnectionInfoList();
        for (Pair<String, String> info : infoLst) {
            String name = this.getRemoteName((String)info.getFirst());
            if (name == null || info.getSecond() == null) continue;
            this._mapNameRemoteUri.put((String)info.getSecond(), (String)info.getFirst());
            this.addNonDuplicateItem(this._cmnRepository, (String)info.getFirst());
            if (!(this.getRemoteComponent() instanceof JComboBox)) continue;
            this.addNonDuplicateItem((JComboBox)this.getRemoteComponent(), (String)info.getSecond());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRepositoryCombo(URL[] roots) {
        for (URL root : roots) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient(root);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remote");
                Map<String, GitRemoteConfig> config = client.getRemotes(monitor);
                for (String key : config.keySet()) {
                    GitRemoteConfig rmCon = config.get(key);
                    List<String> uris = rmCon.getUris();
                    for (String uri : uris) {
                        if (this._mapNameRemoteUri.containsKey(key)) {
                            String unique = key + " - " + uri;
                            this._mapNameRemoteUri.put(unique, uri);
                            if (this.getRemoteComponent() instanceof JComboBox) {
                                this.addNonDuplicateItem((JComboBox)this.getRemoteComponent(), unique);
                            }
                        } else {
                            this._mapNameRemoteUri.put(key, uri);
                            if (this.getRemoteComponent() instanceof JComboBox) {
                                this.addNonDuplicateItem((JComboBox)this.getRemoteComponent(), key);
                            }
                        }
                        this.addNonDuplicateItem(this._cmnRepository, uri);
                    }
                }
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITRepositoryPanel.class.getName()).log(Level.WARNING, e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    private void addListeners() {
        this._cmnRepository.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GITRepositoryPanel.this.populateRemote((String)e.getItem());
                    GITRepositoryPanel.this._authPanel.populateAuthentication((String)e.getItem());
                }
            }
        });
        this._cRemote.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String uri;
                if (e.getStateChange() == 1 && (uri = GITRepositoryPanel.this.populateRepository((String)e.getItem())) != null) {
                    GITRepositoryPanel.this._authPanel.populateAuthentication(uri);
                }
            }
        });
        this._cmnRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                GITRepositoryPanel.this.enableProxy((String)src.getSelectedItem());
            }
        });
        this._cmnRepository.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String txt = (String)GITRepositoryPanel.this._cmnRepository.getEditor().getItem();
                GITRepositoryPanel.this.enableProxy(txt);
            }
        });
        this._btnProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITRepositoryPanel.this.proxyPrompt();
            }
        });
    }

    private void enableProxy(String txt) {
        if (txt != null && txt.startsWith("http")) {
            this._btnProxy.setEnabled(true);
        } else {
            this._btnProxy.setEnabled(false);
        }
    }
}

