/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITRepositoryPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;

public class GITCloneRepositoryPanel
extends GITRepositoryPanel {
    private static final String F1_HELP_ID = "f1_git_clone_wizard_2_html";
    private JTextField _fldRemote;
    private File _tmpDir;

    public GITCloneRepositoryPanel() {
        ((JTextField)this.getRemoteComponent()).setText(this.getRemoteDefault());
        this.setHelpID(F1_HELP_ID);
    }

    @Override
    public void onEntry(TraversableContext dataContext) {
        if (dataContext.contains("git.remote-uri")) {
            String remoteUrl = (String)dataContext.get("git.remote-uri");
            String username = (String)dataContext.get("git.username");
            char[] passwd = (char[])dataContext.get("git.password");
            this.populateReposAndAuthentication(remoteUrl, username, passwd);
            this.readOnlyReposAndAuthentication();
        } else {
            super.onEntry(dataContext);
        }
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        callbacks.wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        dataContext.setWizardCallbacks(callbacks);
    }

    @Override
    protected JComponent getRemoteComponent() {
        if (this._fldRemote == null) {
            this._fldRemote = new JTextField();
        }
        return this._fldRemote;
    }

    @Override
    protected void setRemoteEditable(boolean edit) {
        ((JTextField)this.getRemoteComponent()).setEditable(edit);
    }

    @Override
    protected String getRemoteText() {
        return ((JTextField)this.getRemoteComponent()).getText();
    }

    @Override
    protected void populateRemote(String remoteRepos) {
    }

    @Override
    protected String getRemoteDefault() {
        Collection<Pair<String, String>> connects = GITConnectionManager.getInstance().getConnectionInfoList();
        if (connects.isEmpty()) {
            return Resource.get("WZ_CLONE_REMOTE_DEFAULT");
        }
        ArrayList<String> remotes = new ArrayList<String>();
        for (Pair<String, String> info : connects) {
            remotes.add((String)info.getSecond());
        }
        int c = 1;
        Object remote = Resource.get("WZ_CLONE_REMOTE_DEFAULT");
        while (remotes.contains(remote)) {
            remote = Resource.get("WZ_CLONE_REMOTE_DEFAULT") + c++;
        }
        return remote;
    }

    @Override
    protected GitClient getClient() throws GitException {
        URL[] urls = GITUtil.getReposRoots();
        if (urls.length > 0) {
            GitRepository repos = GitRepository.getInstance(new File(urls[0].getPath()));
            return repos.createClient();
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        this._tmpDir = this.getTempDir(tmpdir);
        if (this._tmpDir != null) {
            GitRepository repos = GitRepository.getInstance(new File(this._tmpDir.getPath()));
            GitClient client = repos.createClient();
            client.init(new GITCommandProgressMonitor("init"));
            return client;
        }
        return null;
    }

    @Override
    public final void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            try {
                super.onExit(dataContext);
            }
            finally {
                if (this._tmpDir != null) {
                    this.removeDir(this._tmpDir);
                }
            }
        }
    }

    private void removeDir(File dir) {
        File[] children;
        for (File child : children = dir.listFiles()) {
            if (child.isDirectory()) {
                this.removeDir(child);
                continue;
            }
            child.delete();
        }
        dir.delete();
    }

    private File getTempDir(String tmpdir) {
        for (int c = 0; c < 100; ++c) {
            StringBuilder sb = new StringBuilder(tmpdir);
            sb.append(File.separatorChar);
            sb.append("jdev-git-");
            sb.append(c);
            File file = new File(sb.toString());
            if (file.exists()) continue;
            file.mkdir();
            return file;
        }
        return null;
    }
}

