/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Map;
import java.util.Observable;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchPanel;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;

public class GITBranchSelector
extends Observable {
    private static final String F1_HELP_ID = "f1_git_select_branch_html";
    private JEWTDialog _dialog;
    private URL _root;

    GITBranchSelector(URL root) {
        this._root = root;
    }

    void showLister() {
        Map<String, GitBranch> branches = this.getBranches();
        if (branches != null && !branches.isEmpty()) {
            final GITBranchPanel panel = new GITBranchPanel(branches);
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, F1_HELP_ID);
            this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("CHECKOUT_BRANCH_TITLE"), (int)7);
            this._dialog.setOKButtonEnabled(false);
            this._dialog.setName("Branch Selector");
            this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        if (this.getSelectedBranch() != null) {
                            GITBranchSelector.this.setChanged();
                        }
                        GITBranchSelector.this.notifyObservers(this.getSelectedBranch());
                    }
                }

                private String getSelectedBranch() {
                    return panel.getSelectedBranch();
                }
            });
            panel.addSelectionChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GITBranchSelector.this._dialog.setOKButtonEnabled(((Boolean)evt.getNewValue()).booleanValue());
                }
            });
            try {
                this._dialog.runDialog();
            }
            finally {
                this._dialog.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, GitBranch> getBranches() {
        GitClient client = null;
        Map<String, GitBranch> branches = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Branch");
            client = GITClientAdaptor.getClient(this._root);
            branches = client.getBranches(true, monitor);
            if (monitor.getError() != null) {
                MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)monitor.getError(), (String)Resource.get("BRANCH_ERROR_TITLE"), null);
            }
        }
        catch (Exception f) {
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)f, (String)Resource.get("PROCESS_EXCEPTION_BRANCH"));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return branches;
    }
}

