/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.git.GITConnection;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITAuthenicationPanel
extends JPanel {
    private static String _remPath = null;
    private final String USER_PASSWORD = "User-Password";
    private final String USER_PHRASE = "USER_PHRASE";
    private final JLabel _lblUser = new JLabel();
    private final JTextField _fldUser = new JTextField();
    private final JRadioButton _rdPass = new JRadioButton();
    private final JPasswordField _fldPass = new JPasswordField();
    private final JRadioButton _rdKey = new JRadioButton();
    private final FileField _fileKey = new FileField();
    private final JLabel _lblPhrase = new JLabel();
    private final JPasswordField _fldPhrase = new JPasswordField();
    private final JButton _browse = new JButton();

    public GITAuthenicationPanel() {
        this.jbInit();
        this.initResources();
        this.addListeners();
    }

    private void jbInit() {
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lblUser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this._fldUser, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._rdPass, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this._fldPass, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._rdKey, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this._fileKey, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._browse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        Insets insL = new Insets(5, 25, 5, 5);
        this.add((Component)this._lblPhrase, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insL, 0, 0));
        this.add((Component)this._fldPhrase, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._rdPass);
        bg.add(this._rdKey);
        this._rdPass.setActionCommand("User-Password");
        this._rdPass.setSelected(true);
        this._rdKey.setActionCommand("USER_PHRASE");
    }

    private void initResources() {
        ResourceUtils.resLabel((JLabel)this._lblUser, (Component)this._fldUser, (String)Resource.get("WZ_USERNAME"));
        ResourceUtils.resButton((AbstractButton)this._rdPass, (String)Resource.get("WZ_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this._rdKey, (String)Resource.get("WZ_SSH_KEY_DIR"));
        ResourceUtils.resLabel((JLabel)this._lblPhrase, (Component)this._fldPhrase, (String)Resource.get("WZ_SSH_PHRASE"));
        ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("WZ_SSH_KEY_BROWSE"));
        this._fileKey.setText(this.getDefaultPath());
    }

    private void addListeners() {
        AuthenticationListener listener = new AuthenticationListener();
        this._rdKey.addActionListener(listener);
        this._rdPass.addActionListener(listener);
        this._browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLChooser urlChooser = DialogUtil.newURLChooser();
                urlChooser.setSelectionScope(0);
                urlChooser.setSelectedURL(GITAuthenicationPanel.this.getOpenURL());
                int ret = urlChooser.showOpenDialog((Component)GITAuthenicationPanel.this, Resource.get("INIT_PRIVATE_KEY_TITLE"));
                if (ret == 0) {
                    URL url = urlChooser.getSelectedURL();
                    GITAuthenicationPanel.this._fileKey.setText(url.getPath());
                }
            }
        });
    }

    public void populateAuthentication(final String connection) {
        final Details det = new Details();
        RunnableProgress run = new RunnableProgress(){

            @Override
            protected void runImpl() {
                String user = GITAuthenicationPanel.this.getUsername(connection);
                GITConnection connect = GITConnectionManager.getInstance().getConnection(connection);
                if (connect != null) {
                    det._user = user == null ? connect.getUsername() : user;
                    det._passwd = connect.getPassword();
                    det._passphrase = connect.getPassphrase();
                } else {
                    det._user = user;
                }
                this.getProgressBar().setDoneStatus();
            }
        };
        ProgressBar pb = new ProgressBar((Component)Ide.getMainWindow(), Resource.get("AUTH_TITLE"), (Runnable)run, true);
        run.setProgressBar(pb);
        pb.start(Resource.get("AUTH_DETAIL_INFO"), "", 2000);
        this._fldUser.setText(det._user == null ? "" : det._user);
        this._fldPass.setText(det._passwd == null ? null : new String(det._passwd));
        this._fldPhrase.setText(det._passphrase == null ? null : new String(det._passphrase));
    }

    public void populateAuthentication(String username, char[] passwd) {
        this._fldUser.setText(username != null ? username : "");
        this._fldPass.setText(passwd != null ? new String(passwd) : null);
    }

    private String getUsername(String connection) {
        if (!connection.startsWith("ssh://")) {
            int sl;
            int at;
            URL url = URLFactory.newURL((String)connection);
            if (url != null) {
                try {
                    if (url.getUserInfo() != null) {
                        String username = URLDecoder.decode(url.getUserInfo(), "UTF-8");
                        return username;
                    }
                }
                catch (UnsupportedEncodingException username) {
                    // empty catch block
                }
            }
            if ((at = connection.indexOf(64)) > 0 && (sl = connection.indexOf("//")) > 0 && sl < at) {
                String user = connection.substring(sl + 2, at);
                return user;
            }
        }
        return null;
    }

    public void setAuthenticateFields(boolean enable) {
        this._lblPhrase.setEnabled(!enable);
        this._fldPhrase.setEnabled(!enable);
        this._browse.setEnabled(!enable);
        this._fileKey.setEnabled(!enable);
        this._fldPass.setEnabled(enable);
        this._rdPass.setSelected(enable);
        this._rdKey.setSelected(!enable);
    }

    private URL getOpenURL() {
        URL url;
        String dir = this._fileKey.getText();
        if (dir != null && !dir.isEmpty() && URLFileSystem.exists((URL)(url = URLFactory.newFileURL((String)dir)))) {
            return url;
        }
        return null;
    }

    private String getDefaultPath() {
        if (_remPath != null) {
            return _remPath;
        }
        StringBuilder dir = new StringBuilder(System.getProperty("user.home"));
        dir.append(File.separator);
        dir.append(".ssh");
        dir.append(File.separator);
        URL url = URLFactory.newDirURL((String)dir.toString());
        if (URLFileSystem.exists((URL)url)) {
            return url.getPath();
        }
        return System.getProperty("user.home");
    }

    public String getUser() {
        return this._fldUser.getText();
    }

    public char[] getPassword() {
        if (this._rdPass.isSelected()) {
            return this._fldPass.getPassword();
        }
        return null;
    }

    public String getKeyFile() {
        if (this._rdKey.isSelected()) {
            _remPath = this._fileKey.getText().trim();
            return this._fileKey.getText().trim();
        }
        return null;
    }

    public char[] getPassPhrase() {
        if (this._rdKey.isSelected()) {
            return this._fldPhrase.getPassword();
        }
        return null;
    }

    public void readOnlyAuthentication() {
        this._fldUser.setEditable(false);
        this._fldPass.setEditable(false);
    }

    private class AuthenticationListener
    implements ActionListener {
        private AuthenticationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("User-Password")) {
                GITAuthenicationPanel.this.setAuthenticateFields(true);
            } else {
                GITAuthenicationPanel.this.setAuthenticateFields(false);
            }
        }
    }

    private final class Details {
        char[] _passwd;
        String _user;
        char[] _passphrase;

        private Details() {
        }
    }

    public abstract class RunnableProgress
    implements Runnable {
        private ProgressBar _progress;
        private Exception _exception;

        public final void setProgressBar(ProgressBar bar) {
            this._progress = bar;
        }

        public final ProgressBar getProgressBar() {
            return this._progress;
        }

        public final Exception getException() {
            return this._exception;
        }

        @Override
        public final void run() {
            try {
                this.runImpl();
            }
            catch (Exception scme) {
                this._exception = scme;
            }
            finally {
                if (!this.isCancelled()) {
                    this._progress.setDoneStatus();
                }
            }
        }

        protected abstract void runImpl();

        public boolean isCancelled() {
            return this._progress.hasUserCancelled();
        }
    }
}

