/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.git.prefs.GITVersionToolsPrefs;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITVersionToolsTraversable
extends VCSPreferencesTraversable<GITVersionToolsPrefs> {
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
    private UI _ui;

    public GITVersionToolsTraversable() {
        if (this._profile == null) {
            throw new IllegalStateException();
        }
        this.setHelpID("f1_gitpreferencesversiontools_html");
    }

    protected GITVersionToolsPrefs getPreferences(PropertyStorage prefs) {
        return GITVersionToolsPrefs.getInstance(prefs);
    }

    protected Component getPage() {
        if (this._ui == null) {
            this._ui = new UI();
        }
        return this._ui;
    }

    protected void validatePreferences() {
    }

    protected void loadPreferences(GITVersionToolsPrefs prefs) {
        ((UI)this.getPage()).setPendingChangesDialogUsage(prefs.getPendingChangesDialogUsage());
    }

    protected void savePreferences(GITVersionToolsPrefs prefs) {
        prefs.setPendingChangesDialogUsage(((UI)this.getPage()).getPendingChangesDialogUsage());
    }

    private final class UI
    extends JPanel {
        private JLabel _pendingLabel;
        private JLabel _useDialogLabel;
        private ButtonGroup _dialogUsageGroup;
        private JRadioButton _alwaysRadio;
        private JRadioButton _sometimesRadio;
        private JRadioButton _neverRadio;

        private UI() {
            super(new GridBagLayout());
            this.createComponents();
            this.layoutComponents();
        }

        public int getPendingChangesDialogUsage() {
            if (this._alwaysRadio.isSelected()) {
                return 0;
            }
            if (this._sometimesRadio.isSelected()) {
                return 1;
            }
            if (this._neverRadio.isSelected()) {
                return 2;
            }
            throw new IllegalStateException();
        }

        public void setPendingChangesDialogUsage(int usage) {
            switch (usage) {
                case 0: {
                    this._alwaysRadio.setSelected(true);
                    break;
                }
                case 1: {
                    this._sometimesRadio.setSelected(true);
                    break;
                }
                case 2: {
                    this._neverRadio.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        private void createComponents() {
            this._pendingLabel = new JLabel();
            this._pendingLabel.setText(Resource.get("UI_VTOOLS_PENDING"));
            this._useDialogLabel = new JLabel();
            this._alwaysRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._alwaysRadio, (String)Resource.get("UI_VTOOLS_ALWAYS"));
            this._sometimesRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._sometimesRadio, (String)Resource.get("UI_VTOOLS_SOMETIMES"));
            this._neverRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._neverRadio, (String)Resource.get("UI_VTOOLS_NEVER"));
            this._dialogUsageGroup = new ButtonGroup();
            this._dialogUsageGroup.add(this._alwaysRadio);
            this._dialogUsageGroup.add(this._sometimesRadio);
            this._dialogUsageGroup.add(this._neverRadio);
            ResourceUtils.resLabel((JLabel)this._useDialogLabel, (Component)this._alwaysRadio, (String)Resource.get("UI_VTOOLS_USE_DIALOG"));
        }

        private void layoutComponents() {
            this.add((Component)this._pendingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._useDialogLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            this.add((Component)this._alwaysRadio, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 50, 0, 0), 0, 0));
            this.add((Component)this._sometimesRadio, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 50, 0, 0), 0, 0));
            this.add((Component)this._neverRadio, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 50, 0, 0), 0, 0));
        }
    }
}

