/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCreateBranch;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.cmd.GITCommonRemoteCommand;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchPanel;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITAssignRemoteBranchCommand
extends GITCommonRemoteCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.assign-remote-branch";
    private JEWTDialog _dialog = null;

    public GITAssignRemoteBranchCommand() {
        super(COMMAND_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl(VCSProfile profile) throws Exception {
        block13: {
            Node node = this.getContext().getNode();
            String branch = null;
            if (node != null) {
                if (node instanceof GITBranchNode) {
                    branch = ((GITBranchNode)node).getBranch().getName();
                }
                final URL trueURL = GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL());
                Map<String, GitBranch> branches = GITUtil.getBranches(trueURL, true);
                GITTrackingPanel panel = new GITTrackingPanel(branches, trueURL);
                this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
                this._dialog.setPreferredSize(350, 350);
                try {
                    if (!this._dialog.runDialog()) break block13;
                    GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("ACTION_BRANCH_TRACKING"));
                    GitClient client = null;
                    String rBranch = null;
                    try {
                        client = GITClientAdaptor.getClient(trueURL);
                        rBranch = panel.getSelectedBranch();
                        GitBranch nBranch = client.setUpstreamBranch(branch, rBranch, monitor);
                        if (monitor.getError() != null) {
                            throw new GITProcessException(Resource.format("ACTION_REMOTE_ERROR", branch), monitor.getError());
                        }
                    }
                    catch (GitException e) {
                        GITProfile.getQualifiedLogger(GITOperationCreateBranch.class.getName()).warning(e.getMessage());
                        throw new GITProcessException(Resource.format("ACTION_REMOTE_ERROR", branch), e.getCause().getMessage());
                    }
                    finally {
                        monitor.logCompleted();
                        if (client != null) {
                            client.release();
                        }
                    }
                    if (rBranch != null) {
                        final String remBranch = rBranch;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GITRepositoryNavigator.getInstance().updateNavigator(trueURL, false, GITAssignRemoteBranchCommand.this.getContext().getNode(), remBranch);
                            }
                        });
                    }
                    int n = 0;
                    return n;
                }
                finally {
                    this._dialog.dispose();
                }
            }
        }
        return 1;
    }

    private class GITTrackingPanel
    extends JPanel {
        private GITBranchPanel _panelBranch;
        private JLabel _lblCommit = new JLabel();
        private JTextField _fldCommit = new JTextField();
        private JLabel _lblAuthor = new JLabel();
        private JTextField _fldAuthor = new JTextField();
        private JLabel _lblMessage = new JLabel();
        private JTextArea _fldMessage = new JTextArea();
        private URL _url;
        private Map<String, GitBranch> _branches;

        GITTrackingPanel(Map<String, GitBranch> branches, URL url) {
            this._branches = branches;
            this._url = url;
            this._panelBranch = new GITBranchPanel(branches, true, true);
            this._fldCommit.setEditable(false);
            this._fldAuthor.setEditable(false);
            this._fldMessage.setEditable(false);
            this._fldMessage.setLineWrap(true);
            this._fldMessage.setRows(3);
            ResourceUtils.resLabel((JLabel)this._lblCommit, (Component)this._fldCommit, (String)Resource.get("ASSIGN_BRANCH_COMMIT"));
            ResourceUtils.resLabel((JLabel)this._lblAuthor, (Component)this._fldAuthor, (String)Resource.get("ASSIGN_BRANCH_AUTHOR"));
            ResourceUtils.resLabel((JLabel)this._lblMessage, (Component)this._fldMessage, (String)Resource.get("ASSIGN_BRANCH_MESSAGE"));
            this.initLayout();
        }

        public String getSelectedBranch() {
            return this._panelBranch.getSelectedBranch();
        }

        private void initLayout() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._panelBranch, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._lblCommit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this._fldCommit, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._lblAuthor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this._fldAuthor, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._lblMessage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)new JScrollPane(this._fldMessage), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.5, 17, 1, ins, 0, 0));
            this._panelBranch.addSelectionChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() instanceof String) {
                        String name = (String)evt.getSource();
                        if (!GITTrackingPanel.this._branches.containsKey(name)) {
                            GITTrackingPanel.this._fldCommit.setText("");
                            GITTrackingPanel.this._fldAuthor.setText("");
                            GITTrackingPanel.this._fldMessage.setText("");
                            GITAssignRemoteBranchCommand.this._dialog.setOKButtonEnabled(false);
                            return;
                        }
                        GitClient client = null;
                        try {
                            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Branch");
                            client = GITClientAdaptor.getClient(GITTrackingPanel.this._url);
                            GitRevisionInfo info = client.log(name, (ProgressMonitor)monitor);
                            GITTrackingPanel.this._fldCommit.setText(info.getRevision());
                            GITTrackingPanel.this._fldAuthor.setText(info.getCommitter().getName());
                            GITTrackingPanel.this._fldMessage.setText(info.getFullMessage());
                            GITAssignRemoteBranchCommand.this._dialog.setOKButtonEnabled(true);
                        }
                        catch (Exception f) {
                            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)f, (String)Resource.format("ACTION_BRANCH_ERROR", name));
                        }
                        finally {
                            if (client != null) {
                                client.release();
                            }
                        }
                    }
                }
            });
        }

        private Component getDefaultComp() {
            return this._panelBranch;
        }
    }
}

