/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitTag;

public class GITTagNode
extends Node
implements GITRemote {
    private GitTag _tag;
    private URL _toolUrl;

    GITTagNode(GitTag gitTag, URL url) {
        this._tag = gitTag;
        this._toolUrl = url;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(url));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return this._tag.getTagName();
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("TAG_NAME_ICON")));
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._toolUrl);
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public GitTag getTagInfo() {
        return this._tag;
    }

    @Override
    public boolean canRefresh() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITTagNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

