/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.awt.Component;
import java.net.URL;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.BaseConnectionProvider;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.wiz.GITCloneWizard;

public final class GITConnectionProvider
extends BaseConnectionProvider {
    public Node getConnectionListNode() {
        GITRepositoryNavigator.getInstance().activate();
        return GITRepositoryNavigator.getInstance().getRepositoriesNode();
    }

    protected boolean createConnection(Map<String, String> criteria, Context context) {
        if (this.isUnderGit(context)) {
            return true;
        }
        GITCloneWizard wizard = new GITCloneWizard();
        try {
            if (wizard.runWizard((Component)Ide.getMainWindow(), context)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITConnectionProvider.class.getName()).warning("Failed to clone git repository ");
            GITProfile.getQualifiedLogger(GITConnectionProvider.class.getName()).warning(e.getMessage());
        }
        return false;
    }

    protected ConnectionListFilterNode createConnectionListFilterNode() {
        return null;
    }

    protected Element createConnectionFilterNode(ConnectionNode connectionNode, ConnectionFilter filter) {
        return null;
    }

    private boolean isUnderGit(Context context) {
        URL url = null;
        if (context.getNode() != null) {
            url = context.getNode().getURL();
        } else if (context.getElement() != null && context.getElement() instanceof Locatable) {
            url = ((Locatable)context.getElement()).getURL();
        }
        if (url == null) {
            return false;
        }
        return GITUtil.getRootContaining(url) != null;
    }
}

