/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.imp;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.imp.GITImportWizard;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;

public class GITImport {
    public GitClient initializeRepositoy(URL url, GITCommandProgressMonitor monitor, VCSCancellable cancel) throws GITProcessException, VCSCancelException {
        GitClient client;
        File file = new File(url.getPath());
        try {
            client = GitRepository.getInstance(file).createClient();
            monitor.setLog(true);
            client.init(monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.format("IMPORT_ERROR_INIT", URLFileSystem.getPlatformPathName((URL)url)), monitor.getError());
            }
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, ex.getMessage());
            throw new GITProcessException(Resource.format("IMPORT_ERROR_INIT", URLFileSystem.getPlatformPathName((URL)url)), ex);
        }
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        return client;
    }

    public Collection<URL> getFilesToVersion(URL url, Collection<String> filters, VCSCancellable cancel) throws VCSCancelException {
        PatternURLFilter filterPattern = new PatternURLFilter(filters);
        ArrayList<URL> files = new ArrayList<URL>();
        URLFilterVersion filter = new URLFilterVersion(filterPattern);
        this.findAllFiles(url, filter, files, cancel);
        return files;
    }

    public void addToRepository(GitClient client, Collection<URL> files, GITCommandProgressMonitor monitor, VCSCancellable cancel) throws GITProcessException, VCSCancelException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        if (files.size() == 0) {
            return;
        }
        URL[] urls = files.toArray(new URL[0]);
        monitor.setLog(true);
        try {
            Collection<File> gfiles = GITUtil.convertURLToFile(urls);
            client.add(gfiles.toArray(new File[0]), monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.get("IMPORT_ERROR_ADD"), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GITProcessException(Resource.get("IMPORT_ERROR_ADD"), e);
        }
    }

    public void commitToRepository(GitClient client, Collection<URL> files, String comment, GITCommandProgressMonitor monitor, VCSCancellable cancel) throws VCSCancelException, GITProcessException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        if (files.size() == 0) {
            return;
        }
        URL[] urls = files.toArray(new URL[0]);
        monitor.setLog(true);
        try {
            Collection<File> gfiles = GITUtil.convertURLToFile(urls);
            client.commit(gfiles.toArray(new File[0]), comment, client.getUser(), client.getUser(), monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.get("IMPORT_ERROR_COMMIT"), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GITProcessException(Resource.get("IMPORT_ERROR_COMMIT"), e);
        }
    }

    private void findAllFiles(URL url, URLFilter filter, Collection<URL> files, VCSCancellable cancel) throws VCSCancelException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        URL[] urls = URLFileSystem.list((URL)url, (URLFilter)filter);
        for (int u = 0; u < urls.length; ++u) {
            if (URLFileSystem.isDirectoryPath((URL)urls[u])) {
                this.findAllFiles(urls[u], filter, files, cancel);
                continue;
            }
            files.add(urls[u]);
        }
    }

    private static class URLFilterVersion
    implements URLFilter {
        final PatternURLFilter _pattern;

        private URLFilterVersion(PatternURLFilter patternURLFilter) {
            this._pattern = patternURLFilter;
        }

        public boolean accept(URL url) {
            return this._pattern.accept(url);
        }
    }
}

