/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commithistory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.util.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.DateComparator;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.commithistory.CommitCancel;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryDetail;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryItem;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryTableModel;
import oracle.jdeveloper.vcs.commithistory.CommitVersionDockableWindow;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITCommitHistoryHook;
import oracle.jdevimpl.vcs.git.GITHistoryLink;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompareWindow;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionCompare;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionController;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionMenuListener;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;

public class GITCommitVersionDockableWindow
extends CommitVersionDockableWindow {
    private static HelpInfo F1_HELP_ID = new HelpInfo("f1_git_commit_history_html");
    private static String HISTORYLINK = "HistoryLink";
    public static final String COMMIT_GIT_ROOT = "commit-git-root";
    public static final String COMMIT_GIT_BRANCH_NAME = "commit-git-branch-name";
    public static final String COMMIT_GIT_TAG_NAME = "commit-git-tag-name";
    private static final String HISTORY_TABLE_SETTINGS = "history-settings";
    private static Map<GitRevisionInfo.GitFileInfo.Status, String> _editType = new HashMap<GitRevisionInfo.GitFileInfo.Status, String>();
    private static URL _gitRoot;
    private boolean _branchTagBusy = false;
    private BranchTagComponent _branchTagUI;
    private Action _linkAction;

    public GITCommitVersionDockableWindow(String viewId) {
        super(viewId);
        _editType.put(GitRevisionInfo.GitFileInfo.Status.ADDED, Resource.get("FILE_EDIT_ADD"));
        _editType.put(GitRevisionInfo.GitFileInfo.Status.COPIED, Resource.get("FILE_EDIT_COPIED"));
        _editType.put(GitRevisionInfo.GitFileInfo.Status.MODIFIED, Resource.get("FILE_EDIT_MODIFIED"));
        _editType.put(GitRevisionInfo.GitFileInfo.Status.REMOVED, Resource.get("FILE_EDIT_REMOVED"));
        _editType.put(GitRevisionInfo.GitFileInfo.Status.RENAMED, Resource.get("FILE_EDIT_RENAMED"));
        _editType.put(GitRevisionInfo.GitFileInfo.Status.UNKNOWN, Resource.get("FILE_EDIT_UNKNOWN"));
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (Boolean.getBoolean("ide.vcs.noapplications") || Product.isRaptor()) {
                    return;
                }
                if (change.getMessageID() != IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    return;
                }
                Project prj = (Project)change.getModifyObjects().get(0);
                if (prj == null) {
                    return;
                }
                URL root = GITUtil.getGitClientRoot(prj);
                if (root != null && !URLFileSystem.equals((URL)_gitRoot, (URL)root)) {
                    GITCommitVersionDockableWindow.this.clear();
                    _gitRoot = root;
                    GITCommitVersionDockableWindow.this.refresh();
                }
            }
        });
        this.setType(32);
    }

    public HelpInfo getHelpInfo() {
        return F1_HELP_ID;
    }

    public String getTitleName() {
        return Resource.get("COMMIT_HISTORY_TAB_NAME");
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        context.setProperty(COMMIT_GIT_ROOT, (Object)_gitRoot);
        DataItem item = this.getBranchTag().getSelectItem();
        if (item != null) {
            if (item.getType() == DataType.BRANCH) {
                context.setProperty(COMMIT_GIT_BRANCH_NAME, (Object)(item != null ? item.getName() : null));
            } else {
                context.setProperty(COMMIT_GIT_TAG_NAME, (Object)(item != null ? item.getName() : null));
            }
        }
        return context;
    }

    protected String getSettingsKey() {
        return HISTORY_TABLE_SETTINGS;
    }

    protected String getThobberLabel() {
        return Resource.get("COMMIT_HISTORY_PROGRESS");
    }

    protected Toolbar getToolbarImpl() {
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        toolbar.add((Component)this.getBranchTag().getUIButton());
        toolbar.addSeparator();
        toolbar.add((ToggleAction)this.getLocalAction(51));
        toolbar.addSeparator();
        toolbar.add((Component)this.getPathCheckBox());
        return toolbar;
    }

    protected Controller createController() {
        return new GITCommitVersionController();
    }

    protected ContextMenuListener getContextMenuListener() {
        return new GITCommitVersionMenuListener();
    }

    protected void setSelectedCommitId(String commitId) {
        int selected = this.getCommitTable().getSelectedRowInModel();
        if (selected < 0) {
            this.setCommitSelection(commitId);
        } else {
            String revId = (String)this.getCommitTable().getValueAt(selected, 0);
            if (!revId.equals(commitId)) {
                this.setCommitSelection(commitId);
            }
        }
    }

    protected CommitHistoryDetail getCommitVersionDetail(Object userObject, CommitCancel cancel) throws VCSException {
        if (userObject instanceof GitRevisionInfo) {
            GitRevisionInfo info = (GitRevisionInfo)userObject;
            Map<String, Pair<Integer, Integer>> contentChanges = null;
            CommitHistoryDetail detail = new CommitHistoryDetail();
            detail.setRevId(info.getRevision());
            detail.setMessage(info.getFullMessage());
            boolean merge = info.getParents().length > 1;
            try {
                Map<File, GitRevisionInfo.GitFileInfo> files = info.getModifiedFiles();
                for (File file : files.keySet()) {
                    GitRevisionInfo.GitFileInfo fInfo = files.get(file);
                    if (contentChanges == null) {
                        contentChanges = this.getCommitFileDetails(file, info.getRevision(), merge);
                    }
                    GitRevisionInfo.GitFileInfo revInfo = files.get(file);
                    Pair<Integer, Integer> noLinesChanges = contentChanges.get(fInfo.getRelativePath());
                    if (noLinesChanges == null) {
                        detail.addFile(revInfo.getRelativePath(), _editType.get((Object)revInfo.getStatus()), "", "");
                        continue;
                    }
                    Object add = "";
                    if ((Integer)noLinesChanges.getFirst() > 0) {
                        add = "+" + ((Integer)noLinesChanges.getFirst()).toString();
                    }
                    Object del = "";
                    if ((Integer)noLinesChanges.getSecond() > 0) {
                        del = "-" + ((Integer)noLinesChanges.getSecond()).toString();
                    }
                    detail.addFile(revInfo.getRelativePath(), _editType.get((Object)revInfo.getStatus()), (String)add, (String)del);
                }
            }
            catch (Exception e) {
                GITProfile.getQualifiedLogger(GITCommitVersionDockableWindow.class.getName()).log(Level.WARNING, e.getMessage());
                throw new GITProcessException(Resource.format("COMMIT_HISTORY_FAIL_FAILS", info.getRevision()), e);
            }
            return detail;
        }
        return null;
    }

    protected void createLocalActions() {
        int mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_COMMIT_VERSION_COMPARE"));
        IdeAction action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)GITCommitVersionCompare.COMMAND_ID), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"), GITCommitVersionCompare.COMMAND_ID), (String)Resource.get("MENU_COMMIT_VERSION_COMPARE"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(this.getController());
        mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_COMMIT_VERSION_TAG"));
        action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)"oracle.jdeveloper.git.commithistory.createtag"), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"), "oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionCreateTag"), (String)Resource.get("MENU_COMMIT_VERSION_TAG"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(this.getController());
        mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_COMMIT_VERSION_TAG"));
        action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)"oracle.jdeveloper.git.commithistory.exportcommit"), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"), "oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionExport"), (String)Resource.get("MENU_COMMIT_VERSION_EXPORT"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(this.getController());
    }

    protected Pair<String, Action> getLinkTextFromMessage(String message) {
        Collection<GITHistoryLink> providers = this.getHistoryLinkProviders();
        for (final GITHistoryLink provider : providers) {
            Pattern pt = Pattern.compile(provider.getPattern());
            Matcher matcher = pt.matcher(message);
            if (!matcher.find()) continue;
            final String text = message.substring(matcher.start(), matcher.end());
            if (this._linkAction == null) {
                this._linkAction = new HistoryLinkAction();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITCommitVersionDockableWindow.this._linkAction.putValue("Name", text);
                    GITCommitVersionDockableWindow.this._linkAction.putValue(HISTORYLINK, provider);
                }
            });
            return new Pair((Object)provider.getProvider().getLabel(), (Object)this._linkAction);
        }
        return null;
    }

    protected String getCommitId(CommitHistoryItem item) {
        if (item.getUserObject() instanceof GitRevisionInfo) {
            return ((GitRevisionInfo)item.getUserObject()).getRevision();
        }
        return null;
    }

    protected String getClipBoardValue(ActionEvent e) {
        GenericTable table = (GenericTable)e.getSource();
        int row = table.getSelectedRowInModel();
        StringBuilder sb = new StringBuilder();
        for (int col = 0; col < table.getModel().getColumnCount(); ++col) {
            Object value = table.getModel().getValueAt(row, col);
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    sb.append(obj);
                    sb.append(" ");
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object obj : (Object[])value) {
                    sb.append(obj);
                    sb.append(" ");
                }
                continue;
            }
            sb.append(value);
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean extendClipboard() {
        return true;
    }

    private Collection<GITHistoryLink> getHistoryLinkProviders() {
        oracle.ide.ExtensionRegistry registry = oracle.ide.ExtensionRegistry.getExtensionRegistry();
        GITCommitHistoryHook historyHook = (GITCommitHistoryHook)registry.getHook(new ElementName("http://xmlns.oracle.com/ide/extension", "git-history-hook"));
        Collection<GITHistoryLink> links = historyHook.getProviders();
        return links;
    }

    private void clear() {
        _gitRoot = null;
        this.getBranchTag().clear();
        this.clearPath();
    }

    protected final void refresh() {
        this.showMessage(Resource.get("COMMIT_HISTORY_PROGRESS"));
        this.refreshImpl(true);
    }

    private void setCommitSelection(String commitId) {
        this.getCommitTable().getSelectionModel().clearSelection();
        this.resetCommitDetail();
        for (int r = 0; r < this.getCommitTable().getModel().getRowCount(); ++r) {
            String id = (String)this.getCommitTable().getModel().getValueAt(r, 0);
            if (!id.equals(commitId)) continue;
            this.getCommitTable().setSelectedRowInModel(r);
            JViewport viewport = (JViewport)this.getCommitTable().getParent();
            int vrow = this.getCommitTable().convertRowIndexToView(r);
            Rectangle rect = this.getCommitTable().getCellRect(vrow, 0, true);
            Point pt = viewport.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            viewport.scrollRectToVisible(rect);
        }
    }

    private void refreshImpl(final boolean all) {
        SwingWorker<Runnable, Object> worker = new SwingWorker<Runnable, Object>(){
            private Exception _e;

            @Override
            protected Runnable doInBackground() throws Exception {
                return this._doInBackground();
            }

            @Override
            protected void done() {
                if (this._e != null) {
                    GITCommitVersionDockableWindow.this.showMessage(this._e.getMessage());
                }
                try {
                    Runnable r = (Runnable)this.get();
                    if (r != null) {
                        r.run();
                    } else {
                        GITCommitVersionDockableWindow.this.getBranchTag().setName("", false);
                        GITCommitVersionDockableWindow.this.showMessage(Resource.get("HISTORY_COMMIT_NOT_FOUND"));
                    }
                }
                catch (Exception ex) {
                    GITCommitVersionDockableWindow.this.showMessage(ex.getMessage());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Runnable _doInBackground() throws GitException {
                GitClient client = this.getGitClient();
                if (client == null) {
                    return null;
                }
                try {
                    final HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>();
                    branches.putAll(this.getBranches(client));
                    DataItem selection = GITCommitVersionDockableWindow.this.getBranchTag().getSelectItem();
                    final String activeBranch = this.getDefaultBranch(branches);
                    final HashMap<String, GitTag> tags = new HashMap<String, GitTag>();
                    tags.putAll(this.getTags(client));
                    String id = this.findId(selection, branches, tags);
                    if (id == null) {
                        selection = null;
                    }
                    final List<CommitHistoryItem> items = this.getCommitLog(client, selection == null ? activeBranch : id, this.getLogLimit());
                    boolean moreAvailable = items.size() == this.getLogLimit();
                    final DataItem selected = selection;
                    if (selected == null && activeBranch == null) {
                        Runnable runnable = null;
                        return runnable;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public final void run() {
                            try {
                                TableModel model;
                                String branch = null;
                                if (selected == null) {
                                    branch = activeBranch;
                                } else if (selected.getType() == DataType.BRANCH) {
                                    branch = selected.getName();
                                }
                                if (all) {
                                    GITCommitVersionDockableWindow.this._branchTagBusy = true;
                                    GITCommitVersionDockableWindow.this.getBranchTag().setBranches(branches, branch);
                                    GITCommitVersionDockableWindow.this.getBranchTag().setTags(tags, selected != null && selected.getType() == DataType.TAG ? selected.getName() : null);
                                    GITCommitVersionDockableWindow.this.getBranchTag().setName(branch != null ? branch : selected.getName(), branch != null);
                                    GITCommitVersionDockableWindow.this._branchTagBusy = false;
                                }
                                if (!((model = GITCommitVersionDockableWindow.this.getCommitTable().getModel()) instanceof CommitHistoryTableModel)) {
                                    DisplayProperty[] properties = this.getDisplayProperties();
                                    model = new CommitHistoryTableModel(properties);
                                    GITCommitVersionDockableWindow.this.installTableModel((CommitHistoryTableModel)model);
                                    this.addTableRenderer();
                                }
                                GITCommitVersionDockableWindow.this.getCommitTable().setSorted(items.size() > 1);
                                ((CommitHistoryTableModel)model).addItems(items);
                                GITCommitVersionDockableWindow.this.resetCommitDetail();
                                GITCommitVersionDockableWindow.this.showResults();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                _e = new Exception(Resource.get("COMMIT_HISTORY_ERROR"), e);
                                GITProfile.getQualifiedLogger(GITBranchCompareWindow.class.getName()).log(Level.WARNING, "_doInBackground - " + e.toString());
                            }
                        }
                    };
                    return runnable;
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }

            private String findId(DataItem selected, Map<String, GitBranch> branches, Map<String, GitTag> tags) {
                if (selected == null) {
                    return null;
                }
                if (selected.getType() == DataType.BRANCH) {
                    return branches.containsKey(selected.getName()) ? branches.get(selected.getName()).getId() : null;
                }
                if (selected.getType() == DataType.TAG) {
                    return tags.containsKey(selected.getName()) ? tags.get(selected.getName()).getTagId() : null;
                }
                return null;
            }

            private void addTableRenderer() {
                GITCommitVersionDockableWindow.this.getCommitTable().setDefaultRenderer(Object.class, (TableCellRenderer)new GITHistoryTableRenderer());
            }

            private GitClient getGitClient() throws GitException {
                if (GITCommitVersionDockableWindow.this.getDirectoryURL() != null) {
                    _gitRoot = GITUtil.getRootContaining(GITCommitVersionDockableWindow.this.getDirectoryURL());
                } else if (_gitRoot == null) {
                    _gitRoot = GITUtil.getClientRoot();
                }
                if (_gitRoot == null) {
                    return null;
                }
                return GITClientAdaptor.getClient(_gitRoot);
            }

            private Map<String, GitBranch> getBranches(GitClient client) throws GitException {
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
                return client.getBranches(false, monitor);
            }

            private Map<String, GitTag> getTags(GitClient client) throws GitException {
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("tags");
                return client.getTags(monitor, false);
            }

            private List<CommitHistoryItem> getCommitLog(GitClient client, String branch, int limit) throws GitException.MissingObjectException, GitException {
                ArrayList<CommitHistoryItem> items = new ArrayList<CommitHistoryItem>();
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
                URL dirUrl = GITCommitVersionDockableWindow.this.getDirectoryURL();
                SearchCriteria sc = new SearchCriteria();
                sc.setRevisionTo(branch);
                sc.setFollowRenames(true);
                sc.setIncludeMerges(true);
                sc.setLimit(limit);
                if (dirUrl != null) {
                    sc.setFiles(new File[]{new File(dirUrl.getPath())});
                }
                GitRevisionInfo[] infos = client.log(sc, true, monitor);
                for (int g = 0; g < infos.length; ++g) {
                    Object[] obj = new Object[]{infos[g].getRevision(), infos[g].getCommitter().getName(), new Date(infos[g].getCommitTime()), infos[g].getShortMessage(), infos[g].getParents()};
                    CommitHistoryItem item = new CommitHistoryItem(obj, (Object)infos[g]);
                    items.add(item);
                }
                return items;
            }

            private DisplayProperty[] getDisplayProperties() {
                DisplayProperty[] props = new DisplayProperty[]{new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_COMMIT_ID"), null, 2, (Object)" AAAAAA ", null, String.class, 50), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_COMMITTER"), null, 2, (Object)" Fred Flintstone ", null, String.class, 75), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_DATE"), null, 2, (Object)" 01-jan-2000 00:00:00 ", (Comparator)DateComparator.getInstance(), Date.class, 125), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_MESSAGE_TAB"), null, 2, (Object)" This is the commit message here ", null, String.class, 200), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_PARENT_ID"), null, 2, (Object)" AAAAAA ", null, Collection.class, 50)};
                return props;
            }

            private String getDefaultBranch(Map<String, GitBranch> branches) {
                for (String key : branches.keySet()) {
                    GitBranch branch = branches.get(key);
                    if (!branch.isActive() || branch.getName().equals("(no branch)")) continue;
                    return key;
                }
                if (branches.containsKey("master")) {
                    return "master";
                }
                if (branches.keySet().size() > 0) {
                    return branches.keySet().toArray(new String[0])[0];
                }
                return null;
            }

            private int getLogLimit() {
                String num = System.getProperty("git-commit-version-limit", "500");
                try {
                    return Integer.parseInt(num);
                }
                catch (NumberFormatException nfe) {
                    return 500;
                }
            }
        };
        this.showProgress();
        worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pair<Integer, Integer>> getCommitFileDetails(File file, String revision, boolean merge) throws GitException, MalformedURLException, IOException {
        if (merge) {
            return Collections.emptyMap();
        }
        HashMap<String, Pair<Integer, Integer>> details = new HashMap();
        BufferedReader reader = null;
        GitClient client = GITClientAdaptor.getClient(file.toURI().toURL());
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("export");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            client.exportCommit(revision, stream, monitor);
            details = this.getFileDifferences(stream);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            client.release();
        }
        return details;
    }

    private BranchTagComponent getBranchTag() {
        if (this._branchTagUI == null) {
            this._branchTagUI = new BranchTagComponent();
        }
        return this._branchTagUI;
    }

    private class BranchTagComponent
    implements ListSelectionListener {
        private JPanel _content;
        private HistoryPopupButton _button;
        private SearchField _fldSearch;
        private GenericTable _branchTable;
        private GenericTable _tagTable;
        private JCheckBoxMenuItem _branch;
        private JCheckBoxMenuItem _tag;
        private Component _focus;
        private Comparator _dataitemComparator = new DataItemComparator();

        BranchTagComponent() {
            this._button = new HistoryPopupButton(this.getContentPopup());
        }

        private DataItem getSelectItem() {
            int modIndex;
            DataItem item = null;
            int index = this._branchTable.getSelectedRow();
            if (index >= 0) {
                modIndex = this._branchTable.convertRowIndexToModel(index);
                item = (DataItem)this._branchTable.getModel().getValueAt(modIndex, 0);
            }
            if (item != null) {
                return item;
            }
            index = this._tagTable.getSelectedRow();
            if (index >= 0) {
                modIndex = this._tagTable.convertRowIndexToModel(index);
                item = (DataItem)this._tagTable.getModel().getValueAt(modIndex, 0);
            }
            return item;
        }

        private JComponent getUIButton() {
            return this._button;
        }

        private JComponent getContentPopup() {
            if (this._content != null) {
                return this._content;
            }
            Insets ins = new Insets(5, 5, 5, 5);
            this._content = new JPanel(new GridBagLayout());
            this._fldSearch = new SearchField();
            this._fldSearch.setPrompt(Resource.get("COMMIT_HISTORY_SEARCH_PROMPT"));
            this._fldSearch.setStyle(SearchField.Style.FILTER);
            this._fldSearch.addCategoryMenuItem(this.getBranchMenu());
            this._fldSearch.addCategoryMenuItem(this.getTagMenu());
            this._fldSearch.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    this.searchFor(BranchTagComponent.this.getBranchMenu().isSelected(), BranchTagComponent.this.getTagMenu().isSelected());
                }

                public void searchCategoryChanged(SearchEvent se) {
                }

                private void searchFor(boolean branch, boolean tag) {
                    if (branch) {
                        ((AbstractTableModel)BranchTagComponent.this._branchTable.getModel()).fireTableDataChanged();
                    }
                    if (tag) {
                        ((AbstractTableModel)BranchTagComponent.this._tagTable.getModel()).fireTableDataChanged();
                    }
                }
            });
            this._branchTable = new GenericTable((TableModel)new BranchTagModel(Resource.get("COMMIT_HISTORY_BRANCH")));
            this._branchTable.setSorted(true);
            this._branchTable.setSortColumn(0, true);
            this._branchTable.setColumnSelectorAvailable(false);
            this._branchTable.setDefaultRenderer(Object.class, (TableCellRenderer)new HistoryTableCellRenderer());
            this.setBranchFilter();
            JScrollPane paneBranch = new JScrollPane((Component)this._branchTable);
            paneBranch.setHorizontalScrollBarPolicy(31);
            this._tagTable = new GenericTable((TableModel)new BranchTagModel(Resource.get("COMMIT_HISTORY_TAG")));
            this._tagTable.setSorted(true);
            this._tagTable.setSortColumn(0, true);
            this._tagTable.setColumnSelectorAvailable(false);
            this._tagTable.setDefaultRenderer(Object.class, (TableCellRenderer)new HistoryTableCellRenderer());
            this.setTagFilter();
            JScrollPane paneTag = new JScrollPane((Component)this._tagTable);
            paneTag.setHorizontalScrollBarPolicy(31);
            this._content.add((Component)this._fldSearch, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this._content.add((Component)paneBranch, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
            this._content.add((Component)paneTag, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
            this._branchTable.setSelectionMode(0);
            this._tagTable.setSelectionMode(0);
            this._branchTable.getSelectionModel().addListSelectionListener(this);
            this._tagTable.getSelectionModel().addListSelectionListener(this);
            this._branchTable.addMouseListener((MouseListener)new MouseAdapterImpl(this._branchTable));
            this._tagTable.addMouseListener((MouseListener)new MouseAdapterImpl(this._tagTable));
            Dimension d = new Dimension(250, 170);
            this._content.setPreferredSize(d);
            return this._content;
        }

        private Component getFocusComponent() {
            return this._focus;
        }

        private void setBranchFilter() {
            TableRowSorter sorter = (TableRowSorter)this._branchTable.getRowSorter();
            sorter.setRowFilter(new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object id;
                    DataItem value;
                    return !BranchTagComponent.this._branch.isSelected() || (value = (DataItem)entry.getValue((Integer)(id = entry.getIdentifier()))).getName().contains(BranchTagComponent.this._fldSearch.getText());
                }
            });
        }

        private void setTagFilter() {
            TableRowSorter sorter = (TableRowSorter)this._tagTable.getRowSorter();
            sorter.setRowFilter(new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object id;
                    DataItem value;
                    return !BranchTagComponent.this._tag.isSelected() || (value = (DataItem)entry.getValue((Integer)(id = entry.getIdentifier()))).getName().contains(BranchTagComponent.this._fldSearch.getText());
                }
            });
        }

        private void setBranches(Map<String, GitBranch> branches, String selected) {
            ArrayList<DataItem> listBranches = new ArrayList<DataItem>();
            DataItem selectedBranch = null;
            Iterator<String> it = branches.keySet().iterator();
            while (it.hasNext()) {
                GitBranch branch = branches.get(it.next());
                if (branch.getName().equals("(no branch)")) continue;
                DataItem item = new DataItem(DataType.BRANCH, branch.getName(), branch.getId());
                listBranches.add(item);
                if (selected == null || !selected.equals(branch.getName())) continue;
                selectedBranch = item;
            }
            BranchTagModel model = (BranchTagModel)this._branchTable.getModel();
            model.clear();
            this._branchTable.setSorted(listBranches.size() > 1);
            Collections.sort(listBranches, this._dataitemComparator);
            model.addAll(listBranches);
            if (selectedBranch != null) {
                this._branchTable.setSelectedRowInModel(((BranchTagModel)this._branchTable.getModel()).findRow(selectedBranch));
                this._focus = this._branchTable;
            }
        }

        private void setTags(Map<String, GitTag> tags, String selected) {
            ArrayList<DataItem> listTags = new ArrayList<DataItem>();
            DataItem selectedTag = null;
            Iterator<String> it = tags.keySet().iterator();
            while (it.hasNext()) {
                GitTag tag = tags.get(it.next());
                DataItem item = new DataItem(DataType.TAG, tag.getTagName(), tag.getTagId());
                listTags.add(item);
                if (selected == null || !selected.equals(tag.getTagName())) continue;
                selectedTag = item;
            }
            BranchTagModel model = (BranchTagModel)this._tagTable.getModel();
            model.clear();
            this._tagTable.setSorted(listTags.size() > 1);
            Collections.sort(listTags, this._dataitemComparator);
            model.addAll(listTags);
            if (selectedTag != null) {
                this._tagTable.setSelectedRowInModel(((BranchTagModel)this._tagTable.getModel()).findRow(selectedTag));
                this._focus = this._tagTable;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (GITCommitVersionDockableWindow.this._branchTagBusy) {
                return;
            }
            if (e.getSource() == this._branchTable.getSelectionModel()) {
                this._tagTable.clearSelection();
            } else {
                this._branchTable.clearSelection();
            }
        }

        private void setName(String name, boolean branch) {
            this._button.setText(name);
            if (branch) {
                this._button.setIcon(OracleIcons.getIcon((String)"branch.png"));
            } else {
                this._button.setIcon(ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("TAG_NAME_ICON"))));
            }
        }

        private void clear() {
            ((BranchTagModel)this._branchTable.getModel()).clear();
            ((BranchTagModel)this._tagTable.getModel()).clear();
        }

        private JCheckBoxMenuItem createCheckBoxMenu(String label) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            item.setSelected(true);
            ResourceUtils.resButton((AbstractButton)item, (String)label);
            return item;
        }

        private JMenuItem getBranchMenu() {
            if (this._branch == null) {
                this._branch = this.createCheckBoxMenu(Resource.get("BRANCH_MENU"));
            }
            return this._branch;
        }

        private JMenuItem getTagMenu() {
            if (this._tag == null) {
                this._tag = this.createCheckBoxMenu(Resource.get("TAG_MENU"));
            }
            return this._tag;
        }

        private class DataItemComparator
        implements Comparator {
            private DataItemComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof DataItem)) {
                    return -1;
                }
                if (!(o2 instanceof DataItem)) {
                    return 1;
                }
                return ((DataItem)o1).getName().compareTo(((DataItem)o2).getName());
            }
        }

        private class HistoryPopupButton
        extends PopupButton {
            private HistoryPopupButton(JComponent content) {
                super(content);
            }

            protected void hidePopup() {
                DataItem item = GITCommitVersionDockableWindow.this.getBranchTag().getSelectItem();
                if (item != null) {
                    GITCommitVersionDockableWindow.this.getBranchTag().setName(item.getName(), item.getType() == DataType.BRANCH);
                }
                super.hidePopup();
                GITCommitVersionDockableWindow.this.refreshImpl(false);
            }

            protected void showPopup() {
                super.showPopup();
                if (BranchTagComponent.this.getFocusComponent() != null) {
                    BranchTagComponent.this.getFocusComponent().requestFocus();
                }
            }
        }

        private class BranchTagModel
        extends AbstractTableModel {
            private List<DataItem> _items = new ArrayList<DataItem>();
            private String _columnName;

            BranchTagModel(String column) {
                this._columnName = column;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public String getColumnName(int column) {
                return this._columnName;
            }

            @Override
            public int getRowCount() {
                return this._items.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex < this._items.size()) {
                    return this._items.get(rowIndex);
                }
                return null;
            }

            private void addColumn(String col) {
                this._columnName = col;
            }

            private void addAll(Collection<DataItem> items) {
                if (items.size() > 0) {
                    this._items.addAll(items);
                    this.fireTableRowsInserted(0, items.size() - 1);
                }
            }

            private void clear() {
                int size = this._items.size();
                if (size > 0) {
                    this._items.clear();
                    this.fireTableRowsDeleted(0, size - 1);
                }
            }

            private int findRow(DataItem item) {
                for (int r = 0; r < this._items.size(); ++r) {
                    if (!this._items.get(r).equals(item)) continue;
                    return r;
                }
                return -1;
            }
        }

        private class HistoryTableCellRenderer
        extends DefaultTableCellRenderer {
            private HistoryTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel && value instanceof DataItem) {
                    if (((DataItem)value).getType() == DataType.BRANCH) {
                        ((JLabel)c).setIcon(OracleIcons.getIcon((String)"branch.png"));
                    } else {
                        ((JLabel)c).setIcon(ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("TAG_NAME_ICON"))));
                    }
                }
                return c;
            }
        }

        private class MouseAdapterImpl
        extends MouseAdapter {
            GenericTable _table;

            private MouseAdapterImpl(GenericTable table) {
                this._table = table;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int index = this._table.rowAtPoint(e.getPoint());
                    if (index >= 0) {
                        int row = this._table.convertRowIndexToModel(index);
                        this._table.setSelectedRowInModel(row);
                    }
                    BranchTagComponent.this._button.hidePopup();
                }
            }
        }
    }

    private class DataItem {
        private DataType _type;
        private String _name;
        private String _id;

        DataItem(DataType type, String name, String id) {
            this._type = type;
            this._name = name;
            this._id = id;
        }

        public String toString() {
            return this._name;
        }

        private String getId() {
            return this._id;
        }

        private String getName() {
            return this._name;
        }

        private DataType getType() {
            return this._type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataItem)) {
                return false;
            }
            DataItem di = (DataItem)o;
            return di.getId().equals(this.getId()) && di.getName().equals(this.getName()) && di.getType() == this.getType();
        }
    }

    private static enum DataType {
        BRANCH,
        TAG;

    }

    private class HistoryLinkAction
    extends AbstractAction {
        private HistoryLinkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String hyperLink = (String)this.getValue("Name");
            GITHistoryLink link = (GITHistoryLink)this.getValue(HISTORYLINK);
            link.getProvider().executeHyperlink(_gitRoot, hyperLink);
        }
    }

    private static class GITHistoryTableRenderer
    extends DefaultTableCellRenderer {
        private static DateFormat format = DateFormat.getDateTimeInstance();

        private GITHistoryTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                this.setText(format.format((Date)value));
            } else if (column == 0) {
                this.setText(GITUtil.shortCommitId((String)value));
            } else if (column == 4 && value != null) {
                StringBuilder sb = new StringBuilder();
                for (String id : (String[])value) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(GITUtil.shortCommitId(id));
                }
                this.setText(sb.toString());
            }
            return this;
        }
    }
}

