/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.util.logging.Level;
import oracle.ide.dialogs.ProgressBar;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.git.GITProfile;

abstract class GITRunnable
implements Runnable {
    private ProgressBar _progress;
    private VCSCancellable _cancel;
    private Exception _exception;

    GITRunnable() {
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (Exception ex) {
            GITProfile.getQualifiedLogger(GITRunnable.class.getName()).log(Level.WARNING, "Failed to get file for Commit " + ex.getMessage());
            this._exception = ex;
        }
        finally {
            if (this._progress != null) {
                this._progress.setDoneStatus();
            }
        }
    }

    void setProgress(ProgressBar progress) {
        this._progress = progress;
    }

    public abstract void runImpl() throws Exception;

    void setCancellable(VCSCancellable cancel) {
        this._cancel = cancel;
    }

    public VCSCancellable getCancellable() {
        return this._cancel;
    }

    boolean hasException() {
        return this._exception != null;
    }

    Exception getException() {
        return this._exception;
    }
}

